/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try1;

import c.builder.CBuilder;
import c.model.ArrayType;
import c.model.AssignmentStmt;
import c.model.CastExpression;
import c.model.Expression;
import c.model.ExternalType;
import c.model.ForStmt;
import c.model.FunctionCall;
import c.model.IndexedExpression;
import c.model.Statement;
import c.model.StatementGroup;
import c.model.StructureDereference;
import c.model.Type;
import c.model.UnaryExpression;
import c.model.VariableDeclaration;
import c.model.VariableReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.ffi.try1.FFIBindingGenerator;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayedType;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.transfo.FiacreStaticEvaluator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TFiacre2CMarshaller
extends ModelVisitor.Stub {
    FFIBindingGenerator client;
    CBuilder cBuilder;
    StatementGroup marshallStmts;
    StatementGroup releaseStmts;
    Stack<String> absoluteNameStack = new Stack();
    Stack<Object> fcrContext = new Stack();
    Stack<VariableDeclaration> jniObjectContext = new Stack();
    Stack<VariableDeclaration> jniClassContext = new Stack();
    Stack<VariableDeclaration> jniFieldIdContext = new Stack();
    Stack<Integer> jniIndexContext = new Stack();
    Map<Object, VariableDeclaration> valueMap = new HashMap<Object, VariableDeclaration>();
    Map<Object, VariableDeclaration> objectMap = new HashMap<Object, VariableDeclaration>();
    Map<Object, VariableDeclaration> indexMap = new HashMap<Object, VariableDeclaration>();
    Map<String, VariableDeclaration> absoluteName2object = new HashMap<String, VariableDeclaration>();
    Map<String, VariableDeclaration> absoluteName2index = new HashMap<String, VariableDeclaration>();
    Map<Object, String> jniTypeSignature = new HashMap<Object, String>();
    private Object root;
    Stack<StatementGroup> marshallStack = new Stack();
    Stack<StatementGroup> releaseStack = new Stack();
    Stack<Expression> releaseValueStack = new Stack();

    public TFiacre2CMarshaller(Object root, FFIBindingGenerator client, StatementGroup marshallStmts, StatementGroup releaseStmts) {
        this.client = client;
        this.root = root;
        this.marshallStmts = marshallStmts;
        this.releaseStmts = releaseStmts;
        this.cBuilder = client.cBuilder;
    }

    private String newName() {
        return "tmp" + this.client.currentIdx++;
    }

    FunctionCall createJniCall(String memberName) {
        UnaryExpression envP = this.cBuilder.dereference(this.client.referenceTo("env", this.marshallStmts));
        StructureDereference fctMember = this.cBuilder.dereference(envP, memberName);
        FunctionCall fCall = this.cBuilder.functionCall(fctMember);
        fCall.getArguments().add(this.client.referenceTo("env", this.marshallStmts));
        return fCall;
    }

    private void marshallPrimitiveType(obp.fiacre.model.Type toVisit, String typeName) {
        VariableDeclaration var = this.cBuilder.variable(this.newName());
        String TypeName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        this.absoluteNameStack.push(TypeName);
        ExternalType baseType = this.cBuilder.externalType("j" + typeName);
        if (this.inArrayContext() != null) {
            var.setType(this.cBuilder.pointerType(baseType));
            FunctionCall fCall = this.createJniCall("Get" + TypeName + "ArrayElements");
            var.setInitialValue(fCall);
            VariableReference vRef = this.cBuilder.reference(this.jniObjectContext.peek());
            UnaryExpression dRef = this.cBuilder.address(vRef);
            CastExpression cExp = this.cBuilder.cast(this.cBuilder.pointerType(this.cBuilder.externalType("j" + typeName + "Array")), dRef);
            UnaryExpression dRefArray = this.cBuilder.dereference(cExp);
            fCall.getArguments().add(dRefArray);
            fCall.getArguments().add(this.cBuilder.nullLiteral());
            FunctionCall releaseArrayCall = this.createJniCall("Release" + TypeName + "ArrayElements");
            releaseArrayCall.getArguments().add((Expression)EcoreUtil.copy((EObject)dRefArray));
            releaseArrayCall.getArguments().add(this.releaseValueStack.size() < 1 ? this.cBuilder.reference(var) : this.releaseValueStack.peek());
            releaseArrayCall.getArguments().add(this.cBuilder.literal(0));
            this.releaseStmts.getStatements().add(releaseArrayCall);
        } else {
            var.setType(baseType);
            FunctionCall fCall = this.createJniCall("Get" + TypeName + "Field");
            var.setInitialValue(fCall);
            fCall.getArguments().add(this.cBuilder.reference(this.jniObjectContext.peek()));
            fCall.getArguments().add(this.cBuilder.reference(this.jniFieldIdContext.peek()));
        }
        this.marshallStmts.getStatements().add(var);
        this.valueMap.put(toVisit, var);
        this.jniTypeSignature.put(toVisit, typeName.equals("boolean") ? "Z" : "I");
        this.absoluteNameStack.pop();
    }

    private String getAbsoluteName() {
        String result = "";
        for (String s : this.absoluteNameStack) {
            result = result + s + ".";
        }
        return result;
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        this.marshallPrimitiveType(toVisit, "boolean");
    }

    private void marshalInt(obp.fiacre.model.Type toVisit) {
        this.marshallPrimitiveType(toVisit, "int");
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.marshalInt(toVisit);
    }

    @Override
    public void visitField(Field toVisit) {
        this.absoluteNameStack.push(toVisit.getName());
        FunctionCall gfiCall = this.createJniCall("GetFieldID");
        VariableDeclaration fidxVar = this.cBuilder.variable(this.jniObjectContext.peek().getName() + this.jniIndexContext.peek(), this.cBuilder.externalType("jfieldID"), gfiCall);
        gfiCall.getArguments().add(this.cBuilder.reference(this.jniClassContext.peek()));
        gfiCall.getArguments().add(this.cBuilder.literal(toVisit.getName()));
        this.marshallStmts.getStatements().add(fidxVar);
        this.jniFieldIdContext.push(fidxVar);
        toVisit.getType().accept(this);
        this.jniFieldIdContext.pop();
        gfiCall.getArguments().add(this.cBuilder.literal(this.jniTypeSignature.get(toVisit.getType())));
        this.valueMap.put(toVisit, this.valueMap.get(toVisit.getType()));
        this.indexMap.put(toVisit, fidxVar);
        this.absoluteName2index.put(this.getAbsoluteName(), fidxVar);
        this.absoluteNameStack.pop();
    }

    @Override
    public void visitRecord(Record toVisit) {
        this.absoluteNameStack.push("rec");
        String myName = this.newName();
        VariableDeclaration objVar = this.cBuilder.variable(myName + "_o", this.cBuilder.externalType("jobject"));
        if (this.root != null && this.root != toVisit) {
            FunctionCall fCall = null;
            fCall = this.inArrayContext() == null ? this.createJniCall("GetObjectField") : this.createJniCall("GetObjectArrayElement");
            objVar.setInitialValue(fCall);
            fCall.getArguments().add(this.cBuilder.reference(this.jniObjectContext.peek()));
            fCall.getArguments().add(this.cBuilder.reference(this.jniFieldIdContext.peek()));
        } else {
            objVar.setInitialValue(this.client.referenceTo("obj", this.marshallStmts));
        }
        this.marshallStmts.getStatements().add(objVar);
        FunctionCall gocCall = this.createJniCall("GetObjectClass");
        VariableDeclaration classVar = this.cBuilder.variable(myName + "_t", this.cBuilder.externalType("jclass"), gocCall);
        gocCall.getArguments().add(this.cBuilder.reference(objVar));
        this.marshallStmts.getStatements().add(classVar);
        String basePackage = this.client.caller.basePackage == null ? "" : this.client.caller.basePackage.replaceAll("\\.", "/") + "/";
        String typeName = NameUtil.capName(((TypeDecl)this.fcrContext.peek()).getName());
        this.jniTypeSignature.put(toVisit, "L" + basePackage + this.client.caller.packageName + "/" + typeName + ";");
        this.fcrContext.push(toVisit);
        this.jniObjectContext.push(objVar);
        this.jniClassContext.push(classVar);
        int fieldIdx = 0;
        for (Field field : toVisit.getFieldList()) {
            this.jniIndexContext.push(fieldIdx);
            field.accept(this);
            this.jniIndexContext.pop();
            ++fieldIdx;
        }
        this.fcrContext.pop();
        this.jniObjectContext.pop();
        this.jniClassContext.pop();
        if (this.root != null && this.root != toVisit) {
            VariableDeclaration rVar = this.cBuilder.variable(myName, this.client.typeMap.get(toVisit));
            this.marshallStmts.getStatements().add(rVar);
            for (Field field : toVisit.getFieldList()) {
                this.marshallStmts.getStatements().add(this.cBuilder.assign(this.cBuilder.reference(this.cBuilder.reference(rVar), field.getName()), this.cBuilder.reference(this.valueMap.get(field))));
            }
            this.valueMap.put(toVisit, rVar);
        }
        this.objectMap.put(toVisit, objVar);
        this.absoluteName2object.put(this.getAbsoluteName(), objVar);
        this.absoluteNameStack.pop();
    }

    private void marshalArrayedType(ArrayedType toVisit) {
        this.absoluteNameStack.push("arr");
        this.client.hasArray = true;
        String myName = this.newName();
        FunctionCall gofCall = null;
        gofCall = this.inArrayContext() == null ? this.createJniCall("GetObjectField") : this.createJniCall("GetObjectArrayElement");
        VariableDeclaration objVar = this.cBuilder.variable(myName + "_o", this.cBuilder.externalType("jobject"), gofCall);
        gofCall.getComment().add("in array");
        gofCall.getArguments().add(this.cBuilder.reference(this.jniObjectContext.peek()));
        gofCall.getArguments().add(this.cBuilder.reference(this.jniFieldIdContext.peek()));
        this.marshallStmts.getStatements().add(objVar);
        this.releaseStack.push(this.releaseStmts);
        this.releaseStmts = this.cBuilder.block(this.releaseStack.peek().getOwner());
        this.releaseStack.peek().getStatements().add(this.releaseStmts);
        this.releaseStmts.getStatements().add((Statement)EcoreUtil.copy((EObject)objVar));
        int sizeArray = ((NatLiteral)FiacreStaticEvaluator.evaluate(toVisit.getSize())).getValue();
        if (!this.isPrimitiveType(toVisit.getType())) {
            IndexedExpression iExp;
            FunctionCall malloc = this.cBuilder.functionCall("malloc");
            malloc.getArguments().add(this.cBuilder.mult(this.cBuilder.literal(sizeArray), this.cBuilder.sizeOf(this.cBuilder.voidPointerType())));
            VariableDeclaration valueHolder = this.cBuilder.variable(myName + "_cvalue", this.getCType(toVisit, this.client.typeMap), malloc);
            this.marshallStmts.getStatements().add(valueHolder);
            VariableDeclaration sizeA = this.cBuilder.variable(myName + "_size", this.cBuilder.integerType(), this.cBuilder.literal(sizeArray));
            this.marshallStmts.getStatements().add(sizeA);
            this.releaseStmts.getStatements().add((Statement)EcoreUtil.copy((EObject)sizeA));
            VariableDeclaration fID = this.cBuilder.variable(myName + "_idx", this.cBuilder.integerType(), this.cBuilder.literal(0));
            if (this.inArrayContext() == null) {
                iExp = this.cBuilder.indexed(this.cBuilder.reference(valueHolder), this.cBuilder.reference(fID));
                this.releaseValueStack.push(iExp);
            } else {
                iExp = this.cBuilder.indexed(this.releaseValueStack.peek(), this.cBuilder.reference(fID));
                this.releaseValueStack.push(iExp);
            }
            ForStmt forS = this.cBuilder.forStmt(fID, this.cBuilder.lt(this.cBuilder.reference(fID), this.cBuilder.reference(sizeA)), this.cBuilder.assign(this.cBuilder.reference(fID), this.cBuilder.inc(this.cBuilder.reference(fID))));
            ForStmt releaseForS = (ForStmt)EcoreUtil.copy((EObject)forS);
            this.marshallStack.push(this.marshallStmts);
            this.marshallStmts = this.cBuilder.statementGroup(this.marshallStack.peek().getOwner());
            forS.getBody().add(this.marshallStmts);
            this.releaseStack.push(this.releaseStmts);
            this.releaseStmts = this.cBuilder.statementGroup(this.releaseStack.peek().getOwner());
            releaseForS.getBody().add(this.releaseStmts);
            this.jniFieldIdContext.push(fID);
            this.fcrContext.push(toVisit);
            this.jniObjectContext.push(objVar);
            toVisit.getType().accept(this);
            this.jniFieldIdContext.pop();
            VariableReference vRef = this.cBuilder.reference(valueHolder);
            AssignmentStmt idAssign = this.cBuilder.assign(this.cBuilder.indexed(vRef, this.cBuilder.reference(fID)), this.cBuilder.reference(this.valueMap.get(toVisit.getType())));
            this.marshallStmts.getStatements().add(idAssign);
            this.valueMap.put(toVisit, valueHolder);
            this.marshallStmts = this.marshallStack.pop();
            this.marshallStmts.getStatements().add(forS);
            this.releaseStmts = this.releaseStack.pop();
            this.releaseStmts.getStatements().add(releaseForS);
            this.releaseValueStack.pop();
        } else {
            this.fcrContext.push(toVisit);
            this.jniObjectContext.push(objVar);
            toVisit.getType().accept(this);
            this.valueMap.put(toVisit, this.valueMap.get(toVisit.getType()));
        }
        this.releaseStmts = this.releaseStack.pop();
        this.fcrContext.pop();
        this.jniObjectContext.pop();
        this.jniTypeSignature.put(toVisit, "[" + this.jniTypeSignature.get(toVisit.getType()));
        this.absoluteNameStack.pop();
    }

    @Override
    public void visitArray(Array toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitUnion(Union toVisit) {
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.marshalArrayedType(toVisit);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        this.fcrContext.push(toVisit);
        toVisit.getDecl().accept(this);
        this.jniTypeSignature.put(toVisit, this.jniTypeSignature.get(toVisit.getDecl()));
        this.fcrContext.pop();
        this.valueMap.put(toVisit, this.valueMap.get(toVisit.getDecl()));
        this.objectMap.put(toVisit, this.objectMap.get(toVisit.getDecl()));
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        this.absoluteNameStack.push(toVisit.getName());
        this.fcrContext.push(toVisit);
        if (this.root == toVisit) {
            this.root = toVisit.getIs();
        }
        toVisit.getIs().accept(this);
        this.jniTypeSignature.put(toVisit, this.jniTypeSignature.get(toVisit.getIs()));
        this.fcrContext.pop();
        this.valueMap.put(toVisit, this.valueMap.get(toVisit.getIs()));
        this.objectMap.put(toVisit, this.objectMap.get(toVisit.getIs()));
        this.absoluteNameStack.pop();
    }

    public ArrayedType inArrayContext() {
        if (this.fcrContext.size() < 1) {
            return null;
        }
        if (this.fcrContext.peek() instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.peek();
        }
        if (this.fcrContext.size() < 3) {
            return null;
        }
        if (this.fcrContext.peek() instanceof TypeDecl && this.fcrContext.get(this.fcrContext.size() - 3) instanceof ArrayedType) {
            return (ArrayedType)this.fcrContext.get(this.fcrContext.size() - 3);
        }
        return null;
    }

    public boolean isPrimitiveType(obp.fiacre.model.Type type) {
        if (type instanceof BoolType || type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return true;
        }
        if (type instanceof TypeId) {
            return this.isPrimitiveType(((TypeId)type).getDecl().getIs());
        }
        return false;
    }

    public Type getCType(obp.fiacre.model.Type type, Map<Object, Type> typeMap) {
        if (type instanceof BoolType) {
            return this.cBuilder.booleanType();
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cBuilder.integerType();
        }
        if (type instanceof ArrayedType) {
            ArrayType arr = this.cBuilder.arrayType(this.getCType(((ArrayedType)type).getType(), typeMap));
            return arr;
        }
        if (type instanceof TypeId) {
            return this.getCType(((TypeId)type).getDecl().getIs(), typeMap);
        }
        if (type instanceof Union) {
            return null;
        }
        return this.client.typeMap.get(type);
    }

    public Type getCArrayElementType(obp.fiacre.model.Type type, Map<Object, Type> typeMap) {
        if (type instanceof BoolType) {
            return this.cBuilder.booleanType();
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cBuilder.integerType();
        }
        if (type instanceof ArrayedType) {
            return this.getCArrayElementType(((ArrayedType)type).getType(), typeMap);
        }
        if (type instanceof TypeId) {
            return this.getCArrayElementType(((TypeId)type).getDecl().getIs(), typeMap);
        }
        if (type instanceof Union) {
            return null;
        }
        return this.client.typeMap.get(type);
    }

    public Expression getCArraySize(obp.fiacre.model.Type type, Map<Object, Type> typeMap, boolean fullSize) {
        if (type instanceof BoolType) {
            return this.cBuilder.sizeOf(this.cBuilder.booleanType());
        }
        if (type instanceof IntType || type instanceof NatType || type instanceof Interval) {
            return this.cBuilder.sizeOf(this.cBuilder.integerType());
        }
        if (type instanceof ArrayedType) {
            if (!fullSize && this.isPrimitiveType(((ArrayedType)type).getType())) {
                return this.cBuilder.sizeOf(this.cBuilder.voidPointerType());
            }
            return this.cBuilder.mult(this.cBuilder.literal(((NatLiteral)FiacreStaticEvaluator.evaluate(((ArrayedType)type).getSize())).getValue()), this.getCArraySize(((ArrayedType)type).getType(), typeMap, fullSize));
        }
        if (type instanceof TypeId) {
            return this.getCArraySize(((TypeId)type).getDecl().getIs(), typeMap, fullSize);
        }
        if (type instanceof Union) {
            return null;
        }
        return this.cBuilder.sizeOf(this.client.typeMap.get(type));
    }
}

