/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx.properties;

import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import plug.code_editor.richtextfx.CodeEditor;
import plug.code_editor.richtextfx.GPSLPropertyStyler;
import plug.core.ILanguagePlugin;
import plug.core.RuntimeDescription;
import plug.core.execution.Execution;
import plug.core.execution.ExecutionDescription;
import plug.core.execution.ExecutionException;
import plug.core.execution.ExecutionOLD;
import plug.core.fx.IAppContext;
import plug.core.fx.langage.ILanguageFxModule;
import plug.core.fx.properties.IPropertiesModule;
import plug.explorer.buchi.nested_dfs.BA_GaiserSchwoon_Iterative;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiLoader;
import plug.language.buchikripke.runtime.KripkeBuchiPlugin;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.LTL.parser.Parser;
import properties.LTL.transformations.LTL2Buchi;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;

@Deprecated
public class GpslFxModule
implements ILanguageFxModule,
IPropertiesModule {
    @Override
    public String getName() {
        return "LTL Properties";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{".gpsl"};
    }

    public Collection<Execution> executionsNEW(Path propertiesPath, RuntimeDescription modelDescription) throws Exception {
        ANTLRFileStream is = new ANTLRFileStream(propertiesPath.toAbsolutePath().toString());
        ArrayList exceptions = new ArrayList();
        DeclarationBlock block = (DeclarationBlock)new Parser().parse((ANTLRInputStream)is, DeclarationBlock.class, exceptions::add);
        if (exceptions.size() > 0) {
            throw (Exception)exceptions.get(0);
        }
        ArrayList<Execution> executions = new ArrayList<Execution>();
        for (ExpressionDeclaration declaration : block.getDeclarations()) {
            executions.add(this.createExecutionNEW(declaration, modelDescription));
        }
        return executions;
    }

    public Execution createExecutionNEW(ExpressionDeclaration property, final RuntimeDescription modelDescription) throws Exception {
        ExecutionDescription executionDescription = new ExecutionDescription("Buchi Gaiser Schwoon", BA_GaiserSchwoon_Iterative::new);
        final RuntimeDescription buchiDescription = new RuntimeDescription(null, () -> {
            LTL2Buchi convertor = new LTL2Buchi(new PrintWriter(System.out));
            BuchiDeclaration buchiDeclaration = convertor.convert(property.getExpression());
            buchiDeclaration.setName(property.getName());
            return new BuchiRuntime(buchiDeclaration);
        });
        final KripkeBuchiLoader loader = new KripkeBuchiLoader(){

            public KripkeBuchiProductSemantics getRuntime(URI modelURI, Map<String, Object> options) throws Exception {
                return new KripkeBuchiProductSemantics(modelDescription, buchiDescription);
            }
        };
        KripkeBuchiPlugin plugin = new KripkeBuchiPlugin(){

            public KripkeBuchiLoader getLoader() {
                return loader;
            }
        };
        return new Execution(property.getName(), modelDescription.modelPath, (ILanguagePlugin)plugin, executionDescription);
    }

    @Override
    public Collection<ExecutionOLD> executions(Path propertiesPath, RuntimeDescription modelDescription) throws Exception {
        ANTLRFileStream is = new ANTLRFileStream(propertiesPath.toAbsolutePath().toString());
        ArrayList exceptions = new ArrayList();
        DeclarationBlock block = (DeclarationBlock)new Parser().parse((ANTLRInputStream)is, DeclarationBlock.class, exceptions::add);
        if (exceptions.size() > 0) {
            throw (Exception)exceptions.get(0);
        }
        ArrayList<ExecutionOLD> executions = new ArrayList<ExecutionOLD>();
        for (ExpressionDeclaration declaration : block.getDeclarations()) {
            executions.add(this.createExecution(declaration, modelDescription));
        }
        return executions;
    }

    @Override
    public Node createComponent(IAppContext appContext, StringProperty content, ObservableObjectValue<Path> basePath) {
        return new CodeEditor(content, new GPSLPropertyStyler()::computeHighlighting);
    }

    public ExecutionOLD createExecution(ExpressionDeclaration property, RuntimeDescription modelDescription) {
        ExecutionDescription executionDescription = new ExecutionDescription("Buchi Gaiser Schwoon", BA_GaiserSchwoon_Iterative::new);
        RuntimeDescription buchiDescription = new RuntimeDescription(null, () -> {
            LTL2Buchi convertor = new LTL2Buchi(new PrintWriter(System.out));
            BuchiDeclaration buchiDeclaration = convertor.convert(property.getExpression());
            buchiDeclaration.setName(property.getName());
            return new BuchiRuntime(buchiDeclaration);
        });
        RuntimeDescription kripkeDescription = new RuntimeDescription((ILanguagePlugin)new KripkeBuchiPlugin(), () -> {
            try {
                return new KripkeBuchiProductSemantics(modelDescription, buchiDescription);
            }
            catch (Exception e) {
                throw new ExecutionException(null, (Throwable)e, false);
            }
        });
        return new ExecutionOLD(property.getName(), kripkeDescription, executionDescription);
    }
}

