/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.PcalDebug;

public class Changed {
    public int[] count;
    public Vector vars;

    public Changed(Vector vars) {
        this.count = new int[vars.size()];
        this.vars = vars;
        for (int i = 0; i < this.count.length; ++i) {
            this.count[i] = 0;
        }
    }

    public Changed(Changed c) {
        this.vars = c.vars;
        this.count = new int[this.vars.size()];
        for (int i = 0; i < this.count.length; ++i) {
            this.count[i] = c.count[i];
        }
    }

    public String toString() {
        String s = "[";
        for (int i = 0; i < this.count.length; ++i) {
            s = s + (i == 0 ? "" : ", ") + (String)this.vars.elementAt(i) + " " + this.count[i];
        }
        s = s + "]";
        return s;
    }

    public int Size() {
        return this.count.length;
    }

    public boolean IsChanged(String s) {
        for (int i = 0; i < this.count.length; ++i) {
            if (!s.equals((String)this.vars.elementAt(i))) continue;
            return this.count[i] > 0;
        }
        return false;
    }

    public void Merge(Changed c) {
        PcalDebug.Assert(this.count.length == c.count.length);
        for (int i = 0; i < this.count.length; ++i) {
            this.count[i] = this.count[i] > c.count[i] ? this.count[i] : c.count[i];
        }
    }

    public int Set(String v) {
        for (int i = 0; i < this.count.length; ++i) {
            if (!v.equals((String)this.vars.elementAt(i))) continue;
            int n = i;
            int n2 = this.count[n] + 1;
            this.count[n] = n2;
            return n2;
        }
        return 0;
    }

    public String Unchanged() {
        String s = "";
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] != 0) continue;
            s = s + (s.length() == 0 ? "" : ", ") + (String)this.vars.elementAt(i);
        }
        return s;
    }

    public String Unchanged(Changed c) {
        String s = "";
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] != 0 || c.count[i] <= 0) continue;
            s = s + (s.length() == 0 ? "" : ", ") + (String)this.vars.elementAt(i);
        }
        return s;
    }

    public Vector Unchanged(int ch) {
        Vector<String> sv = new Vector<String>();
        String s = "";
        boolean haveOne = false;
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] != 0) continue;
            String one = (String)this.vars.elementAt(i);
            if (haveOne) {
                s = s + ", ";
            } else {
                haveOne = true;
            }
            if (s.length() + one.length() > ch) {
                if (s.length() > 0) {
                    sv.addElement(s);
                }
                s = one;
                continue;
            }
            s = s + one;
        }
        if (s.length() > 0) {
            sv.addElement(s);
        }
        return sv;
    }

    public Vector Unchanged(Changed c, int ch) {
        Vector<String> sv = new Vector<String>();
        String s = "";
        boolean haveOne = false;
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] != 0 || c.count[i] <= 0) continue;
            String one = (String)this.vars.elementAt(i);
            if (haveOne) {
                s = s + ", ";
            } else {
                haveOne = true;
            }
            if (s.length() + one.length() > ch) {
                if (s.length() > 0) {
                    sv.addElement(s);
                }
                s = one;
                continue;
            }
            s = s + one;
        }
        if (s.length() > 0) {
            sv.addElement(s);
        }
        return sv;
    }

    public int NumUnchanged() {
        int ct = 0;
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] != 0) continue;
            ++ct;
        }
        return ct;
    }

    public int NumUnchanged(Changed c) {
        int ct = 0;
        for (int i = 0; i < this.count.length; ++i) {
            if (this.count[i] != 0 || c.count[i] <= 0) continue;
            ++ct;
        }
        return ct;
    }
}

