/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import obp.cc.ConcreteContext;
import obp.explorer.ExplorerResult;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.BFSExplorer;
import obp.explorer.runtime.core.DFSExplorer;
import obp.explorer.runtime.core.NaiveContextDrivenExplorer;
import obp.explorer.runtime.core.PastFreeZeContextDrivenExplorer;
import obp.explorer.runtime.types.ConfigurationMapFactory;
import obp.result.ExplorationResultInfo;
import obp.transfo.cc.ConcreteContextTopological;
import obp.util.ConcreteContextUtil;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.JBoost;

public class Explorer {
    private File confsFile;
    private String programClassName;
    private File programPath;
    private InputStream ccStream;
    private String ccslPath;
    private String moccmlGraphPath;
    private boolean boostOutput;
    private boolean quiet = false;
    private int isContextDriven = 0;

    private void usage() {
        System.out.println("Usage: Explorer [options] -p|--programpath programclass.");
        System.out.println("Mandatory parameters: ");
        System.out.println("\t[--program-path or -p] path\tPath to search for Program class.");
        System.out.println();
        System.out.println("Context parameters:");
        System.out.println("\t[--cc or -c] (cc_file|-)\t\tPath to associated concrete context file, '-' for stdin.");
        System.out.println("\t[--context-driven or -cd]\t\t int");
        System.out.println();
        System.out.println("CCSL parameters:");
        System.out.println("\t[--ccsl] ccsl_lts_file\t\tPath to associated ccsl exploration result file.");
        System.out.println("\t[--moccml] moccml_graph_lts_file\t\tPath to associated MoCCML exploration result file.");
        System.out.println();
        System.out.println("Output parameters:");
        System.out.println("\t[--boost or -b]\t\tPrint results in Boost format");
        System.out.println("\t[--out or -o] confs_file\tLTS output as confs file.");
        System.out.println();
        System.out.println("Other parameters:");
        System.out.println("\t[--dbm-inclusion]\t\t\tCheck dbm inclusion.");
        System.out.println("\t[--quiet]\t\t\tQuiet mode.");
        System.out.println("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--out".equals(args[i]) || "-o".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--out' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid file name '" + args[i] + "'.");
                    return false;
                }
                this.confsFile = new File(args[i]);
                continue;
            }
            if ("--program-path".equals(args[i]) || "-p".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--program-path' needs an argument.");
                    return false;
                }
                if (args[i].length() == 0 || args[i].startsWith("-")) {
                    System.err.println("Invalid file/path name '" + args[i] + "'.");
                    return false;
                }
                this.programPath = new File(args[i]);
                if (!this.programPath.exists()) {
                    System.err.println("Program path '" + args[i] + "' doesn't exist.");
                    return false;
                }
                if (this.programPath.canRead()) continue;
                System.err.println("Program path '" + args[i] + "' isn't accessible.");
                return false;
            }
            if ("--cc".equals(args[i]) || "-c".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--cc' needs an argument.");
                    return false;
                }
                if (args[i].equals("-")) {
                    this.ccStream = System.in;
                    continue;
                }
                try {
                    this.ccStream = new FileInputStream(args[i]);
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.err.println("Concrete context file '" + args[i] + "' doesn't exist.");
                    return false;
                }
            }
            if ("--ccsl".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--ccsl' needs an argument.");
                    return false;
                }
                this.ccslPath = args[i];
                continue;
            }
            if ("--moccml".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--moccml' needs an argument.");
                    return false;
                }
                this.moccmlGraphPath = args[i];
                continue;
            }
            if ("--context-driven".equals(args[i]) || "-cd".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--context-driven' needs an argument.");
                    return false;
                }
                this.isContextDriven = Integer.parseInt(args[i]);
                continue;
            }
            if ("--boost".equals(args[i]) || "-b".equals(args[i])) {
                this.boostOutput = true;
                continue;
            }
            if ("--dbm-inclusion".equals(args[i])) {
                ConfigurationMapFactory.checkDBMInclusion = true;
                continue;
            }
            if ("--quiet".equals(args[i])) {
                this.quiet = true;
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if (args[i].startsWith("-")) {
                System.err.println("Unknown option '" + args[i] + "'.");
                this.usage();
                return false;
            }
            if (this.programClassName != null) continue;
            this.programClassName = args[i];
        }
        if (this.programClassName == null) {
            System.err.println("Program class is missing.");
            this.usage();
            return false;
        }
        if (this.programPath == null) {
            System.err.println("Program path is missing (option -p).");
            this.usage();
            return false;
        }
        return true;
    }

    public ExplorerResult explore() throws Exception {
        AbstractExplorer explorer;
        ProgramLoader loader = this.moccmlGraphPath != null ? new ProgramLoader.FromMoCCML(new File(this.moccmlGraphPath)) : new ProgramLoader.FromClass(this.programClassName, this.programPath);
        ConcreteContext cc = this.ccStream != null ? ConcreteContextUtil.loadCC(this.ccStream) : null;
        File ccsl = this.ccslPath != null ? new File(this.ccslPath) : null;
        switch (this.isContextDriven + (cc == null ? 100 : 0)) {
            case 1: {
                cc = ConcreteContextTopological.orderCC(cc);
                explorer = new NaiveContextDrivenExplorer(loader, cc, ccsl);
                break;
            }
            case 2: {
                cc = ConcreteContextTopological.orderCC(cc);
                explorer = new PastFreeZeContextDrivenExplorer(loader, cc, ccsl);
                break;
            }
            case 3: {
                explorer = new DFSExplorer(loader, cc, ccsl);
                break;
            }
            default: {
                explorer = new BFSExplorer(loader, cc, ccsl);
            }
        }
        explorer.setStopOnMinimumAvailableMemory(true);
        if (this.confsFile != null) {
            explorer.setConfigurationOutputFile(this.confsFile);
        }
        ExplorerResult result = explorer.explore();
        if (this.boostOutput) {
            JBoost boost = new JBoost("ExplorerResult", 1);
            boost.initializeWriting((OutputStream)System.out);
            boost.writeObject((BoostObject)result);
            boost.close();
        } else if (!this.quiet) {
            StringBuilder message = new StringBuilder();
            message.append("Exploring program '");
            message.append(this.programClassName);
            message.append("'");
            if (cc != null) {
                message.append(" with '");
                message.append(cc.getName());
                message.append("'");
            }
            message.append(".");
            System.out.println(message);
            if (result.isComplete()) {
                System.out.println(result.toString());
            } else {
                System.err.println(result.toString());
            }
        }
        return result;
    }

    public static ExplorationResultInfo explore(String[] args) {
        Explorer main = new Explorer();
        try {
            if (main.readArguments(args)) {
                ExplorerResult resultInfo = main.explore();
                return resultInfo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(DiagnosticUtil.createMessage((Throwable)e));
        }
        return null;
    }

    public static void main(String[] args) {
        ExplorationResultInfo result = Explorer.explore(args);
        System.exit(result == null || result.isComplete() ? 0 : 1);
    }
}

