/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.obs.ASynchronousCommunicationAction;
import obp.explorer.runtime.obs.Action;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.obs.InformalAction;
import obp.explorer.runtime.obs.SynchronousCommunicationAction;
import obp.explorer.runtime.simulation.InteractiveSimulator;
import obp.simulation.controler.SimulationControler;
import obp.simulation.model.ConfigurationModel;
import obp.simulation.model.StateLine;

public class StateLinePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private mxGraph graph;
    private Object parent;
    private int currentX = 10;
    private int currentY = 10;
    private int width = 90;
    private int height = 20;
    private boolean isBuild = false;
    private mxGraphComponent graphComponent;
    private String styleHead = "whiteSpace=wrap;verticalAlign=top;strokeColor=black;" + mxConstants.STYLE_FILLCOLOR + "=#7793A4;" + mxConstants.STYLE_ROUNDED + "=1";
    private String styleState = "whiteSpace=wrap;verticalAlign=top;strokeColor=black;" + mxConstants.STYLE_ROUNDED + "=1";
    private String styleEdge = "strokeColor=#000000;" + mxConstants.STYLE_LABEL_BACKGROUNDCOLOR + "=#DFDADA";
    private Map<String, StateLine> line = new HashMap<String, StateLine>();
    private Map<Integer, Map<String, mxCell>> known = new HashMap<Integer, Map<String, mxCell>>();
    private InteractiveSimulator simulator;

    public StateLinePanel(InteractiveSimulator simulator) {
        this.graph = new mxGraph();
        this.simulator = simulator;
        this.graphComponent = this.buildComponent();
        this.graphComponent.setConnectable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.graphComponent, "Center");
        this.graphComponent.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                mxCell cell = (mxCell)StateLinePanel.this.graphComponent.getCellAt(e.getX(), e.getY());
                if (cell != null) {
                    // empty if block
                }
            }
        });
    }

    public mxGraphComponent buildComponent() {
        this.graph.setCellsMovable(false);
        this.graph.setCellsBendable(false);
        this.graph.setCellsDeletable(false);
        this.graph.setCellsLocked(true);
        this.graph.setCellsDisconnectable(false);
        this.graph.setCellsEditable(false);
        this.graph.setEdgeLabelsMovable(false);
        this.graph.setCellsLocked(true);
        this.graph.setCellsResizable(false);
        this.graph.setAllowDanglingEdges(false);
        this.parent = this.graph.getDefaultParent();
        return new mxGraphComponent(this.graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStateGraph(Configuration conf) {
        if (!this.isBuild) {
            for (int i = 0; i < this.simulator.behaviorCount; ++i) {
                mxCell v1 = null;
                String toParse = this.simulator.getBehavior()[i].toStringConfiguration(conf.behaviorConfigurations[i]);
                if (toParse.startsWith("component")) continue;
                this.graph.getModel().beginUpdate();
                try {
                    v1 = (mxCell)this.graph.insertVertex(this.parent, null, (Object)this.simulator.getBehavior()[i].name, (double)this.currentX, (double)this.currentY, (double)this.width, (double)this.height, this.styleHead);
                    this.line.put(this.simulator.getBehavior()[i].name, new StateLine(this.currentX, this.currentY, v1.getGeometry().getWidth(), v1));
                }
                finally {
                    this.graph.getModel().endUpdate();
                }
                this.currentX = (int)((double)this.currentX + (v1.getGeometry().getWidth() + 20.0));
            }
            this.isBuild = true;
        } else {
            for (StateLine stateLine : this.line.values()) {
                mxCell v1 = null;
                this.graph.getModel().beginUpdate();
                try {
                    v1 = stateLine.getFirstState();
                    this.graph.addCell((Object)v1);
                }
                finally {
                    this.graph.getModel().endUpdate();
                }
                this.currentX = (int)((double)this.currentX + (v1.getGeometry().getWidth() + 20.0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponent(Configuration conf, Action action) {
        Map<String, String> edgeLabel = null;
        HashMap<String, mxCell> mxCellList = new HashMap<String, mxCell>();
        if (action != null) {
            edgeLabel = this.generateEdgeLabel(action);
        }
        this.currentY += 70;
        if (this.known.containsKey(conf.id)) {
            Map<String, mxCell> mapMxCell = this.known.get(conf.id);
            for (String lineName : this.line.keySet()) {
                if (!mapMxCell.containsKey(lineName)) continue;
                mxCell cell = mapMxCell.get(lineName);
                String state = this.graph.getLabel((Object)cell);
                this.graph.getModel().beginUpdate();
                try {
                    this.graph.addCell((Object)cell);
                    cell.getGeometry().setX(this.line.get(lineName).getX() + (this.line.get(lineName).getWidth() / 2.0 - cell.getGeometry().getWidth() / 2.0));
                    if (edgeLabel != null) {
                        if (edgeLabel.containsKey(lineName)) {
                            this.graph.insertEdge(this.parent, null, (Object)edgeLabel.get(lineName), (Object)this.line.get(lineName).getLastState(), (Object)cell, this.styleEdge);
                        } else {
                            this.graph.insertEdge(this.parent, null, (Object)"", (Object)this.line.get(lineName).getLastState(), (Object)cell, this.styleEdge);
                        }
                    } else {
                        this.graph.insertEdge(this.parent, null, (Object)"", (Object)this.line.get(lineName).getLastState(), (Object)cell, this.styleEdge);
                    }
                }
                finally {
                    this.graph.getModel().endUpdate();
                }
                if (state.matches(this.line.get(lineName).getCurrentState())) {
                    this.graph.getView().getState((Object)cell).getStyle().put(mxConstants.STYLE_OPACITY, 20);
                }
                this.line.get(lineName).addState(cell, state);
            }
        } else {
            for (int i = 0; i < this.simulator.getProcessBehaviorCount(); ++i) {
                Behavior behavior = this.simulator.getBehavior()[i];
                String toParse = behavior.toStringConfiguration(conf.behaviorConfigurations[i]);
                String name = behavior.name;
                if (toParse.startsWith("component")) continue;
                String state = this.getState(toParse);
                mxCell v1 = null;
                this.graph.getModel().beginUpdate();
                try {
                    v1 = this.addToGraph(state, name);
                    v1.getGeometry().setX(this.line.get(name).getX() + (this.line.get(name).getWidth() / 2.0 - v1.getGeometry().getWidth() / 2.0));
                    if (edgeLabel != null) {
                        if (edgeLabel.containsKey(name)) {
                            this.graph.insertEdge(this.parent, null, (Object)edgeLabel.get(name), (Object)this.line.get(name).getLastState(), (Object)v1, this.styleEdge);
                        } else {
                            this.graph.insertEdge(this.parent, null, (Object)"", (Object)this.line.get(name).getLastState(), (Object)v1, this.styleEdge);
                        }
                    } else {
                        this.graph.insertEdge(this.parent, null, (Object)"", (Object)this.line.get(name).getLastState(), (Object)v1, this.styleEdge);
                    }
                }
                finally {
                    this.graph.getModel().endUpdate();
                }
                if (state.matches(this.line.get(name).getCurrentState())) {
                    this.graph.getView().getState((Object)v1).getStyle().put(mxConstants.STYLE_OPACITY, 20);
                }
                this.line.get(name).addState(v1, state);
                mxCellList.put(name, v1);
            }
            this.known.put(conf.id, mxCellList);
        }
    }

    public mxCell addToGraph(String state, String name) {
        return (mxCell)this.graph.insertVertex(this.parent, null, (Object)state, this.line.get(name).getX(), (double)this.currentY, (double)this.width, (double)this.height, this.styleState);
    }

    public void updateStateLine(Map<Integer, Action> configurationSequence, ConfigurationModel confModel, SimulationControler controler) {
        this.reset();
        this.buildStateGraph(confModel.getConfiguration(0));
        for (Integer id : configurationSequence.keySet()) {
            Action action = configurationSequence.get(id);
            this.updateComponent(confModel.getConfiguration(id), action);
        }
    }

    public void reset() {
        for (StateLine stateLine : this.line.values()) {
            stateLine.clear();
        }
        this.currentX = 10;
        this.currentY = 10;
        for (Object cell : this.graph.getChildVertices(this.graph.getDefaultParent())) {
            ((mxGraphModel)this.graph.getModel()).remove(cell);
        }
    }

    public Map<String, String> generateEdgeLabel(Action action) {
        HashMap<String, String> edgeLabel = new HashMap<String, String>();
        for (AtomicAction atomicAction : action.atomicActions) {
            if (atomicAction instanceof ASynchronousCommunicationAction) {
                ASynchronousCommunicationAction async = (ASynchronousCommunicationAction)atomicAction;
                String label = async.message.toString();
                switch (async.commType) {
                    case 2: {
                        String currentLabel;
                        String process = this.simulator.getBehavior((short)async.behaviorId).name;
                        if (edgeLabel.containsKey(process)) {
                            currentLabel = (String)edgeLabel.get(process);
                            edgeLabel.put(process, currentLabel + "\n !:" + label);
                            break;
                        }
                        edgeLabel.put(process, "!:" + label);
                        break;
                    }
                    case 1: {
                        String currentLabel;
                        String process = this.simulator.getBehavior((short)async.behaviorId).name;
                        if (edgeLabel.containsKey(process)) {
                            currentLabel = (String)edgeLabel.get(process);
                            edgeLabel.put(process, currentLabel + "\n ?:" + label);
                            break;
                        }
                        edgeLabel.put(process, "?:" + label);
                        break;
                    }
                    default: {
                        System.out.println("Asynchronous communication type '" + async.commType + "' isn't supported.");
                    }
                }
                continue;
            }
            if (atomicAction instanceof SynchronousCommunicationAction) {
                SynchronousCommunicationAction sync = (SynchronousCommunicationAction)atomicAction;
                edgeLabel.put(this.simulator.getBehavior((short)sync.sourceId).name, this.simulator.getSymbols().getChannelName(sync.channelId));
                edgeLabel.put(this.simulator.getBehavior((short)sync.targetId).name, this.simulator.getSymbols().getChannelName(sync.channelId));
                continue;
            }
            if (!(atomicAction instanceof InformalAction)) continue;
        }
        return edgeLabel;
    }

    public String getState(String behavior) {
        String state = "";
        try {
            Pattern p = Pattern.compile("@{1}\\w*");
            Matcher m = p.matcher(behavior);
            while (m.find()) {
                state = behavior.substring(m.start(), m.end());
            }
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
        }
        return state;
    }
}

