/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.data.types.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.data.types.complex.DerivedType;
import obp.if2.external.Function;

public class AbstractType
extends DerivedType {
    private final List<Function> functionsList = new ArrayList<Function>();

    public List<Function> getFunctionsList() {
        return Collections.unmodifiableList(this.functionsList);
    }

    public int getFunctionsCount() {
        return this.functionsList.size();
    }

    public Function getFunctions(int index) {
        if (index < 0 || index >= this.getFunctionsCount()) {
            return null;
        }
        return this.functionsList.get(index);
    }

    public void addFunctions(Function newValue) {
        this.addFunctions(this.getFunctionsCount(), newValue);
    }

    public void addFunctions(int index, Function newValue) {
        this.functionsList.add(index, newValue);
    }

    public Function setFunctions(int index, Function newValue) {
        return this.functionsList.set(index, newValue);
    }

    public void addAllFunctions(Collection<Function> toAddList) {
        for (Function newValue : toAddList) {
            this.addFunctions(this.getFunctionsCount(), newValue);
        }
    }

    public void removeFunctions(Function value) {
        int index = this.functionsList.indexOf(value);
        if (index >= 0) {
            this.removeFunctions(index);
        }
    }

    public void removeFunctions(int index) {
        this.functionsList.remove(index);
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitAbstractType(this);
    }
}

