/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import spinja.exceptions.SpinJaException;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.SearchAlgorithm;
import spinja.search.SearchableStack;
import spinja.search.Stack;
import spinja.search.TransitionCalculator;
import spinja.store.StateStore;

public class DepthFirstSearch<M extends Model<T>, T extends Transition>
extends SearchAlgorithm<M, T> {
    private static final long serialVersionUID = -9191078596196568047L;
    protected final Stack stack;

    public DepthFirstSearch(M m, StateStore stateStore, int n, boolean bl, boolean bl2, int n2, TransitionCalculator<M, T> transitionCalculator) {
        super(m, stateStore, bl2, n2, bl, transitionCalculator);
        this.stack = new Stack(n);
    }

    @Override
    protected boolean addState(byte[] byArray, int n) {
        return this.stack.push(byArray, n);
    }

    @Override
    protected boolean checkModelState() {
        byte[] byArray = this.storeModel();
        return Arrays.equals(byArray, this.stack.getTop());
    }

    @Override
    public void freeMemory() {
        this.stack.clearStack();
    }

    @Override
    public long getBytes() {
        return this.stack.getBytes() + 10L + super.getBytes();
    }

    @Override
    public int getDepth() {
        return this.stack.getSize();
    }

    @Override
    protected T getLastTransition() {
        return (T)this.stack.getLastTransition();
    }

    @Override
    protected Transition nextTransition() {
        assert (this.printTransitionsLeft());
        return this.nextTransition.next(this.model, this.getLastTransition());
    }

    @Override
    public SearchableStack getSearchableStack() {
        return this.stack;
    }

    @Override
    protected void outputTrace(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string + ".trail")));
            for (int i = 0; i < this.stack.getSize() && this.stack.getTransition(i) != null; ++i) {
                printWriter.println(this.stack.getTransition(i).getId());
            }
            printWriter.flush();
            printWriter.close();
            System.out.println("spinja: wrote " + string + ".trail\n");
        }
        catch (IOException iOException) {
            System.out.println("spinja: error while writing " + string + ".trail: " + iOException.getMessage());
        }
    }

    private boolean printTransitionsLeft() {
        int n = 0;
        Transition transition = this.nextTransition.next(this.model, this.stack.getLastTransition());
        while (transition != null) {
            System.out.println("== " + transition);
            ++n;
            transition = this.nextTransition.next(this.model, transition);
        }
        System.out.println("Possible transitions: " + n);
        return true;
    }

    @Override
    protected boolean restoreState() {
        return this.stack.getSize() > 0;
    }

    @Override
    protected void stateDone() {
        this.stack.pop();
        if (this.stack.getSize() > 0 && this.stack.getLastTransition() != null) {
            assert (this.print("  Undoing transition: " + this.stack.getLastTransition()));
            this.stack.getLastTransition().undo();
        }
    }

    @Override
    protected void takeTransition(Transition transition) throws SpinJaException {
        assert (this.print("Taking transition " + transition));
        this.stack.takeTransition(transition);
    }

    @Override
    protected void undoTransition() {
        assert (this.print("  Undoing transition: " + this.stack.getLastTransition()));
        this.stack.getLastTransition().undo();
    }
}

