package alicebob1;

import obp.explorer.runtime.BehaviorConfiguration;
import java.util.Arrays;

@SuppressWarnings("all")
public class SysConfiguration extends BehaviorConfiguration {

	public boolean[] flags;

	//Create initial configuration
	public SysConfiguration() {
		this.flags = new boolean[]{false,false};
	}

	//Create configuration as a copy
	public SysConfiguration(SysConfiguration other) {
		this.flags = new boolean[2];
		for (int i=0; i<other.flags.length; i++) {
			this.flags[i] = other.flags[i];
		}
	}

	@Override
	public BehaviorConfiguration createCopy() {
		return new SysConfiguration(this);
	}

	@Override
	public boolean equals(Object object) {
		if (object instanceof SysConfiguration) {
			SysConfiguration other = (SysConfiguration) object;
			if (!Arrays.equals(flags, other.flags)) return false;
			return true;
		}
		return false;
	}

	@Override
	public int hashCode() {
		int total = 17;
		total = total * 37 + Arrays.hashCode(flags);
		return total;
	}

}

