package alicebob1;

import org.xid.basics.serializer.Boost;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.ReferencedArgument;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.BehaviorConfiguration;
import java.util.Arrays;

@SuppressWarnings("all")
public class SysBehavior extends ProcessBehavior {

	private static short idSeed = 1;

	public SysBehavior(SymbolsTable symbols) {
		super("sys", idSeed++, symbols);
	}

	public ReferencedArgument<boolean[]> getFlagsRef() {
return 		new ReferencedArgument<boolean[]>(id) {
			@Override
			public boolean[] get(Configuration configuration) {
				SysConfiguration me = (SysConfiguration) configuration.behaviorConfigurations[ownerId];
				return me.flags;
			}

			@Override
			public void set(Configuration configuration, boolean[] value) {
				SysConfiguration me = (SysConfiguration) configuration.behaviorConfigurations[ownerId];
				me.flags = value;
			}

			@Override
			public  Class<boolean[]> getArgumentType() {
				return boolean[].class;
			}

		}

;	}

	private final Transition[] transitions = new Transition[0];

	@Override
	public Transition[] getTransitions(Configuration configuration) {
		return transitions;
	}

	@Override
	public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
		SysConfiguration me = new SysConfiguration();
		//Initial action code.
		return me;
	}

	public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
		SysConfiguration me = (SysConfiguration) behaviorConfiguration;
		StringBuilder text = new StringBuilder();
		text.append("component: ");
		text.append("'");
		text.append(name);
		text.append("' [");
		text.append("\n\t- flags=");
		text.append(Arrays.toString(me.flags));
		text.append("\n]");
		return text.toString();
	}

	public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
		SysConfiguration me = (SysConfiguration) behaviorConfiguration;
		StringBuilder text = new StringBuilder();
		text.append("'");
		text.append(name);
		text.append("' [");
		text.append(" flags=");
		text.append(Arrays.toString(me.flags));
		text.append("]");
		return text.toString();
	}

	@Override
	public BehaviorConfiguration readConfiguration(Boost boost) {
		SysConfiguration me = new SysConfiguration();
		me.flags = new boolean[2];
		for (int i=0; i<me.flags.length; i++) {
			me.flags[i] = boost.readBoolean();
		}
		return me;
	}

	@Override
	public void writeConfiguration(Boost boost, BehaviorConfiguration processConfiguration) {
		SysConfiguration me = (SysConfiguration) processConfiguration;
		for (int i=0; i<me.flags.length; i++) {
			boost.writeBoolean(me.flags[i]);
		}
	}

}

