package alicebob1;

import org.xid.basics.serializer.Boost;
import obp.explorer.runtime.obs.InformalAction;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.ReferencedArgument;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.AbstractCallable;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class BobBehavior extends ProcessBehavior {

	private static short idSeed = 1;

	public static final short I = 1;

	public static final short W = 2;

	public static final short CS = 3;

	private final short informal3;

	private final short informal4;

	private final short informal5;

	private final ReferencedArgument<boolean[]> flagsRef;

	public BobBehavior(SymbolsTable symbols, ReferencedArgument<boolean[]> flags) {
		super("Bob", idSeed++, symbols);
		this.flagsRef = flags;
		informal3 = symbols.getInformalId("{b1}");
		informal4 = symbols.getInformalId("{b2}");
		informal5 = symbols.getInformalId("{b3}");
	}

	private final String[] stateNames = new String[] {"I", "W", "CS"};

	public int getStateId(String name) {
		for (short i=0; i<stateNames.length; i++) {
			if ( stateNames[i].equals(name) ) return (i+1);
		}
		throw new IllegalArgumentException("State '"+ name +"' doesn't exist in process '"+ this.name +"'.");
	}

	public String getStateName(short id) {
		return stateNames[id-1];
	}

	private final Transition transition0 = 	new Transition(id) {
		@Override
		public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
			BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			modifiedBehaviors[flagsRef.ownerId] = true;
		}

		@Override
		public boolean guard(Configuration configuration, ExplorationContext context) {
			BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			if (me.state != I) return false;
			return true;
		}

		@Override
		public boolean action(final ExplorationContext context, List<AtomicAction> actions, Configuration configuration) {
			final BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			try {
				//Start copy variable 'flags'.
				{
					boolean[] __tmp;
					__tmp = new boolean[2];
					for (int k=0; k<flags.length; k++) {
						__tmp[k] = flags[k];
					}
					flags = __tmp;
				}
				//End copy variable 'flags'.
				flags[AliceBob1Root.Bob] = AliceBob1Root.UP;
				actions.add(new InformalAction(id, informal3));
				me.state = W;
				if (true) return true;
			} finally {
				flagsRef.set(configuration, flags);
			}
			if (true) { return true; } else { return true; }
		}

	}

;

	private final Transition transition1 = 	new Transition(id) {
		@Override
		public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
			BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
		}

		@Override
		public boolean guard(Configuration configuration, ExplorationContext context) {
			BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			if (me.state != W) return false;
			return true;
		}

		@Override
		public boolean action(final ExplorationContext context, List<AtomicAction> actions, Configuration configuration) {
			final BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			try {
				if (( !(flags[AliceBob1Root.Alice])) == true) {
				} else {
					if (true) { return false; }
				}
				actions.add(new InformalAction(id, informal4));
				me.state = CS;
				if (true) return true;
			} finally {
				flagsRef.set(configuration, flags);
			}
			if (true) { return true; } else { return true; }
		}

	}

;

	private final Transition transition2 = 	new Transition(id) {
		@Override
		public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
			BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			modifiedBehaviors[flagsRef.ownerId] = true;
		}

		@Override
		public boolean guard(Configuration configuration, ExplorationContext context) {
			BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			if (me.state != CS) return false;
			return true;
		}

		@Override
		public boolean action(final ExplorationContext context, List<AtomicAction> actions, Configuration configuration) {
			final BobConfiguration me = (BobConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			try {
				//Start copy variable 'flags'.
				{
					boolean[] __tmp;
					__tmp = new boolean[2];
					for (int k=0; k<flags.length; k++) {
						__tmp[k] = flags[k];
					}
					flags = __tmp;
				}
				//End copy variable 'flags'.
				flags[AliceBob1Root.Bob] = AliceBob1Root.DOWN;
				actions.add(new InformalAction(id, informal5));
				me.state = I;
				if (true) return true;
			} finally {
				flagsRef.set(configuration, flags);
			}
			if (true) { return true; } else { return true; }
		}

	}

;

	private final Transition[] transitions = 	new Transition[] {
		transition0,
		transition1,
		transition2,
	}
;

	@Override
	public Transition[] getTransitions(Configuration configuration) {
		return transitions;
	}

	@Override
	public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
		BobConfiguration me = new BobConfiguration();
		//Initial action code.
		me.state = I;
		return me;
	}

	public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
		BobConfiguration me = (BobConfiguration) behaviorConfiguration;
		StringBuilder text = new StringBuilder();
		text.append("proc: ");
		text.append("'");
		text.append(name);
		text.append("' [");
		switch (me.state) {
		case BobBehavior.I: 
			text.append("@I,");
			break;
		case BobBehavior.W: 
			text.append("@W,");
			break;
		case BobBehavior.CS: 
			text.append("@CS,");
			break;
		}
		text.append("\n]");
		return text.toString();
	}

	public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
		BobConfiguration me = (BobConfiguration) behaviorConfiguration;
		StringBuilder text = new StringBuilder();
		text.append("'");
		text.append(name);
		text.append("' [");
		switch (me.state) {
		case BobBehavior.I: 
			text.append("@I,");
			break;
		case BobBehavior.W: 
			text.append("@W,");
			break;
		case BobBehavior.CS: 
			text.append("@CS,");
			break;
		}
		text.append("]");
		return text.toString();
	}

	@Override
	public BehaviorConfiguration readConfiguration(Boost boost) {
		BobConfiguration me = new BobConfiguration();
		me.state = boost.readShort();
		return me;
	}

	@Override
	public void writeConfiguration(Boost boost, BehaviorConfiguration processConfiguration) {
		BobConfiguration me = (BobConfiguration) processConfiguration;
		boost.writeShort(me.state);
	}

}

