package alicebob1;

import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.Program;
import obp.explorer.runtime.Component;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

public class AliceBob1Root implements Program {

	public Map<String, String> getMetaInformations() {
		return Collections.emptyMap();
	}

	private Map<String, Integer> ioQueueSizeMap;

	public int getIoQueueSize(String name) {
		if ( ioQueueSizeMap == null ) {
			ioQueueSizeMap = new HashMap<String, Integer>();
		}
		Integer size = ioQueueSizeMap.get(name);
		if ( size == null ) {
			throw new IllegalArgumentException("Queue named '"+ name +"' doesn't exists.");
		}
		return size.intValue();
	}

	public static final int Alice = 0;

	public static final int Bob = 1;

	public static final boolean UP = true;

	public static final boolean DOWN = false;

	@Override
	public void unloadExternalLibrary() { }
	private Component root;

	@Override
	public Component getRoot(SymbolsTable symbols) {
		if (root == null) {
			symbols.newInformalId("{a1}");
			symbols.newInformalId("{a2}");
			symbols.newInformalId("{a3}");
			symbols.newInformalId("{b1}");
			symbols.newInformalId("{b2}");
			symbols.newInformalId("{b3}");
			root = new SysComposition(symbols);
		}
		return root;
	}

}

