package alicebob1;

import org.xid.basics.serializer.Boost;
import obp.explorer.runtime.obs.InformalAction;
import obp.explorer.runtime.obs.AtomicAction;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.ReferencedArgument;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.AbstractCallable;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class AliceBehavior extends ProcessBehavior {

	private static short idSeed = 1;

	public static final short I = 1;

	public static final short W = 2;

	public static final short CS = 3;

	private final short informal0;

	private final short informal1;

	private final short informal2;

	private final ReferencedArgument<boolean[]> flagsRef;

	public AliceBehavior(SymbolsTable symbols, ReferencedArgument<boolean[]> flags) {
		super("Alice", idSeed++, symbols);
		this.flagsRef = flags;
		informal0 = symbols.getInformalId("{a1}");
		informal1 = symbols.getInformalId("{a2}");
		informal2 = symbols.getInformalId("{a3}");
	}

	private final String[] stateNames = new String[] {"I", "W", "CS"};

	public int getStateId(String name) {
		for (short i=0; i<stateNames.length; i++) {
			if ( stateNames[i].equals(name) ) return (i+1);
		}
		throw new IllegalArgumentException("State '"+ name +"' doesn't exist in process '"+ this.name +"'.");
	}

	public String getStateName(short id) {
		return stateNames[id-1];
	}

	private final Transition transition0 = 	new Transition(id) {
		@Override
		public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
			AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			modifiedBehaviors[flagsRef.ownerId] = true;
		}

		@Override
		public boolean guard(Configuration configuration, ExplorationContext context) {
			AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			if (me.state != I) return false;
			return true;
		}

		@Override
		public boolean action(final ExplorationContext context, List<AtomicAction> actions, Configuration configuration) {
			final AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			try {
				//Start copy variable 'flags'.
				{
					boolean[] __tmp;
					__tmp = new boolean[2];
					for (int k=0; k<flags.length; k++) {
						__tmp[k] = flags[k];
					}
					flags = __tmp;
				}
				//End copy variable 'flags'.
				flags[AliceBob1Root.Alice] = AliceBob1Root.UP;
				actions.add(new InformalAction(id, informal0));
				me.state = W;
				if (true) return true;
			} finally {
				flagsRef.set(configuration, flags);
			}
			if (true) { return true; } else { return true; }
		}

	}

;

	private final Transition transition1 = 	new Transition(id) {
		@Override
		public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
			AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
		}

		@Override
		public boolean guard(Configuration configuration, ExplorationContext context) {
			AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			if (me.state != W) return false;
			return true;
		}

		@Override
		public boolean action(final ExplorationContext context, List<AtomicAction> actions, Configuration configuration) {
			final AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			try {
				if (( !(flags[AliceBob1Root.Bob])) == true) {
				} else {
					if (true) { return false; }
				}
				actions.add(new InformalAction(id, informal1));
				me.state = CS;
				if (true) return true;
			} finally {
				flagsRef.set(configuration, flags);
			}
			if (true) { return true; } else { return true; }
		}

	}

;

	private final Transition transition2 = 	new Transition(id) {
		@Override
		public void updateModifiedBehaviors(Configuration configuration, ExplorationContext context, boolean[] modifiedBehaviors) {
			AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			modifiedBehaviors[flagsRef.ownerId] = true;
		}

		@Override
		public boolean guard(Configuration configuration, ExplorationContext context) {
			AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			if (me.state != CS) return false;
			return true;
		}

		@Override
		public boolean action(final ExplorationContext context, List<AtomicAction> actions, Configuration configuration) {
			final AliceConfiguration me = (AliceConfiguration) configuration.behaviorConfigurations[id];
			boolean[] flags = flagsRef.get(configuration);
			try {
				//Start copy variable 'flags'.
				{
					boolean[] __tmp;
					__tmp = new boolean[2];
					for (int k=0; k<flags.length; k++) {
						__tmp[k] = flags[k];
					}
					flags = __tmp;
				}
				//End copy variable 'flags'.
				flags[AliceBob1Root.Alice] = AliceBob1Root.DOWN;
				actions.add(new InformalAction(id, informal2));
				me.state = I;
				if (true) return true;
			} finally {
				flagsRef.set(configuration, flags);
			}
			if (true) { return true; } else { return true; }
		}

	}

;

	private final Transition[] transitions = 	new Transition[] {
		transition0,
		transition1,
		transition2,
	}
;

	@Override
	public Transition[] getTransitions(Configuration configuration) {
		return transitions;
	}

	@Override
	public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
		AliceConfiguration me = new AliceConfiguration();
		//Initial action code.
		me.state = I;
		return me;
	}

	public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
		AliceConfiguration me = (AliceConfiguration) behaviorConfiguration;
		StringBuilder text = new StringBuilder();
		text.append("proc: ");
		text.append("'");
		text.append(name);
		text.append("' [");
		switch (me.state) {
		case AliceBehavior.I: 
			text.append("@I,");
			break;
		case AliceBehavior.W: 
			text.append("@W,");
			break;
		case AliceBehavior.CS: 
			text.append("@CS,");
			break;
		}
		text.append("\n]");
		return text.toString();
	}

	public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
		AliceConfiguration me = (AliceConfiguration) behaviorConfiguration;
		StringBuilder text = new StringBuilder();
		text.append("'");
		text.append(name);
		text.append("' [");
		switch (me.state) {
		case AliceBehavior.I: 
			text.append("@I,");
			break;
		case AliceBehavior.W: 
			text.append("@W,");
			break;
		case AliceBehavior.CS: 
			text.append("@CS,");
			break;
		}
		text.append("]");
		return text.toString();
	}

	@Override
	public BehaviorConfiguration readConfiguration(Boost boost) {
		AliceConfiguration me = new AliceConfiguration();
		me.state = boost.readShort();
		return me;
	}

	@Override
	public void writeConfiguration(Boost boost, BehaviorConfiguration processConfiguration) {
		AliceConfiguration me = (AliceConfiguration) processConfiguration;
		boost.writeShort(me.state);
	}

}

