/*
 * Decompiled with CFR 0.152.
 */
package fr.ensta.aefd;

import fr.ensta.aefd.model.AEFDTransition;
import fr.ensta.aefd.runtime.AEFDRuntime;
import fr.ensta.aefd.runtime.AEFDRuntimeSystemState;
import fr.ensta.aefd.toolbox.AEFDToolbox;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import plug.core.ILanguageLoader;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.explorer.BFSExplorer;
import plug.folding.runtime.FoldingRuntime;
import plug.statespace.SimpleStateSpaceManager;

public class AEFDLoader
implements ILanguageLoader<FoldingRuntime> {
    String initializeSequenceFile = null;
    String environmentAlternativesFile = null;

    List<String> readEventListFromFile(String filename) {
        if (filename != null) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                return br.lines().collect(Collectors.toList());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    public FoldingRuntime<AEFDRuntimeSystemState, AEFDTransition> getRuntime(URI uri, Map<String, Object> map) {
        AEFDToolbox toolbox = new AEFDToolbox();
        try {
            File aefdFile = new File(uri);
            String parent = aefdFile.getParent();
            BufferedReader br = new BufferedReader(new FileReader(aefdFile));
            br.lines().filter(f -> !f.startsWith("init=")).filter(f -> !f.startsWith("env=")).map(f -> parent + "/" + f).forEach(f -> {
                if (f.endsWith(".init.sequence")) {
                    this.initializeSequenceFile = f;
                } else if (f.endsWith(".env.alternative")) {
                    this.environmentAlternativesFile = f;
                } else {
                    toolbox.parser.addFile(f);
                }
            });
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            toolbox.parser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> initializationSequence = this.readEventListFromFile(this.initializeSequenceFile);
        List<String> environmentAlternatives = this.readEventListFromFile(this.environmentAlternativesFile);
        ArrayList<String> rest = new ArrayList<String>(environmentAlternatives);
        rest.addAll(initializationSequence);
        if (toolbox.finalizeModel(rest)) {
            toolbox.trimModel();
            if (initializationSequence.isEmpty()) {
                toolbox.moveEventToInitPhase("Init");
            } else {
                toolbox.moveEventToInitPhase(initializationSequence);
            }
            toolbox.model.addDeclarationBasedExecutionOrder();
        }
        AEFDRuntime runtime = new AEFDRuntime();
        runtime.loadModel(toolbox.model);
        toolbox.handles.printLogs();
        return new FoldingRuntime((ITransitionRelation)runtime, c -> !c.isStableState(), transitionRelation -> new BFSExplorer(transitionRelation, (IStateSpaceManager)new SimpleStateSpaceManager(false)));
    }
}

