/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx.verification;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IConfiguration;
import plug.core.execution.Execution;
import plug.core.execution.IExecutionViewContext;
import plug.core.fx.IAppContext;
import plug.core.fx.TracePane;
import plug.events.OpenConfigurationEvent;
import plug.simulation.ui.fx.SimulationGraphViewModel;
import plug.simulation.ui.fx.SimulationView;

public class ExecutionListView
extends ListView<Execution> {
    protected final IAppContext appContext;
    protected final Map<Execution, SimulationGraphViewModel> storedGraphViewModels = new HashMap<Execution, SimulationGraphViewModel>();
    protected Consumer<Execution> onExecutionError;

    public ExecutionListView(IAppContext appContext, ObservableList<Execution> executions) {
        this.appContext = appContext;
        this.setItems(executions);
        this.setCellFactory(e -> new ExecutionCell());
        executions.addListener(this::cleanStoredGraphViewModels);
    }

    public Consumer<Execution> getOnExecutionError() {
        return this.onExecutionError;
    }

    public void setOnExecutionError(Consumer<Execution> onExecutionError) {
        this.onExecutionError = onExecutionError;
    }

    protected void cleanStoredGraphViewModels(ListChangeListener.Change<? extends Execution> c) {
        c.reset();
        while (c.next()) {
            for (Execution execution : c.getRemoved()) {
                this.storedGraphViewModels.remove(execution);
            }
        }
    }

    public static void addIconHoverEffects(FontIcon icon) {
        InnerShadow hoverShadow = new InnerShadow(10.0, Color.GREY);
        hoverShadow.setBlurType(BlurType.GAUSSIAN);
        InnerShadow clickShadow = new InnerShadow(10.0, Color.BLUE);
        clickShadow.setBlurType(BlurType.GAUSSIAN);
        icon.addEventHandler(MouseEvent.MOUSE_ENTERED, e -> icon.setEffect((Effect)hoverShadow));
        icon.addEventHandler(MouseEvent.MOUSE_EXITED, e -> icon.setEffect(null));
        icon.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> icon.setEffect((Effect)clickShadow));
        icon.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> icon.setEffect((Effect)hoverShadow));
    }

    protected class ExecutionCell
    extends ListCell<Execution> {
        protected final GridPane pane = new GridPane();
        protected final FontIcon statusIcon = new FontIcon("gmi-play-arrow:30");
        protected final FontIcon verifiedIcon = new FontIcon("gmi-directions-run:20");
        protected final FontIcon cancelIcon = new FontIcon("gmi-stop:15");
        protected final FontIcon clearIcon = new FontIcon("gmi-delete:15");
        protected final Label nameLabel = new Label();
        protected final Label detailsLabel = new Label();
        protected final Timeline blinkingAnimation = new Timeline(20.0, new KeyFrame[]{new KeyFrame(Duration.valueOf((String)"1s"), "rotate", new KeyValue[]{new KeyValue((WritableValue)this.statusIcon.rotateProperty(), (Object)360)}), new KeyFrame(Duration.ZERO, "update item", event -> this.updateItem((Execution)this.getItem(), false), new KeyValue[0])});

        public ExecutionCell() {
            this.setText(null);
            this.blinkingAnimation.setCycleCount(-1);
            this.detailsLabel.setFont(new Font(10.0));
            ExecutionListView.addIconHoverEffects(this.statusIcon);
            ExecutionListView.addIconHoverEffects(this.verifiedIcon);
            ExecutionListView.addIconHoverEffects(this.cancelIcon);
            ExecutionListView.addIconHoverEffects(this.clearIcon);
            this.pane.add((Node)this.statusIcon, 0, 0, 1, 2);
            this.pane.add((Node)this.nameLabel, 1, 0);
            this.pane.add((Node)this.detailsLabel, 1, 1);
            this.pane.add((Node)this.verifiedIcon, 3, 0, 1, 2);
            this.pane.getColumnConstraints().add((Object)new ColumnConstraints(60.0));
            this.pane.getColumnConstraints().add((Object)new ColumnConstraints(40.0, 60.0, 500.0, Priority.ALWAYS, HPos.CENTER, true));
            this.pane.getColumnConstraints().add((Object)new ColumnConstraints(10.0));
            this.pane.getRowConstraints().add((Object)new RowConstraints(20.0, 20.0, 20.0, Priority.NEVER, VPos.CENTER, false));
            this.pane.getRowConstraints().add((Object)new RowConstraints(20.0, 20.0, 20.0, Priority.NEVER, VPos.CENTER, false));
            this.statusIcon.setOnMouseClicked(this::handleStatusClick);
            this.verifiedIcon.setOnMouseClicked(this::handleDetailsClick);
            this.cancelIcon.setOnMouseClicked(this::handleCancelClick);
            this.clearIcon.setOnMouseClicked(this::handleClearClick);
        }

        protected void done(Execution execution, Boolean success) {
            Platform.runLater(() -> {
                this.updateItem((Execution)this.getItem(), this.isEmpty());
                if (ExecutionListView.this.onExecutionError != null && !success.booleanValue()) {
                    ExecutionListView.this.onExecutionError.accept((Execution)this.getItem());
                }
            });
        }

        protected void update() {
            Platform.runLater(() -> this.updateItem((Execution)this.getItem(), this.isEmpty()));
        }

        protected void updateItem(Execution execution, boolean empty) {
            super.updateItem((Object)execution, empty);
            if (empty || execution == null) {
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.pane);
                this.statusIcon.setRotate(0.0);
                if (execution.status() == Execution.Status.running || execution.status() == Execution.Status.paused) {
                    this.detailsLabel.setGraphic((Node)this.cancelIcon);
                } else if (execution.resultStatus() != Execution.ResultStatus.none) {
                    this.detailsLabel.setGraphic((Node)this.clearIcon);
                } else {
                    this.detailsLabel.setGraphic(null);
                }
                this.verifiedIcon.setVisible(execution.status() != Execution.Status.error);
                switch (execution.verificationStatus()) {
                    case violated: {
                        this.verifiedIcon.setIconColor((Paint)Color.RED);
                        break;
                    }
                    case verified: {
                        this.verifiedIcon.setIconColor((Paint)Color.GREEN);
                        break;
                    }
                    default: {
                        this.verifiedIcon.setIconColor((Paint)Color.BLACK);
                    }
                }
                this.nameLabel.setText(execution.getName());
                this.detailsLabel.setText(execution.resultDescription());
                switch (execution.status()) {
                    case idle: {
                        this.blinkingAnimation.stop();
                        this.statusIcon.setIconLiteral("gmi-play-arrow:30:black");
                        break;
                    }
                    case building: {
                        this.blinkingAnimation.play();
                        this.statusIcon.setIconLiteral("gmi-settings:30:black");
                        break;
                    }
                    case running: {
                        this.blinkingAnimation.play();
                        this.statusIcon.setIconLiteral("gmi-rotate-right:30:black");
                        break;
                    }
                    case paused: {
                        this.blinkingAnimation.stop();
                        this.statusIcon.setIconLiteral("gmi-pause:30:black");
                        break;
                    }
                    case error: {
                        this.blinkingAnimation.stop();
                        this.statusIcon.setIconLiteral("gmi-error:30:red");
                    }
                }
            }
        }

        protected void handleStatusClick(MouseEvent event) {
            Execution execution = (Execution)this.getItem();
            Execution.Status status = execution.status();
            if (event.getClickCount() == 1) {
                switch (status) {
                    case idle: {
                        execution.reset();
                        ExecutionListView.this.storedGraphViewModels.remove(execution);
                        execution.start(this::done, (e, o) -> this.update());
                        break;
                    }
                    case running: {
                        execution.pause();
                        break;
                    }
                    case paused: {
                        execution.resume();
                        break;
                    }
                }
            }
            this.updateItem(execution, false);
        }

        protected void handleDetailsClick(MouseEvent event) {
            IExecutionViewContext context;
            boolean running;
            Execution execution = (Execution)this.getItem();
            boolean bl = running = execution.status() == Execution.Status.running || execution.status() == Execution.Status.building;
            if (running) {
                execution.pause();
            }
            if ((context = execution.getOrInitContext()) != null) {
                boolean forceTraceView = event.isShiftDown();
                List counterExample = execution.counterExample();
                if (forceTraceView || counterExample != null && counterExample.size() >= 1500) {
                    TracePane pane = new TracePane(context);
                    pane.setTraceFromConfigurations(counterExample);
                    int size = counterExample != null ? counterExample.size() : 0;
                    ExecutionListView.this.appContext.openView("The counter example is " + size + " nodes long, too long for the graph view to present", (Region)pane);
                } else {
                    ObservableSet configurations = FXCollections.observableSet((Object[])new IConfiguration[0]);
                    configurations.addAll(context.getController().getStateSpaceManager().getGraphView().getVertices());
                    context.getAnnouncer().when(OpenConfigurationEvent.class, (a, e) -> Platform.runLater(() -> configurations.add((Object)((IConfiguration)e.getConfiguration()))), (Object)this);
                    SimulationView simulationView = ExecutionListView.this.storedGraphViewModels.containsKey(execution) ? new SimulationView(context, (ObservableSet<IConfiguration>)configurations, ExecutionListView.this.storedGraphViewModels.get(execution)) : new SimulationView(context, (ObservableSet<IConfiguration>)configurations, counterExample);
                    ExecutionListView.this.storedGraphViewModels.put(execution, simulationView.getModel());
                    ExecutionListView.this.appContext.openView("Analyze execution '" + ((Execution)this.getItem()).getName() + "'", (Region)simulationView, view -> context.getAnnouncer().remove((Object)this));
                }
            } else {
                this.update();
            }
            if (running) {
                execution.resume();
            }
        }

        protected void handleCancelClick(MouseEvent event) {
            ((Execution)this.getItem()).cancel();
        }

        protected void handleClearClick(MouseEvent event) {
            ((Execution)this.getItem()).reset();
            Runtime.getRuntime().gc();
            this.update();
        }
    }
}

