/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx.langage;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import plug.core.fx.langage.ILanguageFxModule;

public class LanguageFxModuleRegistry {
    private final Map<String, ILanguageFxModule> languageNameMap = new HashMap<String, ILanguageFxModule>();
    private final Map<String, ILanguageFxModule> extensionMap = new HashMap<String, ILanguageFxModule>();
    private static LanguageFxModuleRegistry instance = null;

    private LanguageFxModuleRegistry() {
    }

    public ILanguageFxModule getModuleByName(String name) {
        return this.languageNameMap.get(name);
    }

    public ILanguageFxModule getModuleByExtension(Path path) {
        int dotIndex = path.toString().lastIndexOf(".");
        if (dotIndex < 1) {
            return null;
        }
        String fileExtension = path.toString().substring(dotIndex);
        return this.extensionMap.get(fileExtension);
    }

    public Collection<ILanguageFxModule> getModules() {
        return Collections.unmodifiableCollection(this.languageNameMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LanguageFxModuleRegistry getInstance() {
        if (instance != null) return instance;
        Class<LanguageFxModuleRegistry> clazz = LanguageFxModuleRegistry.class;
        synchronized (LanguageFxModuleRegistry.class) {
            if (instance != null) return instance;
            instance = new LanguageFxModuleRegistry();
            for (ILanguageFxModule ilm : ServiceLoader.load(ILanguageFxModule.class)) {
                LanguageFxModuleRegistry.instance.languageNameMap.put(ilm.getName(), ilm);
                for (String extension : ilm.getExtensions()) {
                    LanguageFxModuleRegistry.instance.extensionMap.put(extension, ilm);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

