/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import plug.core.IConfiguration;
import plug.core.execution.IExecutionViewContext;
import plug.core.fx.ImageCache;
import plug.core.view.ConfigurationItem;

public class ConfigurationTreeView
extends TreeView<ConfigurationItem> {
    private final IExecutionViewContext context;
    private final ImageCache cache = new ImageCache();
    protected final SimpleBooleanProperty showName = new SimpleBooleanProperty(true);
    private final ObjectProperty<IConfiguration> configuration = new SimpleObjectProperty();
    private final ObjectProperty<IConfiguration> other = new SimpleObjectProperty();
    private final ObjectProperty<DifferenceMode> differencesMode = new SimpleObjectProperty((Object)DifferenceMode.none);

    public ConfigurationTreeView(IExecutionViewContext context) {
        this.context = context;
        this.setShowRoot(this.showName.get());
        this.configuration.addListener(this::updateConfiguration);
        this.setCellFactory(view -> new ConfigurationTreeCell());
    }

    public SimpleBooleanProperty showNameProperty() {
        return this.showName;
    }

    public boolean isShowName() {
        return this.showName.get();
    }

    public void setShowName(boolean showName) {
        this.showName.set(showName);
        this.setShowRoot(showName);
    }

    public ObjectProperty<DifferenceMode> differencesModeProperty() {
        return this.differencesMode;
    }

    public DifferenceMode getDifferencesMode() {
        return (DifferenceMode)((Object)this.differencesMode.get());
    }

    public void setDifferencesMode(DifferenceMode differencesMode) {
        this.differencesMode.set((Object)differencesMode);
    }

    public ObjectProperty<IConfiguration> configurationProperty() {
        return this.configuration;
    }

    public IConfiguration getConfiguration() {
        return (IConfiguration)this.configuration.get();
    }

    public ObjectProperty<IConfiguration> otherProperty() {
        return this.other;
    }

    public IConfiguration getOther() {
        return (IConfiguration)this.other.get();
    }

    public void setOther(IConfiguration configuration) {
        this.other.set((Object)configuration);
    }

    public void setConfiguration(IConfiguration configuration) {
        this.configuration.set((Object)configuration);
    }

    public double contentWidth() {
        TreeItem root = this.getRoot();
        if (root == null) {
            return 25.0;
        }
        return this.computeWidth((TreeItem<ConfigurationItem>)root, 0);
    }

    protected double computeWidth(TreeItem<ConfigurationItem> item, int depth) {
        double width = 20 + depth * 10 + ((ConfigurationItem)item.getValue()).getName().length() * 8;
        if (item.isExpanded()) {
            for (TreeItem child : item.getChildren()) {
                width = Math.max(width, this.computeWidth((TreeItem<ConfigurationItem>)child, depth + 1));
            }
        }
        return width;
    }

    public double contentHeight() {
        TreeItem root = this.getRoot();
        if (root == null) {
            return 15.0;
        }
        return this.computeHeight((TreeItem<ConfigurationItem>)root, 0);
    }

    protected double computeHeight(TreeItem<ConfigurationItem> item, int depth) {
        double height;
        double d = height = depth == 0 && !this.isShowRoot() ? 0.0 : 27.0;
        if (item.isExpanded()) {
            for (TreeItem child : item.getChildren()) {
                height += this.computeHeight((TreeItem<ConfigurationItem>)child, depth + 1);
            }
        }
        return height;
    }

    protected void updateConfiguration(ObservableValue value, IConfiguration oldValue, IConfiguration newValue) {
        if (newValue != null) {
            String name = this.context.getConfigurationDescription((Object)newValue);
            List children = this.context.getConfigurationItems((Object)newValue);
            List otherChildren = this.other.get() != null ? this.context.getConfigurationItems(this.other.get()) : null;
            ConfigurationItem rootItem = new ConfigurationItem("configuration", name, null, children);
            ConfigurationItem otherItem = otherChildren != null ? new ConfigurationItem("configuration", name, null, otherChildren) : null;
            rootItem.setExpanded(true);
            rootItem.updateDifferentStatus(otherItem);
            this.setRoot(this.updateItem((TreeItem<ConfigurationItem>)this.getRoot(), rootItem));
        } else {
            this.setRoot(null);
        }
        this.setPrefSize(this.contentWidth(), this.contentHeight());
    }

    protected TreeItem<ConfigurationItem> updateItem(TreeItem<ConfigurationItem> treeItem, ConfigurationItem configurationItem) {
        if (treeItem == null) {
            treeItem = new TreeItem();
            treeItem.addEventHandler(TreeItem.branchExpandedEvent(), e -> this.setPrefSize(this.contentWidth(), this.contentHeight()));
            treeItem.addEventHandler(TreeItem.branchCollapsedEvent(), e -> this.setPrefSize(this.contentWidth(), this.contentHeight()));
            treeItem.setExpanded(configurationItem.isExpanded());
        }
        if (treeItem.getValue() != configurationItem) {
            treeItem.setValue((Object)configurationItem);
        }
        if (!(configurationItem.getIcon() == null || treeItem.getGraphic() != null && configurationItem.getIcon().equals(treeItem.getGraphic().getProperties().get((Object)"icon")))) {
            treeItem.setGraphic((Node)this.newImageView(configurationItem.getIcon()));
        }
        if (this.differencesMode.get() != DifferenceMode.none) {
            treeItem.setExpanded(configurationItem.isDifferent());
        }
        ObservableList treeChildren = treeItem.getChildren();
        List confChildren = configurationItem.getChildren();
        int treeCurrent = 0;
        for (ConfigurationItem confChild : confChildren) {
            if (this.differencesMode.get() == DifferenceMode.only && !confChild.isDifferent()) continue;
            if (treeCurrent < treeChildren.size()) {
                this.updateItem((TreeItem<ConfigurationItem>)((TreeItem)treeChildren.get(treeCurrent)), confChild);
            } else {
                treeChildren.add(this.updateItem(null, confChild));
            }
            ++treeCurrent;
        }
        treeChildren.remove(treeCurrent, treeChildren.size());
        return treeItem;
    }

    protected ImageView newImageView(String id) {
        ImageView view = new ImageView(this.cache.loadImage(id));
        view.setPreserveRatio(true);
        view.setFitWidth(16.0);
        view.getProperties().put((Object)"icon", (Object)id);
        return view;
    }

    private class ConfigurationTreeCell
    extends TreeCell<ConfigurationItem> {
        protected ConfigurationTreeCell() {
        }

        protected void updateItem(ConfigurationItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setText(item.getName());
                if (item.isDifferent()) {
                    this.setTextFill((Paint)Color.BLUE);
                } else {
                    this.setTextFill((Paint)Color.BLACK);
                }
            }
        }
    }

    public static enum DifferenceMode {
        none,
        expand,
        only;

    }
}

