/*
 * Decompiled with CFR 0.152.
 */
package plug.core.fx;

import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IConfiguration;
import plug.core.execution.IExecutionViewContext;
import plug.core.fx.event.ConfigurationActionEvent;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.interpreter.Evaluator;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.interpreter.atom.AtomArrayValuationEvaluator;
import properties.PropositionalLogic.parser.Parser;

public class ConfigurationListView
extends VBox {
    protected final IExecutionViewContext context;
    protected final ObservableList<IConfiguration> configurationsList;
    protected final FilteredList<IConfiguration> filteredList;
    protected TextField listFilterField;
    protected ListView<IConfiguration> configurationListView;
    protected FontIcon errorIcon;
    protected Label configurationCountLabel;
    protected AtomArrayValuationEvaluator atomArrayValuationEvaluator = null;
    protected Evaluator evaluator = null;
    protected final ObjectProperty<Expression> expression = new SimpleObjectProperty(null);
    protected final ObservableList<Exception> filterExceptions = FXCollections.observableArrayList();
    protected EventHandler<ConfigurationActionEvent> configurationActionHandler = null;

    public ConfigurationListView(IExecutionViewContext context, ObservableList<IConfiguration> configurationsList) {
        this.context = context;
        this.configurationsList = configurationsList;
        this.filteredList = new FilteredList(configurationsList, this::filterConfiguration);
        this.listFilterField = new TextField();
        this.configurationListView = new ListView(this.filteredList);
        this.configurationListView.setCellFactory(list -> new ConfigurationListCell());
        this.configurationListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.selectConfiguration((IConfiguration)newValue));
        this.errorIcon = new FontIcon("gmi-error:15:red");
        this.configurationCountLabel = new Label(this.configurationsList.size() + " configurations");
        this.configurationCountLabel.setAlignment(Pos.CENTER_RIGHT);
        BorderPane labelPane = new BorderPane((Node)this.configurationCountLabel);
        labelPane.setLeft((Node)this.errorIcon);
        this.configurationCountLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(this::label, (Observable[])new Observable[]{this.filteredList, configurationsList, this.filterExceptions}));
        this.listFilterField.setOnKeyReleased(event -> {
            String filter = this.listFilterField.getText().trim();
            this.filterExceptions.clear();
            if (filter.length() > 0) {
                this.expression.set((Object)new Parser().parse(new ANTLRInputStream(filter), Expression.class, arg_0 -> this.filterExceptions.add(arg_0)));
            } else {
                this.expression.set(null);
            }
        });
        this.expression.addListener((observable, oldValue, newValue) -> {
            this.evaluator = null;
            if (newValue != null) {
                IAtomicPropositionsEvaluator propositionsEvaluator = context.getAtomicPropositionsEvaluator();
                HashMap<String, Integer> atomMap = new HashMap<String, Integer>();
                if (newValue instanceof Atom) {
                    String code = ((Atom)newValue).getCode();
                    try {
                        atomMap.put(code, propositionsEvaluator.registerAtomicProposition(code));
                    }
                    catch (Exception e) {
                        this.filterExceptions.add((Object)e);
                    }
                } else {
                    TreeIterator iterator = newValue.eAllContents();
                    while (iterator.hasNext()) {
                        EObject next = (EObject)iterator.next();
                        if (!(next instanceof Atom)) continue;
                        String code = ((Atom)next).getCode();
                        try {
                            atomMap.put(code, propositionsEvaluator.registerAtomicProposition(code));
                        }
                        catch (Exception e) {
                            this.filterExceptions.add((Object)e);
                        }
                    }
                }
                if (this.filterExceptions.isEmpty()) {
                    this.evaluator = new Evaluator();
                    this.atomArrayValuationEvaluator = new AtomArrayValuationEvaluator(atomMap);
                    this.evaluator.setDefaultEvaluator((IAtomEvaluator)this.atomArrayValuationEvaluator);
                }
            }
            this.filteredList.setPredicate(this::filterConfiguration);
        });
        this.errorIcon.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty(this.filterExceptions));
        this.getChildren().addAll((Object[])new Node[]{this.listFilterField, labelPane, this.configurationListView});
        VBox.setVgrow(this.configurationListView, (Priority)Priority.ALWAYS);
    }

    public ListView<IConfiguration> getConfigurationListView() {
        return this.configurationListView;
    }

    public void selectConfiguration(IConfiguration configuration) {
        MultipleSelectionModel selectionModel = this.configurationListView.getSelectionModel();
        if (!Objects.equals(configuration, selectionModel.getSelectedItem())) {
            selectionModel.select((Object)configuration);
        }
        if (this.configurationActionHandler != null) {
            this.configurationActionHandler.handle((Event)new ConfigurationActionEvent((Object)this, null, configuration));
        }
    }

    protected boolean filterConfiguration(IConfiguration<?> configuration) {
        if (this.evaluator != null) {
            IAtomicPropositionsEvaluator propositionsEvaluator = this.context.getAtomicPropositionsEvaluator();
            this.atomArrayValuationEvaluator.setValuation(propositionsEvaluator.getAtomicPropositionValuations(configuration));
            return this.evaluator.evaluate((Expression)this.expression.get());
        }
        return true;
    }

    public EventHandler<ConfigurationActionEvent> onConfigurationAction() {
        return this.configurationActionHandler;
    }

    public void setOnConfigurationAction(EventHandler<ConfigurationActionEvent> configurationActionHandler) {
        this.configurationActionHandler = configurationActionHandler;
    }

    protected String label() {
        StringBuilder result = new StringBuilder();
        result.append(this.configurationsList.size());
        result.append(" configurations, ");
        if (!this.filterExceptions.isEmpty()) {
            result.append(this.filterExceptions.stream().map(Throwable::getMessage).filter(Objects::nonNull).collect(Collectors.joining(", ")));
        } else {
            result.append(this.expression.get() != null ? Integer.valueOf(this.filteredList.size()) : "all");
            result.append(" shown");
        }
        return result.toString();
    }

    protected final class ConfigurationListCell
    extends ListCell<IConfiguration> {
        protected ConfigurationListCell() {
        }

        protected void updateItem(IConfiguration item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
            } else if (ConfigurationListView.this.context.getRuntimeView() != null) {
                this.setText(ConfigurationListView.this.context.getConfigurationDescription((Object)item));
            } else {
                this.setText(Integer.toHexString(item.hashCode()));
            }
        }
    }
}

