/*
 * Decompiled with CFR 0.152.
 */
package plug.code_editor.richtextfx;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import plug.code_editor.richtextfx.FiacreStyler;

public class CodeEditor
extends StackPane {
    private final CodeArea codeArea;
    private Function<String, StyleSpans<Collection<String>>> styler;

    private Function<String, StyleSpans<Collection<String>>> defaultStyler() {
        FiacreStyler fcrStyler = new FiacreStyler();
        return fcrStyler::computeHighlighting;
    }

    public CodeEditor(StringProperty content) {
        this(content, null);
    }

    public CodeEditor(StringProperty content, Function<String, StyleSpans<Collection<String>>> styler) {
        this.styler = styler;
        this.codeArea = new CodeArea();
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.codeArea));
        this.codeArea.richChanges().filter(ch -> !((StyledDocument)ch.getInserted()).equals(ch.getRemoved())).subscribe(change -> this.codeArea.setStyleSpans(0, styler == null ? this.defaultStyler().apply(this.codeArea.getText()) : (StyleSpans<Collection<String>>)styler.apply(this.codeArea.getText())));
        this.codeArea.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!Objects.equals(content.get(), newValue)) {
                content.set(newValue);
            }
        });
        content.addListener((observable, oldValue, newValue) -> {
            if (!Objects.equals(this.codeArea.getText(), newValue)) {
                this.updateText(newValue != null ? newValue : "");
            }
        });
        this.updateText((String)content.get());
        VirtualizedScrollPane scrollPane = new VirtualizedScrollPane((Node)this.codeArea);
        this.getChildren().add((Object)scrollPane);
        this.getStylesheets().add((Object)CodeEditor.class.getResource("java-keywords.css").toExternalForm());
        this.setOnKeyPressed(event -> {
            if (event.isMetaDown() && event.getText().equals("z")) {
                this.codeArea.undo();
            }
            if (event.isMetaDown() && event.isShiftDown() && event.getText().equals("z")) {
                this.codeArea.redo();
            }
        });
    }

    protected void updateText(String text) {
        this.codeArea.replaceText(text);
        this.codeArea.getUndoManager().forgetHistory();
    }
}

