/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.graph.algorithms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import plug.utils.graph.IGraph;

public class DijkstraShortestPath<N, E> {
    public List<N> getShortestPath(IGraph<N, E> graph, N source, N target) {
        HashMap predecessors = new HashMap();
        HashMap<N, Integer> distances = new HashMap<N, Integer>();
        HashSet visited = new HashSet();
        PriorityQueue<NodeCost> candidates = new PriorityQueue<NodeCost>(10);
        distances.put(source, 0);
        candidates.add(new NodeCost(source, 0));
        while (!candidates.isEmpty()) {
            NodeCost current = (NodeCost)candidates.poll();
            if (current.node == target) break;
            visited.add(current.node);
            for (N next : graph.fanout(current.node)) {
                if (visited.contains(next)) continue;
                int distance = distances.containsKey(current.node) ? (Integer)distances.get(current.node) : Integer.MAX_VALUE;
                if (distances.containsKey(next) && (Integer)distances.get(next) <= ++distance) continue;
                distances.put(next, distance);
                predecessors.put(next, current.node);
                candidates.add(new NodeCost(next, distance));
            }
        }
        LinkedList<Object> solution = new LinkedList<Object>();
        Object current = target;
        solution.addFirst(current);
        while (predecessors.containsKey(current)) {
            Object parent = predecessors.get(current);
            solution.addFirst(parent);
            current = parent;
        }
        return solution;
    }

    class NodeCost
    implements Comparable<NodeCost> {
        N node;
        int cost;

        NodeCost(N node, int cost) {
            this.node = node;
            this.cost = cost;
        }

        @Override
        public int compareTo(NodeCost o) {
            if (this.cost < o.cost) {
                return -1;
            }
            if (this.cost == o.cost) {
                return 0;
            }
            return 1;
        }
    }
}

