/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.file;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class FileWatcher {
    protected Thread watchThread;
    protected Map<Path, WatchKey> pathWatchKeys = new HashMap<Path, WatchKey>();
    protected Map<Path, Set<Consumer<Path>>> pathListener = new HashMap<Path, Set<Consumer<Path>>>();
    protected WatchService watchService = FileSystems.getDefault().newWatchService();

    public FileWatcher() throws IOException {
        this.watchThread = new Thread(this::watcher);
        this.watchThread.start();
    }

    protected void watcher() {
        while (true) {
            try {
                while (true) {
                    WatchKey key;
                    if ((key = this.watchService.take()) == null) {
                        continue;
                    }
                    Path parent = (Path)key.watchable();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path path = parent.resolve((Path)event.context());
                        Set<Consumer<Path>> consumers = this.pathListener.get(path);
                        if (consumers == null) continue;
                        for (Consumer<Path> consumer : consumers) {
                            consumer.accept(path);
                        }
                    }
                    key.reset();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized void addOnContentChange(Path path, Consumer<Path> onChange) {
        Path directoryPath = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
        this.pathWatchKeys.computeIfAbsent(directoryPath, p -> {
            try {
                return directoryPath.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
            }
            catch (IOException e) {
                return null;
            }
        });
        Set consumers = this.pathListener.computeIfAbsent(path, p -> new HashSet());
        consumers.add(onChange);
    }

    public synchronized void removeOnContentChange(Path path, Consumer<Path> onChange) {
        Set<Consumer<Path>> consumers = this.pathListener.get(path);
        if (consumers != null && consumers.contains(onChange)) {
            consumers.remove(onChange);
            if (consumers.isEmpty()) {
                this.pathListener.remove(path);
                this.pathWatchKeys.remove(path);
            }
        }
    }
}

