/*
 * Decompiled with CFR 0.152.
 */
package plug.language.tuml;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.xtext.xbase.lib.Pair;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.tuml.runtime.TUMLConfiguration;
import plug.language.tuml.runtime.TUMLRuntime;
import plug.language.tuml.simulation.ui.ConfigurationItemGenerator;
import tuml.interpreter.ActiveObject;
import tuml.interpreter.IAbstractVisitor;

public class TUMLRuntimeView
implements IRuntimeView<TUMLConfiguration, Pair<ActiveObject, Transition>> {
    TUMLRuntime runtime;

    public TUMLRuntimeView(TUMLRuntime runtime) {
        this.runtime = runtime;
    }

    public TUMLRuntime getRuntime() {
        return this.runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationItem> getConfigurationItems(TUMLConfiguration value) {
        TUMLRuntime tUMLRuntime = this.runtime;
        synchronized (tUMLRuntime) {
            this.runtime.instance.decode(value.getState());
            ConfigurationItemGenerator gen = new ConfigurationItemGenerator();
            return Collections.singletonList(this.runtime.instance.accept((IAbstractVisitor)gen));
        }
    }

    public String getFireableTransitionDescription(Pair<ActiveObject, Transition> transition) {
        Behavior effect;
        Transition umlTransition = (Transition)transition.getValue();
        StringBuilder result = new StringBuilder();
        result.append(((ActiveObject)transition.getKey()).toShortString());
        result.append(": ");
        if (umlTransition.getTriggers() != null && umlTransition.getTriggers().size() > 0) {
            result.append("(");
            String events = umlTransition.getTriggers().stream().map(t -> t.getEvent().getName()).collect(Collectors.joining(", "));
            result.append(events);
            result.append(") ");
        }
        if (umlTransition.getGuard() != null) {
            String guard = umlTransition.getGuard().toString();
            result.append(guard);
            result.append(" / ");
        }
        if ((effect = umlTransition.getEffect()) instanceof OpaqueBehavior) {
            OpaqueBehavior behavior = (OpaqueBehavior)effect;
            String contents = behavior.getBodies().stream().collect(Collectors.joining("; "));
            contents = contents.replaceAll("\\n|\\r", "");
            contents = contents.replaceAll("\\h+", " ");
            result.append(contents);
        }
        return result.toString();
    }

    public String getActionDescription(Object action) {
        Pair pair;
        if (action instanceof Pair && (pair = (Pair)action).getKey() instanceof ActiveObject && pair.getValue() instanceof Transition) {
            return this.getFireableTransitionDescription((Pair<ActiveObject, Transition>)pair);
        }
        return action.toString();
    }
}

