/*
 * Decompiled with CFR 0.152.
 */
package plug.language.tuml;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import plug.language.tuml.runtime.TUMLRuntime;
import tuml.interpreter.ActiveObject;
import tuml.interpreter.Composite;
import tuml.interpreter.Environment;

public class TUMLModelLoader {
    public TUMLModelLoader() {
        TUMLModelLoader.init();
    }

    public TUMLRuntime loadModel(File modelFile, boolean isEventPoolBounded) {
        return this.loadModel(modelFile.getAbsolutePath(), isEventPoolBounded);
    }

    public TUMLRuntime loadModel(String modelFilePath, boolean isEventPoolBounded) {
        if (!isEventPoolBounded) {
            ActiveObject.maxEventPoolSize = -1;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.getResource(URI.createFileURI((String)modelFilePath), true);
        Environment env = new Environment(r);
        Class susClass = null;
        TreeIterator ite = r.getAllContents();
        while (ite.hasNext()) {
            Object current = ite.next();
            if (!(current instanceof Class) || ((Class)current).getName() == null || !((Class)current).getName().equals("SUS")) continue;
            susClass = (Class)current;
            break;
        }
        if (susClass == null) {
            throw new RuntimeException("Failed to load the model '" + modelFilePath + "'. Could not find a class named 'SUS' in the model.");
        }
        Composite sus = new Composite(env, susClass);
        TUMLRuntime tumlRuntime = new TUMLRuntime();
        tumlRuntime.setInstance(sus);
        tumlRuntime.initializeRuntime();
        TUMLModelLoader.environmentHack(modelFilePath, tumlRuntime);
        return tumlRuntime;
    }

    public static void environmentHack(String modelFile, TUMLRuntime runtime) {
        if (modelFile.endsWith("Case1.tuml.uml")) {
            Composite sus = runtime.instance;
            Environment env = sus.getEnvironment();
            ActiveObject dispatcher = sus.getPart("dispatcher");
            dispatcher.queue(env.getSignal("ini"));
            dispatcher.queue(env.getSignal("Z1Occupe"));
            dispatcher.queue(env.getSignal("pedaleEnclenchee"));
            dispatcher.queue(env.getSignal("Z1Libre"));
            dispatcher.queue(env.getSignal("Z3Occupe"));
            dispatcher.queue(env.getSignal("Z5Occupe"));
            dispatcher.queue(env.getSignal("Z3Libre"));
            dispatcher.queue(env.getSignal("Z5Libre"));
            dispatcher.queue(env.getSignal("Z5_1Occupe"));
            dispatcher.queue(env.getSignal("Z5_1Libre"));
        }
    }

    private static void init() {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/uml2/4.0.0/UML", (Object)UMLPackage.eINSTANCE);
        ResourceFactoryRegistryImpl.INSTANCE.getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        HashMap<String, String> pluginToURL = new HashMap<String, String>();
        TUMLModelLoader.addPlugin(pluginToURL, UMLResourcesUtil.class);
        URI uri = URI.createURI((String)(((String)pluginToURL.get("org.eclipse.uml2.uml.resources")).toString() + '/'));
        URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"pathmap://UML_LIBRARIES/"), (Object)uri.appendSegment("libraries").appendSegment(""));
        URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"pathmap://UML_METAMODELS/"), (Object)uri.appendSegment("metamodels").appendSegment(""));
        URIMappingRegistryImpl.INSTANCE.put((Object)URI.createURI((String)"pathmap://UML_PROFILES/"), (Object)uri.appendSegment("profiles").appendSegment(""));
    }

    private static void addPlugin(Map<String, String> pluginToURL, java.lang.Class c) {
        String url = c.getResource(c.getSimpleName() + ".class").toString();
        url = url.replaceAll("![^!]*$", "!");
        String plugin = url.replaceAll("^.*/plugins/([^_-]*)[_-].*$", "$1");
        plugin = plugin.replaceAll("^.*/libs/([^_-]*)[_-].*$", "$1");
        plugin = plugin.replaceAll("^.*/([^_-]*)[_-].*!$", "$1");
        pluginToURL.put(plugin, url);
    }
}

