/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import model.ModelInJar;
import util.ToolIO;

public class MailSender {
    public static final String MODEL_NAME = "modelName";
    public static final String SPEC_NAME = "specName";
    public static final String MAIL_ADDRESS = "result.mail.address";
    private String modelName = "unknown model";
    private String specName = "unknown spec";
    private File err;
    private File out;
    private InternetAddress[] toAddresses;
    private InternetAddress from;
    private InternetAddress fromAlt;

    private static boolean send(InternetAddress from, InternetAddress to, String subject, String body, File[] files) {
        List<MXRecord> mailhosts;
        Properties properties = System.getProperties();
        properties.put("mail.smtp.starttls.enable", "true");
        if (!to.getAddress().contains("@")) {
            return false;
        }
        try {
            mailhosts = MailSender.getMXForDomain(to.getAddress().split("@")[1]);
        }
        catch (NamingException e) {
            e.printStackTrace();
            return false;
        }
        for (int i = 0; i < mailhosts.size(); ++i) {
            MXRecord mxRecord = mailhosts.get(i);
            properties.put("mail.smtp.host", mxRecord.hostname);
            try {
                Session session = Session.getDefaultInstance(properties);
                MimeMessage msg = new MimeMessage(session);
                ((Message)msg).setFrom(from);
                msg.addRecipient(Message.RecipientType.TO, to);
                ((Message)msg).setSubject(subject);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                MimeMultipart multipart = new MimeMultipart();
                messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent(body, "text/plain");
                ((Multipart)multipart).addBodyPart(messageBodyPart);
                for (File file : files) {
                    if (file == null) continue;
                    messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                    messageBodyPart.setFileName(file.getName());
                    messageBodyPart.setHeader("Content-Type", "text/plain");
                    ((Multipart)multipart).addBodyPart(messageBodyPart);
                }
                msg.setContent(multipart);
                Transport.send(msg);
                return true;
            }
            catch (SendFailedException e) {
                Exception next = e.getNextException();
                if (next != null && next.getMessage() != null && next.getMessage().toLowerCase().contains("greylist") && !properties.containsKey((String)properties.get("mail.smtp.host") + ".greylisted")) {
                    properties.put((String)properties.get("mail.smtp.host") + ".greylisted", "true");
                    MailSender.throttleRetry(String.format("%s EMail Report: Detected greylisting when sending to %s at %s, will retry in %s minutes...", new Date(), to.getAddress(), mxRecord.hostname, 10L), 10L);
                    --i;
                    continue;
                }
                MailSender.throttleRetry(String.format("%s EMail Report: Slowing down due to errors when sending to %s at %s, will continue in 1 minute...", new Date(), to.getAddress(), mxRecord.hostname, 1L), 1L);
                continue;
            }
            catch (AddressException e) {
                e.printStackTrace();
                continue;
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void throttleRetry(String msg, long minutes) {
        try {
            System.err.println(msg);
            Thread.sleep(minutes * 60L * 1000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private static List<MXRecord> getMXForDomain(String aDomain) throws NamingException {
        InitialDirContext ctx = new InitialDirContext();
        Attributes attributes = ctx.getAttributes("dns:/" + aDomain, new String[]{"MX"});
        Attribute attr = attributes.get("MX");
        ArrayList<MXRecord> list = new ArrayList<MXRecord>();
        if (attr == null) {
            list.add(new MXRecord(0, aDomain));
        } else {
            for (int i = 0; i < attr.size(); ++i) {
                String[] split;
                Object object = attr.get(i);
                if (object == null || !(object instanceof String) || (split = ((String)object).split("\\s+")) == null || split.length != 2) continue;
                Integer weight = Integer.parseInt(split[0]);
                list.add(new MXRecord(weight, split[1]));
            }
        }
        Collections.sort(list);
        return list;
    }

    public static void main(String[] args) throws AddressException, FileNotFoundException, UnknownHostException {
        MailSender mailSender = new MailSender();
        mailSender.send();
    }

    public MailSender() throws FileNotFoundException, UnknownHostException, AddressException {
        ModelInJar.loadProperties();
        String mailto = System.getProperty(MAIL_ADDRESS);
        if (mailto != null) {
            this.toAddresses = InternetAddress.parse(mailto);
            this.from = new InternetAddress("TLC - The friendly model checker <" + this.toAddresses[0].getAddress() + ">");
            this.fromAlt = new InternetAddress("TLC - The friendly model checker <" + System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName() + ">");
            String tmpdir = System.getProperty("java.io.tmpdir");
            this.out = new File(tmpdir + File.separator + "MC.out");
            ToolIO.out = new LogPrintStream(this.out);
            this.err = new File(tmpdir + File.separator + "MC.err");
            ToolIO.err = new LogPrintStream(this.err);
        }
    }

    public MailSender(String mainFile) throws FileNotFoundException, UnknownHostException, AddressException {
        this();
        this.setModelName(mainFile);
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setSpecName(String specName) {
        this.specName = specName;
    }

    public boolean send() {
        return this.send(new ArrayList<File>());
    }

    public boolean send(List<File> files) {
        if (this.toAddresses != null) {
            files.add(0, this.out);
            if (this.err.length() != 0L) {
                files.add(0, this.err);
            }
            boolean success = false;
            for (InternetAddress toAddress : this.toAddresses) {
                if (MailSender.send(this.from, toAddress, "Model Checking result for " + this.modelName + " with spec " + this.specName, this.extractBody(this.out), files.toArray(new File[files.size()]))) {
                    success = true;
                    continue;
                }
                if (!MailSender.send(this.fromAlt, toAddress, "Model Checking result for " + this.modelName + " with spec " + this.specName, this.extractBody(this.out), files.toArray(new File[files.size()]))) continue;
                success = true;
            }
            return success;
        }
        return true;
    }

    private String extractBody(File out) {
        StringBuffer result = new StringBuffer();
        try {
            Scanner scanner = new Scanner(out);
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                if (line == null || line.startsWith("@!@!@")) continue;
                result.append(line);
                result.append("\n");
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result.append("Failed to find file " + out.getAbsolutePath());
        }
        return result.toString();
    }

    private static class LogPrintStream
    extends PrintStream {
        public LogPrintStream(File file) throws FileNotFoundException {
            super(new FileOutputStream(file));
        }

        @Override
        public void println(String str) {
            System.out.println(str);
            super.println(str);
        }
    }

    private static class MXRecord
    implements Comparable<MXRecord> {
        public Integer weight;
        public String hostname;

        public MXRecord(int aWeight, String aHostname) {
            this.weight = aWeight;
            this.hostname = aHostname;
        }

        @Override
        public int compareTo(MXRecord o) {
            return this.weight.compareTo(o.weight);
        }
    }
}

