/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import tlc2.TLCGlobals;
import tlc2.value.BoolValue;
import tlc2.value.FcnLambdaValue;
import tlc2.value.FcnRcdValue;
import tlc2.value.IntValue;
import tlc2.value.IntervalValue;
import tlc2.value.ModelValue;
import tlc2.value.RecordValue;
import tlc2.value.SetCapValue;
import tlc2.value.SetCupValue;
import tlc2.value.SetDiffValue;
import tlc2.value.SetEnumValue;
import tlc2.value.SetOfFcnsValue;
import tlc2.value.SetOfRcdsValue;
import tlc2.value.SetOfTuplesValue;
import tlc2.value.SetPredValue;
import tlc2.value.StringValue;
import tlc2.value.SubsetValue;
import tlc2.value.TupleValue;
import tlc2.value.UnionValue;
import tlc2.value.Value;
import tlc2.value.ValueConstants;
import tlc2.value.ValueInputStream;
import util.BufferedDataOutputStream;
import util.WrongInvocationException;

public final class ValueOutputStream
implements ValueConstants {
    private BufferedDataOutputStream dos;
    private HandleTable handles;

    public ValueOutputStream(File file) throws IOException {
        if (TLCGlobals.useGZIP) {
            GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(file));
            this.dos = new BufferedDataOutputStream(os);
        } else {
            this.dos = new BufferedDataOutputStream(file);
        }
        this.handles = new HandleTable();
    }

    public ValueOutputStream(String fname) throws IOException {
        if (TLCGlobals.useGZIP) {
            GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(fname));
            this.dos = new BufferedDataOutputStream(os);
        } else {
            this.dos = new BufferedDataOutputStream(fname);
        }
        this.handles = new HandleTable();
    }

    public final void write(Value val) throws IOException {
        switch (val.getKind()) {
            case 0: {
                this.dos.writeByte((byte)0);
                this.dos.writeBoolean(((BoolValue)val).val);
                break;
            }
            case 1: {
                this.dos.writeByte((byte)1);
                this.dos.writeInt(((IntValue)val).val);
                break;
            }
            case 3: {
                int index = this.handles.put(val);
                if (index == -1) {
                    this.dos.writeByte((byte)3);
                    ((StringValue)val).val.write(this.dos);
                    break;
                }
                this.dos.writeByte((byte)26);
                this.writeNat(index);
                break;
            }
            case 21: {
                this.dos.writeByte((byte)21);
                this.dos.writeShort((short)((ModelValue)val).index);
                break;
            }
            case 23: {
                this.dos.writeByte((byte)23);
                this.dos.writeInt(((IntervalValue)val).low);
                this.dos.writeInt(((IntervalValue)val).high);
                break;
            }
            case 4: {
                int index = this.handles.put(val);
                if (index == -1) {
                    this.dos.writeByte((byte)4);
                    RecordValue rval = (RecordValue)val;
                    int len = rval.names.length;
                    this.dos.writeInt(rval.isNormalized() ? len : -len);
                    for (int i = 0; i < len; ++i) {
                        int index1 = this.handles.put(rval.names[i]);
                        if (index1 == -1) {
                            this.dos.writeByte((byte)3);
                            rval.names[i].write(this.dos);
                        } else {
                            this.dos.writeByte((byte)26);
                            this.writeNat(index1);
                        }
                        this.write(rval.values[i]);
                    }
                    break;
                }
                this.dos.writeByte((byte)26);
                this.writeNat(index);
                break;
            }
            case 9: {
                int index = this.handles.put(val);
                if (index == -1) {
                    this.dos.writeByte((byte)9);
                    FcnRcdValue fval = (FcnRcdValue)val;
                    int len = fval.values.length;
                    this.writeNat(len);
                    if (fval.intv != null) {
                        this.dos.writeByte((byte)0);
                        this.dos.writeInt(fval.intv.low);
                        this.dos.writeInt(fval.intv.high);
                        for (int i = 0; i < len; ++i) {
                            this.write(fval.values[i]);
                        }
                    } else {
                        this.dos.writeByte(fval.isNormalized() ? (byte)1 : 2);
                        for (int i = 0; i < len; ++i) {
                            this.write(fval.domain[i]);
                            this.write(fval.values[i]);
                        }
                    }
                    break;
                }
                this.dos.writeByte((byte)26);
                this.writeNat(index);
                break;
            }
            case 5: {
                int index = this.handles.put(val);
                if (index == -1) {
                    this.dos.writeByte((byte)5);
                    SetEnumValue sval = (SetEnumValue)val;
                    int len = sval.elems.size();
                    this.dos.writeInt(sval.isNormalized() ? len : -len);
                    for (int i = 0; i < len; ++i) {
                        this.write(sval.elems.elementAt(i));
                    }
                    break;
                }
                this.dos.writeByte((byte)26);
                this.writeNat(index);
                break;
            }
            case 7: {
                int index = this.handles.put(val);
                if (index == -1) {
                    this.dos.writeByte((byte)7);
                    TupleValue tval = (TupleValue)val;
                    int len = tval.elems.length;
                    this.writeNat(len);
                    for (int i = 0; i < len; ++i) {
                        this.write(tval.elems[i]);
                    }
                    break;
                }
                this.dos.writeByte((byte)26);
                this.writeNat(index);
                break;
            }
            case 18: {
                SetCapValue cap = (SetCapValue)val;
                this.write(cap.capSet);
                break;
            }
            case 19: {
                SetCupValue cup = (SetCupValue)val;
                this.write(cup.cupSet);
                break;
            }
            case 17: {
                SetDiffValue diff = (SetDiffValue)val;
                this.write(diff.diffSet);
                break;
            }
            case 16: {
                SubsetValue pset = (SubsetValue)val;
                this.write(pset.pset);
                break;
            }
            case 20: {
                UnionValue uv = (UnionValue)val;
                this.write(uv.realSet);
                break;
            }
            case 14: {
                SetOfRcdsValue rcds = (SetOfRcdsValue)val;
                this.write(rcds.rcdSet);
                break;
            }
            case 13: {
                SetOfFcnsValue fcns = (SetOfFcnsValue)val;
                this.write(fcns.fcnSet);
                break;
            }
            case 15: {
                SetOfTuplesValue tuples = (SetOfTuplesValue)val;
                this.write(tuples.tupleSet);
                break;
            }
            case 6: {
                SetPredValue spred = (SetPredValue)val;
                this.write(spred.inVal);
                break;
            }
            case 8: {
                FcnLambdaValue flambda = (FcnLambdaValue)val;
                this.write(flambda.fcnRcd);
                break;
            }
            default: {
                throw new WrongInvocationException("ValueOutputStream: Can not pickle the value\n" + Value.ppr(val.toString()));
            }
        }
    }

    public final void writeInt(int x) throws IOException {
        this.dos.writeInt(x);
    }

    public final void writeLong(long x) throws IOException {
        this.dos.writeLong(x);
    }

    public final void close() throws IOException {
        this.dos.close();
    }

    public final void writeNat(int x) throws IOException {
        if (x > Short.MAX_VALUE) {
            this.dos.writeInt(-x);
        } else {
            this.dos.writeShort((short)x);
        }
    }

    public final void writeLongNat(long x) throws IOException {
        if (x <= Integer.MAX_VALUE) {
            this.dos.writeInt((int)x);
        } else {
            this.dos.writeLong(-x);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java tlc2.value.ValueOutputStream filename.");
            System.exit(1);
        }
        IntValue[] aa = new IntValue[100];
        StringValue[] bb = new StringValue[100];
        for (int i = 0; i < aa.length; ++i) {
            aa[i] = IntValue.gen(88);
        }
        StringValue sval = new StringValue("ssssssssss");
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = sval;
        }
        try {
            ValueOutputStream vos = new ValueOutputStream(new File(args[0]));
            long x = 1L;
            for (int i = 0; i < 63; ++i) {
                System.err.println("write " + x);
                vos.writeLongNat(x);
                x *= 2L;
            }
            vos.close();
            ValueInputStream vis = new ValueInputStream(new File(args[0]));
            for (int i = 0; i < 63; ++i) {
                System.err.println("read " + vis.readLongNat());
            }
            vis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class HandleTable {
        private int[] spine = new int[17];
        private int[] next;
        private Object[] values;
        private int size;
        private int threshold;

        HandleTable() {
            Arrays.fill(this.spine, -1);
            this.next = new int[16];
            this.values = new Object[16];
            this.size = 0;
            this.threshold = (int)((double)this.spine.length * 0.75);
        }

        final int put(Object val) {
            int index = (System.identityHashCode(val) & Integer.MAX_VALUE) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.values[i] == val) {
                    return i;
                }
                i = this.next[i];
            }
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
                index = (System.identityHashCode(val) & Integer.MAX_VALUE) % this.spine.length;
            }
            this.values[this.size] = val;
            this.next[this.size] = this.spine[index];
            this.spine[index] = this.size++;
            return -1;
        }

        private final void growEntries() {
            int newLength = this.next.length * 2;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newValues = new Object[newLength];
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.values = newValues;
        }

        private final void growSpine() {
            int len = this.spine.length * 2 + 1;
            this.spine = new int[len];
            this.threshold = (int)((double)len * 0.75);
            Arrays.fill(this.spine, -1);
            int i = 0;
            while (i < this.size) {
                int index = (System.identityHashCode(this.values[i]) & Integer.MAX_VALUE) % len;
                this.next[i] = this.spine[index];
                this.spine[index] = i++;
            }
        }
    }
}

