/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tla2sany.semantic.FormalParamNode;
import tlc2.output.MP;
import tlc2.tool.FingerprintException;
import tlc2.util.Context;
import tlc2.util.FP64;
import tlc2.value.Applicable;
import tlc2.value.FcnLambdaValue;
import tlc2.value.FcnRcdValue;
import tlc2.value.IntValue;
import tlc2.value.IntervalValue;
import tlc2.value.MVPerm;
import tlc2.value.RecordValue;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;

public class TupleValue
extends Value
implements Applicable {
    public Value[] elems;

    public TupleValue(Value[] elems) {
        this.elems = elems;
    }

    public TupleValue(Value v) {
        this.elems = new Value[1];
        this.elems[0] = v;
    }

    public TupleValue(Value v1, Value v2) {
        this.elems = new Value[2];
        this.elems[0] = v1;
        this.elems[1] = v2;
    }

    @Override
    public final byte getKind() {
        return 7;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            TupleValue tv = TupleValue.convert(obj);
            if (tv == null) {
                return FcnRcdValue.convert(this).compareTo(obj);
            }
            int len = this.elems.length;
            int cmp = len - tv.elems.length;
            if (cmp == 0) {
                for (int i = 0; i < len && (cmp = this.elems[i].compareTo(tv.elems[i])) == 0; ++i) {
                }
            }
            return cmp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            TupleValue tv = TupleValue.convert(obj);
            if (tv == null) {
                return FcnRcdValue.convert(this).equals(obj);
            }
            int len = this.elems.length;
            if (len != tv.elems.length) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (this.elems[i].equals(tv.elems[i])) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check set membership in a tuple value.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value apply(Value arg, int control) {
        try {
            int idx;
            if (!(arg instanceof IntValue)) {
                Assert.fail("Attempted to apply tuple to a non-integer argument.");
            }
            if ((idx = ((IntValue)arg).val) <= 0 || idx > this.elems.length) {
                Assert.fail("Attempted to apply tuple\n" + TupleValue.ppr(this.toString()) + "\nto integer " + idx + " which is out of domain.");
            }
            return this.elems[idx - 1];
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value apply(Value[] args, int control) {
        try {
            if (args.length != 1) {
                Assert.fail("Attetmpted to apply tuple with wrong number of arguments.");
            }
            return this.apply(args[0], 0);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value select(Value arg) {
        try {
            int idx;
            if (!(arg instanceof IntValue)) {
                Assert.fail("Attempted to apply tuple to a non-integer argument " + TupleValue.ppr(arg.toString()) + ".");
            }
            if ((idx = ((IntValue)arg).val) > 0 && idx <= this.elems.length) {
                return this.elems[idx - 1];
            }
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                int tlen = this.elems.length;
                Value[] newElems = new Value[tlen];
                Value arcVal = ex.path[ex.idx];
                if (arcVal instanceof IntValue) {
                    int idx = ((IntValue)arcVal).val - 1;
                    if (0 <= idx && idx < tlen) {
                        for (int i = 0; i < tlen; ++i) {
                            newElems[i] = this.elems[i];
                        }
                        ++ex.idx;
                        newElems[idx] = this.elems[idx].takeExcept(ex);
                    }
                    return new TupleValue(newElems);
                }
                MP.printWarning(2141, new String[]{TupleValue.ppr(arcVal.toString())});
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Value val = this;
            for (int i = 0; i < exs.length; ++i) {
                val = ((Value)val).takeExcept(exs[i]);
            }
            return val;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value getDomain() {
        try {
            return new IntervalValue(1, this.size());
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        return this.elems.length;
    }

    public static TupleValue convert(Object val) {
        if (val instanceof TupleValue) {
            return (TupleValue)val;
        }
        if (val instanceof FcnRcdValue) {
            FcnRcdValue fcn = (FcnRcdValue)val;
            if (fcn.intv != null) {
                if (fcn.intv.low != 1) {
                    return null;
                }
                return new TupleValue(fcn.values);
            }
            int len = fcn.values.length;
            Value[] elems = new Value[len];
            for (int i = 0; i < len; ++i) {
                if (!(fcn.domain[i] instanceof IntValue)) {
                    return null;
                }
                int idx = ((IntValue)fcn.domain[i]).val;
                if (0 < idx && idx <= len) {
                    if (elems[idx - 1] != null) {
                        return null;
                    }
                } else {
                    return null;
                }
                elems[idx - 1] = fcn.values[i];
            }
            return new TupleValue(elems);
        }
        if (val instanceof FcnLambdaValue) {
            FcnLambdaValue fcn = (FcnLambdaValue)val;
            if (fcn.params.length() != 1) {
                return null;
            }
            Value dom = fcn.params.domains[0];
            FormalParamNode var = fcn.params.formals[0][0];
            if (dom instanceof IntervalValue) {
                IntervalValue intv = (IntervalValue)dom;
                if (intv.low != 1) {
                    return null;
                }
                Value[] elems = new Value[intv.high];
                for (int i = 1; i <= intv.high; ++i) {
                    Context c1 = fcn.con.cons(var, IntValue.gen(i));
                    elems[i - 1] = fcn.tool.eval(fcn.body, c1, fcn.state, fcn.pstate, fcn.control);
                }
                return new TupleValue(elems);
            }
            SetEnumValue eSet = SetEnumValue.convert(dom);
            if (eSet == null) {
                Assert.fail("To convert a function of form [x \\in S |-> f(x)] to a tuple, the set S must be enumerable.");
            }
            eSet.normalize();
            int len = eSet.size();
            Value[] elems = new Value[len];
            for (int i = 0; i < len; ++i) {
                Value argVal = eSet.elems.elementAt(i);
                if (!(argVal instanceof IntValue)) {
                    return null;
                }
                if (((IntValue)argVal).val != i + 1) {
                    return null;
                }
                Context c1 = fcn.con.cons(var, argVal);
                elems[i] = fcn.tool.eval(fcn.body, c1, fcn.state, fcn.pstate, fcn.control);
            }
            return new TupleValue(elems);
        }
        if (val instanceof RecordValue && ((RecordValue)val).size() == 0) {
            return EmptyTuple;
        }
        return null;
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final void normalize() {
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            for (int i = 0; i < this.elems.length; ++i) {
                defined = defined && this.elems[i].isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value deepCopy() {
        try {
            Value[] vals = new Value[this.elems.length];
            for (int i = 0; i < this.elems.length; ++i) {
                vals[i] = this.elems[i].deepCopy();
            }
            return new TupleValue(vals);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            boolean canAssign;
            boolean bl = canAssign = val instanceof TupleValue && this.elems.length == ((TupleValue)val).elems.length;
            if (!canAssign) {
                return false;
            }
            for (int i = 0; i < this.elems.length; ++i) {
                canAssign = canAssign && this.elems[i].assignable(((TupleValue)val).elems[i]);
            }
            return canAssign;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            int len = this.elems.length;
            fp = FP64.Extend(fp, (byte)9);
            fp = FP64.Extend(fp, len);
            for (int i = 0; i < len; ++i) {
                fp = FP64.Extend(fp, (byte)1);
                fp = FP64.Extend(fp, i + 1);
                fp = this.elems[i].fingerPrint(fp);
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            Value[] vals = new Value[this.elems.length];
            boolean changed = false;
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = this.elems[i].permute(perm);
                changed = changed || vals[i] != this.elems[i];
            }
            if (changed) {
                return new TupleValue(vals);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            sb.append("<<");
            int len = this.elems.length;
            if (len > 0) {
                sb = this.elems[0].toString(sb, offset);
            }
            for (int i = 1; i < len; ++i) {
                sb = sb.append(", ");
                sb = this.elems[i].toString(sb, offset);
            }
            sb.append(">>");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }
}

