/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.util.BitSet;
import tlc2.tool.FingerprintException;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import tlc2.value.ValueVec;
import util.Assert;

public class SubsetValue
extends EnumerableValue
implements Enumerable {
    public Value set;
    protected SetEnumValue pset;

    public SubsetValue(Value set) {
        this.set = set;
        this.pset = null;
    }

    @Override
    public final byte getKind() {
        return 16;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof SubsetValue) {
                return this.set.compareTo(((SubsetValue)obj).set);
            }
            this.convertAndCache();
            return this.pset.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof SubsetValue) {
                return this.set.equals(((SubsetValue)obj).set);
            }
            this.convertAndCache();
            return this.pset.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value val) {
        try {
            if (val instanceof Enumerable) {
                Value elem;
                ValueEnumeration Enum2 = ((Enumerable)((Object)val)).elements();
                while ((elem = Enum2.nextElement()) != null) {
                    if (this.set.member(elem)) continue;
                    return false;
                }
            } else {
                Assert.fail("Attempted to check if the non-enumerable value\n" + SubsetValue.ppr(val.toString()) + "\nis element of\n" + SubsetValue.ppr(this.toString()));
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public Value isSubsetEq(Value other) {
        try {
            if (other instanceof SubsetValue && this.set instanceof EnumerableValue) {
                SubsetValue sv = (SubsetValue)other;
                return ((EnumerableValue)this.set).isSubsetEq(sv.set);
            }
            return super.isSubsetEq(other);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            return this.set.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SubsetValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SubsetValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            int sz = this.set.size();
            if (sz >= 31) {
                Assert.fail(2178, "the number of elements in:\n" + SubsetValue.ppr(this.toString()));
            }
            return 1 << sz;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.pset != null && this.pset != DummyEnum && this.pset.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void normalize() {
        try {
            if (this.pset == null || this.pset == DummyEnum) {
                this.set.normalize();
            } else {
                this.pset.normalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.pset.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            this.convertAndCache();
            return this.pset.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.pset == null) {
            this.pset = SetEnumValue.convert(this);
        } else if (this.pset == DummyEnum) {
            SetEnumValue val = null;
            SubsetValue subsetValue = this;
            synchronized (subsetValue) {
                if (this.pset == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            subsetValue = this;
            synchronized (subsetValue) {
                if (this.pset == DummyEnum) {
                    this.pset = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            boolean unlazy = expand;
            try {
                if (unlazy) {
                    unlazy = this.set.size() < 7;
                }
            }
            catch (Throwable e) {
                unlazy = false;
            }
            if (unlazy) {
                SetEnumValue val = SetEnumValue.convert(this);
                return ((Value)val).toString(sb, offset);
            }
            sb = sb.append("SUBSET ");
            sb = this.set.toString(sb, offset);
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.pset == null || this.pset == DummyEnum) {
                return new Enumerator();
            }
            return this.pset.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueVec elems;
        private BitSet descriptor;

        public Enumerator() {
            SubsetValue.this.set = SetEnumValue.convert(SubsetValue.this.set);
            SubsetValue.this.set.normalize();
            this.elems = ((SetEnumValue)SubsetValue.this.set).elems;
            this.descriptor = new BitSet(this.elems.size());
        }

        @Override
        public final void reset() {
            this.descriptor = new BitSet(this.elems.size());
        }

        @Override
        public final Value nextElement() {
            if (this.descriptor == null) {
                return null;
            }
            ValueVec vals = new ValueVec();
            int sz = this.elems.size();
            if (sz == 0) {
                this.descriptor = null;
            } else {
                int i;
                for (i = 0; i < sz; ++i) {
                    if (!this.descriptor.get(i)) continue;
                    vals.addElement(this.elems.elementAt(i));
                }
                for (i = 0; i < sz; ++i) {
                    if (this.descriptor.get(i)) {
                        this.descriptor.clear(i);
                        if (i < sz - 1) continue;
                        this.descriptor = null;
                        break;
                    }
                    this.descriptor.set(i);
                    break;
                }
            }
            return new SetEnumValue(vals, true);
        }
    }
}

