/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;
import util.UniqueString;

public class StringValue
extends Value {
    public UniqueString val;

    public StringValue(String str) {
        this.val = UniqueString.uniqueStringOf(str);
    }

    public StringValue(UniqueString var) {
        this.val = var;
    }

    @Override
    public final byte getKind() {
        return 3;
    }

    public final UniqueString getVal() {
        return this.val;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof StringValue) {
                return this.val.compareTo(((StringValue)obj).val);
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to compare string " + StringValue.ppr(this.toString()) + " with non-string:\n" + StringValue.ppr(obj.toString()));
            }
            return 1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof StringValue) {
                return this.val.equals(((StringValue)obj).getVal());
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to check equality of string " + StringValue.ppr(this.toString()) + " with non-string:\n" + StringValue.ppr(obj.toString()));
            }
            return ((ModelValue)obj).modelValueEquals(this);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + StringValue.ppr(elem.toString()) + "\nis an element of the string " + StringValue.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the string " + StringValue.ppr(this.toString()) + " is a finite set.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the string " + StringValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the string " + StringValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the string " + StringValue.ppr(this.toString()) + ".");
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final void normalize() {
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return val instanceof StringValue && this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final int length() {
        try {
            return this.val.length();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            fp = FP64.Extend(fp, (byte)3);
            fp = FP64.Extend(fp, this.val.length());
            fp = FP64.Extend(fp, this.val.toString());
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        return this;
    }

    final String PrintVersion(String str) {
        try {
            StringBuffer buf = new StringBuffer(str.length());
            block10: for (int i = 0; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case '\"': {
                        buf.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block10;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block10;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block10;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block10;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block10;
                    }
                    default: {
                        buf.append(str.charAt(i));
                    }
                }
            }
            return buf.toString();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            return sb.append("\"" + this.PrintVersion(this.val.toString()) + "\"");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }
}

