/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.util.Context;
import tlc2.value.BoolValue;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.TupleValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;

public class SetPredValue
extends EnumerableValue
implements Enumerable {
    public Object vars;
    public Value inVal;
    public SemanticNode pred;
    public Tool tool;
    public Context con;
    public TLCState state;
    public TLCState pstate;
    public int control;

    public SetPredValue(Object vars, Value inVal, SemanticNode pred, Tool tool, Context con, TLCState s0, TLCState s1, int control) {
        this.vars = vars;
        this.inVal = inVal;
        this.pred = pred;
        this.tool = tool;
        this.con = con;
        this.state = s0.copy();
        this.pstate = s1 != null ? s1.copy() : null;
        this.control = control;
    }

    @Override
    public final byte getKind() {
        return 6;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.inVal = SetEnumValue.convert(this);
            this.tool = null;
            return this.inVal.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.inVal = SetEnumValue.convert(this);
            this.tool = null;
            return this.inVal.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            if (this.tool == null) {
                return this.inVal.member(elem);
            }
            try {
                if (this.inVal.member(elem)) {
                    Context con1 = this.con;
                    if (this.vars instanceof FormalParamNode) {
                        con1 = con1.cons((FormalParamNode)this.vars, elem);
                    } else {
                        FormalParamNode[] ids = (FormalParamNode[])this.vars;
                        TupleValue tv = TupleValue.convert(elem);
                        if (tv != null && tv.elems.length == ids.length) {
                            Value[] vals = tv.elems;
                            for (int i = 0; i < ids.length; ++i) {
                                con1 = con1.cons(ids[i], vals[i]);
                            }
                        } else {
                            Assert.fail("Attempted to check if the value:\n" + SetPredValue.ppr(elem.toString()) + "\nis an element of a set of " + ids.length + "-tuples.");
                        }
                    }
                    Value res = this.tool.eval(this.pred, con1, this.state, this.pstate, this.control);
                    if (!(res instanceof BoolValue)) {
                        Assert.fail("The evaluation of predicate " + this.pred + " yielded non-Boolean value.");
                    }
                    return ((BoolValue)res).val;
                }
            }
            catch (EvalException e) {
                Assert.fail("Cannot decide if element:\n" + SetPredValue.ppr(elem.toString()) + "\n is element of:\n" + SetPredValue.ppr(this.inVal.toString()) + "\nand satisfies the predicate " + this.pred);
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (!this.inVal.isFinite()) {
                Assert.fail("Attempted to check if expression of form {x \\in S : p(x)} is a finite set, but cannot check if S:\n" + SetPredValue.ppr(this.inVal.toString()) + "\nis finite.");
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetPredValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetPredValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.inVal = SetEnumValue.convert(this);
            this.tool = null;
            return this.inVal.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.inVal = (Value)ois.readObject();
        this.tool = null;
    }

    private final void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.tool != null) {
            this.inVal = SetEnumValue.convert(this);
            this.tool = null;
        }
        oos.writeObject(this.inVal);
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.inVal.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void normalize() {
        try {
            this.inVal.normalize();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.inVal = SetEnumValue.convert(this);
            this.tool = null;
            return this.inVal.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            this.inVal = SetEnumValue.convert(this);
            this.tool = null;
            return this.inVal.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            try {
                if (expand) {
                    SetEnumValue val = SetEnumValue.convert(this);
                    return ((Value)val).toString(sb, offset);
                }
            }
            catch (Throwable val) {
                // empty catch block
            }
            sb.append("{");
            if (this.vars instanceof FormalParamNode) {
                sb.append(((FormalParamNode)this.vars).getName());
            } else {
                FormalParamNode[] ids = (FormalParamNode[])this.vars;
                if (ids.length != 0) {
                    sb.append(ids[0].getName());
                }
                for (int i = 1; i < ids.length; ++i) {
                    sb.append(", " + ids[i].getName());
                }
            }
            sb.append(" \\in " + this.inVal + " : <expression ");
            sb.append(this.pred + "> }");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.tool == null) {
                return ((SetEnumValue)this.inVal).elements();
            }
            return new Enumerator();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration Enum;

        public Enumerator() {
            if (!(SetPredValue.this.inVal instanceof Enumerable)) {
                Assert.fail("Attempted to enumerate { x \\in S : p(x) } when S:\n" + Value.ppr(SetPredValue.this.inVal.toString()) + "\nis not enumerable");
            }
            this.Enum = ((Enumerable)((Object)SetPredValue.this.inVal)).elements();
        }

        @Override
        public final void reset() {
            this.Enum.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem;
            while ((elem = this.Enum.nextElement()) != null) {
                Context con1 = SetPredValue.this.con;
                if (SetPredValue.this.vars instanceof FormalParamNode) {
                    con1 = con1.cons((FormalParamNode)SetPredValue.this.vars, elem);
                } else {
                    FormalParamNode[] ids = (FormalParamNode[])SetPredValue.this.vars;
                    TupleValue tv = TupleValue.convert(elem);
                    if (tv != null && tv.elems.length == ids.length) {
                        Value[] vals = tv.elems;
                        for (int i = 0; i < ids.length; ++i) {
                            con1 = con1.cons(ids[i], vals[i]);
                        }
                    } else {
                        Assert.fail("Attempted to check if the value:\n" + Value.ppr(elem.toString()) + "\nis an element of a set of " + ids.length + "-tuples.");
                    }
                }
                Value res = SetPredValue.this.tool.eval(SetPredValue.this.pred, con1, SetPredValue.this.state, SetPredValue.this.pstate, SetPredValue.this.control);
                if (!(res instanceof BoolValue)) {
                    Assert.fail("Evaluating predicate " + SetPredValue.this.pred + " yielded non-Boolean value.");
                }
                if (!((BoolValue)res).val) continue;
                return elem;
            }
            return null;
        }
    }
}

