/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.IntValue;
import tlc2.value.IntervalValue;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.Reducible;
import tlc2.value.SetCapValue;
import tlc2.value.SetCupValue;
import tlc2.value.SetDiffValue;
import tlc2.value.SetOfFcnsValue;
import tlc2.value.SetOfRcdsValue;
import tlc2.value.SetOfTuplesValue;
import tlc2.value.SetPredValue;
import tlc2.value.SubsetValue;
import tlc2.value.UnionValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import tlc2.value.ValueVec;
import util.Assert;

public class SetEnumValue
extends EnumerableValue
implements Enumerable,
Reducible {
    public ValueVec elems;
    private boolean isNorm;

    public SetEnumValue(Value[] elems, boolean isNorm) {
        this.elems = new ValueVec(elems);
        this.isNorm = isNorm;
    }

    public SetEnumValue(ValueVec elems, boolean isNorm) {
        this.elems = elems;
        this.isNorm = isNorm;
    }

    @Override
    public final byte getKind() {
        return 5;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            SetEnumValue set = SetEnumValue.convert(obj);
            if (set == null) {
                if (obj instanceof ModelValue) {
                    return 1;
                }
                Assert.fail("Attempted to compare the set " + SetEnumValue.ppr(this.toString()) + " with the value:\n" + SetEnumValue.ppr(obj.toString()));
            }
            this.normalize();
            set.normalize();
            int sz = this.elems.size();
            int cmp = sz - set.elems.size();
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < sz; ++i) {
                cmp = this.elems.elementAt(i).compareTo(set.elems.elementAt(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            SetEnumValue set = SetEnumValue.convert(obj);
            if (set == null) {
                if (obj instanceof ModelValue) {
                    return ((ModelValue)obj).modelValueEquals(this);
                }
                Assert.fail("Attempted to check equality of the set " + SetEnumValue.ppr(this.toString()) + " with the value:\n" + SetEnumValue.ppr(obj.toString()));
            }
            this.normalize();
            set.normalize();
            int sz = this.elems.size();
            if (sz != set.elems.size()) {
                return false;
            }
            for (int i = 0; i < sz; ++i) {
                if (this.elems.elementAt(i).equals(set.elems.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            return this.elems.search(elem, this.isNorm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    @Override
    public final Value diff(Value val) {
        try {
            int sz = this.elems.size();
            ValueVec diffElems = new ValueVec();
            for (int i = 0; i < sz; ++i) {
                Value elem = this.elems.elementAt(i);
                if (val.member(elem)) continue;
                diffElems.addElement(elem);
            }
            return new SetEnumValue(diffElems, this.isNormalized());
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value cap(Value val) {
        try {
            int sz = this.elems.size();
            ValueVec capElems = new ValueVec();
            for (int i = 0; i < sz; ++i) {
                Value elem = this.elems.elementAt(i);
                if (!val.member(elem)) continue;
                capElems.addElement(elem);
            }
            return new SetEnumValue(capElems, this.isNormalized());
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value cup(Value set) {
        try {
            int sz = this.elems.size();
            if (sz == 0) {
                return set;
            }
            if (set instanceof Reducible) {
                Value elem;
                ValueVec cupElems = new ValueVec();
                for (int i = 0; i < sz; ++i) {
                    elem = this.elems.elementAt(i);
                    cupElems.addElement(elem);
                }
                ValueEnumeration Enum2 = ((Enumerable)((Object)set)).elements();
                while ((elem = Enum2.nextElement()) != null) {
                    if (this.member(elem)) continue;
                    cupElems.addElement(elem);
                }
                return new SetEnumValue(cupElems, false);
            }
            return new SetCupValue(this, set);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetEnumValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetEnumValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.normalize();
            return this.elems.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        return this.isNorm;
    }

    @Override
    public final void normalize() {
        try {
            if (!this.isNorm) {
                this.elems.sort(true);
                this.isNorm = true;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public static final SetEnumValue convert(Object val) {
        switch (((Value)val).getKind()) {
            case 5: {
                return (SetEnumValue)val;
            }
            case 23: {
                IntervalValue intv = (IntervalValue)val;
                Value[] vals = new Value[intv.size()];
                for (int i = 0; i < vals.length; ++i) {
                    vals[i] = IntValue.gen(i + intv.low);
                }
                return new SetEnumValue(vals, true);
            }
            case 18: {
                Value elem;
                SetCapValue cap = (SetCapValue)val;
                if (cap.capSet != null && cap.capSet != DummyEnum) {
                    return cap.capSet;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum2 = cap.elements();
                while ((elem = Enum2.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, cap.isNormalized());
            }
            case 19: {
                Value elem;
                SetCupValue cup = (SetCupValue)val;
                if (cup.cupSet != null && cup.cupSet != DummyEnum) {
                    return cup.cupSet;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum3 = cup.elements();
                while ((elem = Enum3.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, false);
            }
            case 17: {
                Value elem;
                SetDiffValue diff = (SetDiffValue)val;
                if (diff.diffSet != null && diff.diffSet != DummyEnum) {
                    return diff.diffSet;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum4 = diff.elements();
                while ((elem = Enum4.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, diff.set1.isNormalized());
            }
            case 20: {
                Value elem;
                UnionValue uv = (UnionValue)val;
                if (uv.realSet != null && uv.realSet != DummyEnum) {
                    return uv.realSet;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum5 = uv.elements();
                while ((elem = Enum5.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, false);
            }
            case 16: {
                Value elem;
                SubsetValue pset = (SubsetValue)val;
                if (pset.pset != null && pset.pset != DummyEnum) {
                    return pset.pset;
                }
                ValueVec vals = new ValueVec(pset.size());
                ValueEnumeration Enum6 = pset.elements();
                while ((elem = Enum6.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, false);
            }
            case 14: {
                Value elem;
                SetOfRcdsValue rcds = (SetOfRcdsValue)val;
                if (rcds.rcdSet != null && rcds.rcdSet != DummyEnum) {
                    return rcds.rcdSet;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum7 = rcds.elements();
                while ((elem = Enum7.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, rcds.isNormalized());
            }
            case 13: {
                Value elem;
                SetOfFcnsValue fcns = (SetOfFcnsValue)val;
                if (fcns.fcnSet != null && fcns.fcnSet != DummyEnum) {
                    return fcns.fcnSet;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum8 = fcns.elements();
                while ((elem = Enum8.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, fcns.isNormalized());
            }
            case 15: {
                Value elem;
                SetOfTuplesValue tvs = (SetOfTuplesValue)val;
                if (tvs.tupleSet != null && tvs.tupleSet != DummyEnum) {
                    return tvs.tupleSet;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum9 = tvs.elements();
                while ((elem = Enum9.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, tvs.isNormalized());
            }
            case 6: {
                Value elem;
                SetPredValue sPred = (SetPredValue)val;
                if (sPred.tool == null) {
                    return (SetEnumValue)sPred.inVal;
                }
                ValueVec vals = new ValueVec();
                ValueEnumeration Enum10 = sPred.elements();
                while ((elem = Enum10.nextElement()) != null) {
                    vals.addElement(elem);
                }
                return new SetEnumValue(vals, sPred.isNormalized());
            }
        }
        return null;
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            int sz = this.elems.size();
            for (int i = 0; i < sz; ++i) {
                defined = defined && this.elems.elementAt(i).isDefined();
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.normalize();
            int sz = this.elems.size();
            fp = FP64.Extend(fp, (byte)5);
            fp = FP64.Extend(fp, sz);
            for (int i = 0; i < sz; ++i) {
                Value elem = this.elems.elementAt(i);
                fp = elem.fingerPrint(fp);
            }
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            int sz = this.elems.size();
            Value[] vals = new Value[sz];
            boolean changed = false;
            for (int i = 0; i < sz; ++i) {
                vals[i] = this.elems.elementAt(i).permute(perm);
                changed = changed || vals[i] != this.elems.elementAt(i);
            }
            if (changed) {
                return new SetEnumValue(vals, false);
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            if (!this.isNormalized()) {
                this.normalize();
            }
            int len = this.elems.size();
            sb = sb.append("{");
            if (len > 0) {
                this.elems.elementAt(0).toString(sb, offset);
            }
            for (int i = 1; i < len; ++i) {
                sb.append(", ");
                this.elems.elementAt(i).toString(sb, offset);
            }
            sb.append("}");
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            return new Enumerator();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        int index = 0;

        public Enumerator() {
            SetEnumValue.this.normalize();
        }

        @Override
        public final void reset() {
            this.index = 0;
        }

        @Override
        public final Value nextElement() {
            if (this.index < SetEnumValue.this.elems.size()) {
                return SetEnumValue.this.elems.elementAt(this.index++);
            }
            return null;
        }
    }
}

