/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;

public class SetDiffValue
extends EnumerableValue
implements Enumerable {
    public Value set1;
    public Value set2;
    protected SetEnumValue diffSet;

    public SetDiffValue(Value set1, Value set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.diffSet = null;
    }

    @Override
    public final byte getKind() {
        return 17;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.diffSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.convertAndCache();
            return this.diffSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            return this.set1.member(elem) && !this.set2.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            if (this.set1.isFinite()) {
                return true;
            }
            if (!this.set2.isFinite()) {
                Assert.fail("Attempted to check if the set " + SetDiffValue.ppr(this.toString()) + "is finite.");
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetDiffValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetDiffValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.convertAndCache();
            return this.diffSet.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            if (this.diffSet == null || this.diffSet == DummyEnum) {
                return this.set1.isNormalized();
            }
            return this.diffSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void normalize() {
        try {
            if (this.diffSet == null || this.diffSet == DummyEnum) {
                this.set1.normalize();
                this.set2.normalize();
            } else {
                this.diffSet.normalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set1.isDefined() && this.set2.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.diffSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            this.convertAndCache();
            return this.diffSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.diffSet == null) {
            this.diffSet = SetEnumValue.convert(this);
        } else if (this.diffSet == DummyEnum) {
            SetEnumValue val = null;
            SetDiffValue setDiffValue = this;
            synchronized (setDiffValue) {
                if (this.diffSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setDiffValue = this;
            synchronized (setDiffValue) {
                if (this.diffSet == DummyEnum) {
                    this.diffSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            try {
                if (expand) {
                    SetEnumValue val = SetEnumValue.convert(this);
                    return ((Value)val).toString(sb, offset);
                }
            }
            catch (Throwable val) {
                // empty catch block
            }
            sb = this.set1.toString(sb, offset);
            sb = sb.append(" \\ ");
            sb = this.set2.toString(sb, offset);
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.diffSet == null || this.diffSet == DummyEnum) {
                return new Enumerator();
            }
            return this.diffSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration enum1;

        public Enumerator() {
            if (SetDiffValue.this.set1 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetDiffValue.this.set1)).elements();
            } else {
                Assert.fail("Attempted to enumerate S \\ T when S:\n" + Value.ppr(SetDiffValue.this.set1.toString()) + "\nis not enumerable.");
            }
        }

        @Override
        public final void reset() {
            this.enum1.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem = this.enum1.nextElement();
            while (elem != null) {
                if (!SetDiffValue.this.set2.member(elem)) {
                    return elem;
                }
                elem = this.enum1.nextElement();
            }
            return null;
        }
    }
}

