/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.value.Enumerable;
import tlc2.value.EnumerableValue;
import tlc2.value.MVPerm;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;

public class SetCupValue
extends EnumerableValue
implements Enumerable {
    public Value set1;
    public Value set2;
    protected SetEnumValue cupSet;

    public SetCupValue(Value set1, Value set2) {
        this.set1 = set1;
        this.set2 = set2;
        this.cupSet = null;
    }

    @Override
    public final byte getKind() {
        return 19;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.cupSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            this.convertAndCache();
            return this.cupSet.equals(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            return this.set1.member(elem) || this.set2.member(elem);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            return this.set1.isFinite() && this.set2.isFinite();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetCupValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT to the set " + SetCupValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            this.convertAndCache();
            return this.cupSet.size();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            return this.cupSet != null && this.cupSet != DummyEnum && this.cupSet.isNormalized();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void normalize() {
        try {
            if (this.cupSet != null && this.cupSet != DummyEnum) {
                this.cupSet.normalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            return this.set1.isDefined() && this.set2.isDefined();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return this.equals(val);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.cupSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        try {
            this.convertAndCache();
            return this.cupSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.cupSet == null) {
            this.cupSet = SetEnumValue.convert(this);
        } else if (this.cupSet == DummyEnum) {
            SetEnumValue val = null;
            SetCupValue setCupValue = this;
            synchronized (setCupValue) {
                if (this.cupSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setCupValue = this;
            synchronized (setCupValue) {
                if (this.cupSet == DummyEnum) {
                    this.cupSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            try {
                if (expand) {
                    SetEnumValue val = SetEnumValue.convert(this);
                    return ((Value)val).toString(sb, offset);
                }
            }
            catch (Throwable val) {
                // empty catch block
            }
            sb = this.set1.toString(sb, offset);
            sb = sb.append(" \\cup ");
            sb = this.set2.toString(sb, offset);
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.cupSet == null || this.cupSet == DummyEnum) {
                return new Enumerator();
            }
            return this.cupSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        ValueEnumeration enum1;
        ValueEnumeration enum2;

        public Enumerator() {
            if (SetCupValue.this.set1 instanceof Enumerable && SetCupValue.this.set2 instanceof Enumerable) {
                this.enum1 = ((Enumerable)((Object)SetCupValue.this.set1)).elements();
                this.enum2 = ((Enumerable)((Object)SetCupValue.this.set2)).elements();
            } else {
                Assert.fail("Attempted to enumerate S \\cup T when S:\n" + Value.ppr(SetCupValue.this.set1.toString()) + "\nand T:\n" + Value.ppr(SetCupValue.this.set2.toString()) + "\nare not both enumerable");
            }
        }

        @Override
        public final void reset() {
            this.enum1.reset();
            this.enum2.reset();
        }

        @Override
        public final Value nextElement() {
            Value elem = this.enum1.nextElement();
            if (elem != null) {
                return elem;
            }
            elem = this.enum2.nextElement();
            return elem;
        }
    }
}

