/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.tool.FingerprintException;
import tlc2.util.FP64;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.Value;
import tlc2.value.ValueExcept;
import util.Assert;

public class BoolValue
extends Value {
    public boolean val;

    public BoolValue(boolean b) {
        this.val = b;
    }

    @Override
    public final byte getKind() {
        return 0;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            if (obj instanceof BoolValue) {
                int x = this.val ? 1 : 0;
                int y = ((BoolValue)obj).val ? 1 : 0;
                return x - y;
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to compare boolean " + BoolValue.ppr(this.toString()) + " with non-boolean:\n" + BoolValue.ppr(obj.toString()));
            }
            return 1;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            if (obj instanceof BoolValue) {
                return this.val == ((BoolValue)obj).val;
            }
            if (!(obj instanceof ModelValue)) {
                Assert.fail("Attempted to compare equality of boolean " + BoolValue.ppr(this.toString()) + " with non-boolean:\n" + BoolValue.ppr(obj.toString()));
            }
            return ((ModelValue)obj).modelValueEquals(this);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + BoolValue.ppr(elem.toString()) + "\nis an element of the boolean " + BoolValue.ppr(this.toString()));
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the boolean " + BoolValue.ppr(this.toString()) + " is a finite set.");
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the boolean " + BoolValue.ppr(this.toString()) + ".");
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the boolean " + BoolValue.ppr(this.toString()) + ".");
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the boolean " + BoolValue.ppr(this.toString()) + ".");
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        return true;
    }

    @Override
    public final void normalize() {
    }

    @Override
    public final boolean isDefined() {
        return true;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        try {
            return val instanceof BoolValue && this.val == ((BoolValue)val).val;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            fp = FP64.Extend(fp, (byte)0);
            fp = FP64.Extend(fp, this.val ? (char)'t' : 'f');
            return fp;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value permute(MVPerm perm) {
        return this;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        try {
            return sb.append(this.val ? "TRUE" : "FALSE");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }
}

