/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import tlc2.tool.TLCState;
import tlc2.util.BitVector;
import tlc2.util.IStateWriter;
import tlc2.util.StateWriter;

public class DotStateWriter
extends StateWriter {
    public DotStateWriter(String fname) throws IOException {
        this(fname, "strict ");
    }

    public DotStateWriter(String fname, String strict) throws IOException {
        super(fname);
        this.writer.append(strict + "digraph DiskGraph {\n");
        this.writer.flush();
    }

    @Override
    public synchronized void writeState(TLCState state) {
        this.writer.append(Long.toString(state.fingerPrint()));
        this.writer.append(" [style = filled]");
        this.writer.append(" [label=\"");
        this.writer.append(DotStateWriter.states2dot(state));
        this.writer.append("\"]");
        this.writer.append("\n");
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, boolean successorStateIsNew) {
        this.writeState(state, successor, successorStateIsNew, IStateWriter.Visualization.DEFAULT);
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, boolean successorStateIsNew, IStateWriter.Visualization visualization) {
        this.writeState(state, successor, null, 0, 0, successorStateIsNew, visualization);
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int length, boolean successorStateIsNew) {
        this.writeState(state, successor, actionChecks, from, length, successorStateIsNew, IStateWriter.Visualization.DEFAULT);
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int length, boolean successorStateIsNew, IStateWriter.Visualization visualization) {
        String successorsFP = Long.toString(successor.fingerPrint());
        this.writer.append(Long.toString(state.fingerPrint()));
        this.writer.append(" -> ");
        this.writer.append(successorsFP);
        if (visualization == IStateWriter.Visualization.STUTTERING) {
            this.writer.append(" [style=\"dashed\"]");
        }
        if (length > 0) {
            this.writer.append(" [label=\"" + actionChecks.toString(from, length, 't', 'f') + "\"]");
        }
        this.writer.append(";\n");
        if (successorStateIsNew) {
            this.writer.append(successorsFP);
            this.writer.append(" [label=\"");
            this.writer.append(DotStateWriter.states2dot(successor));
            this.writer.append("\"]");
            this.writer.append(";\n");
        }
    }

    protected static String states2dot(TLCState state) {
        return state.toString().replace("\\", "\\\\").replace("\"", "\\\"").trim();
    }

    @Override
    public void close() {
        this.writer.append("}");
        super.close();
    }
}

