/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.ILivenessStateWriter;
import tlc2.tool.liveness.TBGraphNode;
import tlc2.util.BitVector;
import tlc2.util.DotStateWriter;
import tlc2.util.IStateWriter;

public class DotLivenessStateWriter
extends DotStateWriter
implements ILivenessStateWriter {
    public DotLivenessStateWriter(String fname) throws IOException {
        super(fname.replace(".dot", "_liveness.dot"), "");
    }

    @Override
    public void writeState(TLCState state, TBGraphNode tableauNode) {
        this.writer.append("\"");
        this.writer.append(Long.toString(state.fingerPrint()));
        this.writer.append(".");
        this.writer.append(Integer.toString(tableauNode.getIndex()));
        this.writer.append("\"");
        this.writer.append(" [style = filled]");
        this.writer.append(" [label=\"");
        this.writer.append(DotLivenessStateWriter.states2dot(state));
        this.writer.append("\n#" + Long.toString(state.fingerPrint()) + "." + tableauNode.getIndex() + "#");
        this.writer.append("\"]");
        this.writer.append("\n");
    }

    @Override
    public void writeState(TLCState state, TBGraphNode tableauNode, TLCState successor, TBGraphNode tableauNodeSuccessor, BitVector actionChecks, int from, int length, boolean successorStateIsNew) {
        this.writeState(state, tableauNode, successor, tableauNodeSuccessor, actionChecks, from, length, successorStateIsNew, IStateWriter.Visualization.DEFAULT);
    }

    @Override
    public void writeState(TLCState state, TBGraphNode tableauNode, TLCState successor, TBGraphNode tableauNodeSuccessor, BitVector actionChecks, int from, int length, boolean successorStateIsNew, IStateWriter.Visualization visualization) {
        String successorsFP = Long.toString(successor.fingerPrint());
        this.writer.append("\"");
        this.writer.append(Long.toString(state.fingerPrint()));
        this.writer.append(".");
        this.writer.append(Integer.toString(tableauNode.getIndex()));
        this.writer.append("\"");
        this.writer.append(" -> ");
        this.writer.append("\"");
        this.writer.append(successorsFP);
        this.writer.append(".");
        this.writer.append(Integer.toString(tableauNodeSuccessor.getIndex()));
        this.writer.append("\"");
        if (visualization == IStateWriter.Visualization.STUTTERING) {
            this.writer.append(" [style=\"dashed\"]");
        }
        if (visualization == IStateWriter.Visualization.DOTTED) {
            this.writer.append(" [style=\"dotted\"]");
        }
        if (length > 0) {
            this.writer.append(" [label=\"" + actionChecks.toString(from, length, 't', 'f') + "\"]");
        }
        this.writer.append(";\n");
        if (successorStateIsNew) {
            this.writer.append("\"");
            this.writer.append(successorsFP);
            this.writer.append(".");
            this.writer.append(Integer.toString(tableauNodeSuccessor.getIndex()));
            this.writer.append("\"");
            this.writer.append(" [label=\"");
            this.writer.append(DotLivenessStateWriter.states2dot(successor));
            this.writer.append("\n#" + Long.toString(successor.fingerPrint()) + "." + tableauNodeSuccessor.getIndex() + "#");
            this.writer.append("\"]");
            this.writer.append(";\n");
        }
    }

    protected static String tableauNode2dot(TBGraphNode tableauNode) {
        return tableauNode.toString().replace("\\", "\\\\").replace("\"", "\\\"").trim();
    }
}

