/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.IWorker;
import tlc2.tool.ModelChecker;
import tlc2.tool.TLCState;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.IdThread;
import tlc2.util.ObjLongTable;
import tlc2.util.statistics.FixedSizedBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class Worker
extends IdThread
implements IWorker {
    private final ModelChecker tlc;
    private final IStateQueue squeue;
    private final ObjLongTable astCounts;
    private final IBucketStatistics outDegree;
    private long statesGenerated;

    public Worker(int id, AbstractChecker tlc) {
        super(id);
        this.setName("TLC Worker " + id);
        this.tlc = (ModelChecker)tlc;
        this.squeue = this.tlc.theStateQueue;
        this.astCounts = new ObjLongTable(10);
        this.outDegree = new FixedSizedBucketStatistics(this.getName(), 32);
        this.setName("TLCWorkerThread-" + String.format("%03d", id));
    }

    @Override
    public final ObjLongTable getCounts() {
        return this.astCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        TLCState curState = null;
        try {
            do {
                if ((curState = this.squeue.sDequeue()) != null) continue;
                ModelChecker modelChecker = this.tlc;
                synchronized (modelChecker) {
                    this.tlc.setDone();
                    this.tlc.notify();
                }
                this.squeue.finishAll();
                return;
            } while (!this.tlc.doNext(curState, this.astCounts, this));
            return;
        }
        catch (Throwable e) {
            ModelChecker modelChecker = this.tlc;
            synchronized (modelChecker) {
                if (this.tlc.setErrState(curState, null, true)) {
                    MP.printError(1000, e);
                }
                this.squeue.finishAll();
                this.tlc.notify();
            }
            return;
        }
    }

    void incrementStatesGenerated(long l) {
        this.statesGenerated += l;
    }

    long getStatesGenerated() {
        return this.statesGenerated;
    }

    void setOutDegree(int numOfSuccessors) {
        this.outDegree.addSample(numOfSuccessors);
    }

    public IBucketStatistics getOutDegree() {
        return this.outDegree;
    }
}

