/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.io.Serializable;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tlc2.TLCGlobals;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.util.Context;
import tlc2.util.FP64;
import tlc2.value.MVPerm;
import tlc2.value.Value;
import tlc2.value.ValueInputStream;
import tlc2.value.ValueOutputStream;
import util.UniqueString;
import util.WrongInvocationException;

public final class TLCStateMut
extends TLCState
implements Cloneable,
Serializable {
    private Value[] values;
    private static Tool mytool = null;
    private static SemanticNode viewMap = null;
    private static MVPerm[] perms = null;

    private TLCStateMut(Value[] vals) {
        this.values = vals;
    }

    public static void init(Tool tool) {
        mytool = tool;
        Value[] vals = new Value[vars.length];
        Empty = new TLCStateMut(vals);
        viewMap = tool.getViewSpec();
        perms = tool.getSymmetryPerms();
    }

    @Override
    public final TLCState createEmpty() {
        Value[] vals = new Value[vars.length];
        return new TLCStateMut(vals);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TLCStateMut) {
            TLCStateMut state = (TLCStateMut)obj;
            for (int i = 0; i < this.values.length; ++i) {
                if (!(this.values[i] == null ? state.values[i] != null : state.values[i] == null || !this.values[i].equals(state.values[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final TLCState bind(UniqueString name, Value value, SemanticNode expr) {
        int loc = name.getVarLoc();
        this.values[loc] = value;
        return this;
    }

    @Override
    public final TLCState bind(SymbolNode id, Value value, SemanticNode expr) {
        throw new WrongInvocationException("TLCStateMut.bind: This is a TLC bug.");
    }

    @Override
    public final TLCState unbind(UniqueString name) {
        int loc = name.getVarLoc();
        this.values[loc] = null;
        return this;
    }

    @Override
    public final Value lookup(UniqueString var) {
        int loc = var.getVarLoc();
        if (loc < 0) {
            return null;
        }
        return this.values[loc];
    }

    @Override
    public final boolean containsKey(UniqueString var) {
        return this.lookup(var) != null;
    }

    @Override
    public final TLCState copy() {
        int len = this.values.length;
        Value[] vals = new Value[len];
        for (int i = 0; i < len; ++i) {
            vals[i] = this.values[i];
        }
        return new TLCStateMut(vals);
    }

    @Override
    public final TLCState deepCopy() {
        int len = this.values.length;
        Value[] vals = new Value[len];
        for (int i = 0; i < len; ++i) {
            Value val = this.values[i];
            if (val == null) continue;
            vals[i] = val.deepCopy();
        }
        return new TLCStateMut(vals);
    }

    @Override
    public final StateVec addToVec(StateVec states) {
        return states.addElement(this.copy());
    }

    @Override
    public final void deepNormalize() {
        for (int i = 0; i < this.values.length; ++i) {
            Value val = this.values[i];
            if (val == null) continue;
            val.deepNormalize();
        }
    }

    @Override
    public final long fingerPrint() {
        int i;
        int sz = this.values.length;
        Value[] minVals = this.values;
        if (perms != null) {
            Value[] vals = new Value[sz];
            block0: for (int i2 = 0; i2 < perms.length; ++i2) {
                int cmp = 0;
                for (int j = 0; j < sz; ++j) {
                    vals[j] = this.values[j].permute(perms[i2]);
                    if (cmp == 0 && (cmp = vals[j].compareTo(minVals[j])) > 0) continue block0;
                }
                if (cmp >= 0) continue;
                if (minVals == this.values) {
                    minVals = vals;
                    vals = new Value[sz];
                    continue;
                }
                Value[] temp = minVals;
                minVals = vals;
                vals = temp;
            }
        }
        long fp = FP64.New();
        if (viewMap == null) {
            for (i = 0; i < sz; ++i) {
                fp = minVals[i].fingerPrint(fp);
            }
            if (this.values != minVals) {
                for (i = 0; i < sz; ++i) {
                    this.values[i].deepNormalize();
                }
            }
        } else {
            for (i = 0; i < sz; ++i) {
                this.values[i].deepNormalize();
            }
            TLCStateMut state = this;
            if (minVals != this.values) {
                state = new TLCStateMut(minVals);
            }
            Value val = mytool.eval(viewMap, Context.Empty, state);
            fp = val.fingerPrint(fp);
        }
        return fp;
    }

    @Override
    public final boolean allAssigned() {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.values[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void read(ValueInputStream vis) throws IOException {
        super.read(vis);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.values[i] = vis.read();
        }
    }

    @Override
    public final void write(ValueOutputStream vos) throws IOException {
        super.write(vos);
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            vos.write(this.values[i]);
        }
    }

    @Override
    public final String toString() {
        if (TLCGlobals.useView && viewMap != null) {
            Value val = mytool.eval(viewMap, Context.Empty, this);
            return Value.ppr(val.toString());
        }
        StringBuffer result = new StringBuffer();
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0].getName();
            Value val = this.lookup(key);
            String val_str = val == null ? "null" : Value.ppr(val.toString());
            result.append(key.toString());
            result.append(" = " + val_str + "\n");
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key = vars[i].getName();
                Value val = this.lookup(key);
                String val_str = val == null ? "null" : Value.ppr(val.toString());
                result.append("/\\ ");
                result.append(key.toString());
                result.append(" = " + val_str + "\n");
            }
        }
        return result.toString();
    }

    @Override
    public final String toString(TLCState lastState) {
        StringBuffer result = new StringBuffer();
        TLCStateMut lstate = (TLCStateMut)lastState;
        int vlen = vars.length;
        if (vlen == 1) {
            UniqueString key = vars[0].getName();
            Value val = this.lookup(key);
            Value lstateVal = lstate.lookup(key);
            if (!lstateVal.equals(val)) {
                String val_str = val == null ? "null" : Value.ppr(val.toString());
                result.append(key.toString());
                result.append(" = " + val_str + "\n");
            }
        } else {
            for (int i = 0; i < vlen; ++i) {
                UniqueString key = vars[i].getName();
                Value val = this.lookup(key);
                Value lstateVal = lstate.lookup(key);
                if (lstateVal.equals(val)) continue;
                String val_str = val == null ? "null" : Value.ppr(val.toString());
                result.append("/\\ ");
                result.append(key.toString());
                result.append(" = " + val_str + "\n");
            }
        }
        return result.toString();
    }
}

