/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ExprNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.IStateFunctor;
import tlc2.tool.IWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateMutSource;
import tlc2.tool.TLCTrace;
import tlc2.tool.Worker;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetFactory;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.queue.DiskStateQueue;
import tlc2.tool.queue.IStateQueue;
import tlc2.util.IStateWriter;
import tlc2.util.ObjLongTable;
import tlc2.util.SetOfStates;
import tlc2.util.statistics.BucketStatistics;
import util.DebugPrinter;
import util.FileUtil;
import util.FilenameToStream;
import util.UniqueString;

public class ModelChecker
extends AbstractChecker {
    public static final boolean VETO_CLEANUP = Boolean.getBoolean(ModelChecker.class.getName() + ".vetoCleanup");
    private long numberOfInitialStates;
    public FPSet theFPSet;
    public IStateQueue theStateQueue;
    public TLCTrace trace;
    public long distinctStatesPerMinute;
    public long statesPerMinute = 0L;
    protected long oldNumOfGenStates;
    protected long oldFPSetSize = 0L;
    private final long startTime = System.currentTimeMillis();
    private double runtimeRatio = 0.0;
    private boolean forceLiveCheck = false;

    public ModelChecker(String specFile, String configFile, String dumpFile, boolean asDot, boolean deadlock, String fromChkpt, FilenameToStream resolver, SpecObj specObj, FPSetConfiguration fpSetConfig) throws EvalException, IOException {
        super(specFile, configFile, dumpFile, asDot, deadlock, fromChkpt, true, resolver, specObj);
        this.theStateQueue = new DiskStateQueue(this.metadir);
        this.theFPSet = FPSetFactory.getFPSet(fpSetConfig);
        this.theFPSet.init(TLCGlobals.getNumWorkers(), this.metadir, specFile);
        this.trace = new TLCTrace(this.metadir, specFile, this.tool);
        this.workers = new Worker[TLCGlobals.getNumWorkers()];
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = new Worker(i, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelCheck() throws Exception {
        this.report("entering modelCheck()");
        boolean recovered = this.recover();
        if (!recovered) {
            String plural;
            if (!this.checkAssumptions()) {
                return;
            }
            try {
                this.report("doInit(false)");
                MP.printMessage(2189);
                if (!this.doInit(false)) {
                    this.report("exiting, because init failed");
                    return;
                }
            }
            catch (Throwable e) {
                this.report("exception in init");
                this.report(e);
                String msg = e.getMessage();
                if (e instanceof StackOverflowError) {
                    msg = "This was a Java StackOverflowError. It was probably the result\nof an incorrect recursive function definition that caused TLC to enter\nan infinite loop when trying to compute the function or its application\nto an element in its putative domain.";
                }
                if (msg == null) {
                    msg = e.toString();
                }
                if (this.errState != null) {
                    MP.printError(2102, new String[]{msg, this.errState.toString()});
                } else {
                    MP.printError(1000, msg);
                }
                this.tool.setCallStack();
                try {
                    this.numberOfInitialStates = 0L;
                    this.doInit(true);
                }
                catch (FingerprintException fe) {
                    MP.printError(2147, new String[]{fe.getTrace(), fe.getRootCause().getMessage()});
                }
                catch (Throwable e1) {
                    MP.printError(2103, this.tool.getCallStack().toString());
                }
                this.printSummary(false, this.startTime);
                this.cleanup(false);
                this.report("exiting, because init failed with exception");
                return;
            }
            long statesGenerated = this.getStatesGenerated();
            String string = plural = statesGenerated == 1L ? "" : "s";
            if (statesGenerated == this.theFPSet.size()) {
                MP.printMessage(2190, new String[]{String.valueOf(statesGenerated), plural});
            } else {
                MP.printMessage(2191, new String[]{String.valueOf(statesGenerated), plural, String.valueOf(this.theFPSet.size())});
            }
        }
        this.report("init processed");
        if (this.actions.length == 0) {
            if (this.theStateQueue.isEmpty()) {
                ModelChecker.reportSuccess(this.theFPSet, this.getStatesGenerated());
                this.printSummary(true, this.startTime);
            } else {
                MP.printError(2115);
            }
            this.cleanup(true);
            this.report("exiting with actions.length == 0");
            return;
        }
        boolean success = false;
        try {
            this.report("running TLC");
            success = this.runTLC(Integer.MAX_VALUE);
            if (!success) {
                this.report("TLC terminated with error");
                return;
            }
            if (this.errState == null) {
                if (this.checkLiveness) {
                    MP.printMessage(2200, new String[]{String.valueOf(this.trace.getLevelForReporting()), String.valueOf(this.getStatesGenerated()), String.valueOf(this.theFPSet.size()), String.valueOf(this.theStateQueue.size())});
                    this.report("checking liveness");
                    success = this.liveCheck.finalCheck();
                    this.report("liveness check complete");
                    if (!success) {
                        this.report("exiting error status on liveness check");
                        return;
                    }
                }
                success = true;
                ModelChecker.reportSuccess(this.theFPSet, this.getStatesGenerated());
            } else if (this.keepCallStack) {
                this.tool.setCallStack();
                try {
                    this.doNext(this.predErrState, new ObjLongTable(10), new Worker(4223, this));
                }
                catch (FingerprintException e) {
                    MP.printError(2147, new String[]{e.getTrace(), e.getRootCause().getMessage()});
                }
                catch (Throwable e) {
                    MP.printError(2103, this.tool.getCallStack().toString());
                }
            }
        }
        catch (Exception e) {
            this.report("TLC terminated with error");
            success = false;
            MP.printError(1000, e);
        }
        finally {
            this.printSummary(success, this.startTime);
            if (this.checkLiveness && LIVENESS_STATS) {
                System.gc();
                MP.printStats(this.liveCheck.calculateInDegreeDiskGraphs(new BucketStatistics("Histogram vertex in-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsInDegree")), this.liveCheck.getOutDegreeStatistics());
            }
            this.cleanup(success);
        }
        this.report("exiting modelCheck()");
    }

    public boolean checkAssumptions() {
        ExprNode[] assumps = this.tool.getAssumptions();
        boolean[] isAxiom = this.tool.getAssumptionIsAxiom();
        for (int i = 0; i < assumps.length; ++i) {
            try {
                if (isAxiom[i] || this.tool.isValid(assumps[i])) continue;
                MP.printError(2104, assumps[i].toString());
                return false;
            }
            catch (Exception e) {
                MP.printError(2105, new String[]{assumps[i].toString(), e.getMessage()});
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean doInit(boolean ignoreCancel) throws Throwable {
        if (!ignoreCancel && this.cancellationFlag) {
            return false;
        }
        DoInitFunctor functor = new DoInitFunctor();
        this.tool.getInitStates(functor);
        if (functor.errState != null) {
            this.errState = functor.errState;
            throw functor.e;
        }
        return functor.returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doNext(TLCState curState, ObjLongTable counts, Worker worker) throws Throwable {
        if (this.cancellationFlag) {
            return false;
        }
        boolean deadLocked = true;
        TLCState succState = null;
        SetOfStates liveNextStates = null;
        int unseenSuccessorStates = 0;
        if (this.checkLiveness) {
            liveNextStates = new SetOfStates(16 * (Integer)this.threadLocal.get());
        }
        try {
            int k = 0;
            for (int i = 0; i < this.actions.length; ++i) {
                if (this.cancellationFlag) {
                    return false;
                }
                StateVec nextStates = this.tool.getNextStates(this.actions[i], curState);
                int sz = nextStates.size();
                worker.incrementStatesGenerated(sz);
                deadLocked = deadLocked && sz == 0;
                for (int j = 0; j < sz; ++j) {
                    ModelChecker modelChecker;
                    int len;
                    succState = nextStates.elementAt(j);
                    if (!this.tool.isGoodState(succState)) {
                        ModelChecker modelChecker2 = this;
                        synchronized (modelChecker2) {
                            if (this.setErrState(curState, succState, false)) {
                                MP.printError(2109);
                                this.trace.printTrace(curState, succState);
                                this.theStateQueue.finishAll();
                                this.notify();
                            }
                            return true;
                        }
                    }
                    if (TLCGlobals.coverageInterval >= 0) {
                        ((TLCStateMutSource)succState).addCounts(counts);
                    }
                    boolean inModel = this.tool.isInModel(succState) && this.tool.isInActions(curState, succState);
                    boolean seen = false;
                    if (inModel) {
                        long fp = succState.fingerPrint();
                        seen = this.theFPSet.put(fp);
                        this.allStateWriter.writeState(curState, succState, !seen);
                        if (!seen) {
                            long loc;
                            succState.uid = loc = this.trace.writeState(curState, fp, worker);
                            ++unseenSuccessorStates;
                        }
                        if (this.checkLiveness) {
                            liveNextStates.put(fp, succState);
                        }
                    }
                    if (!seen) {
                        try {
                            len = this.invariants.length;
                            for (k = 0; k < len; ++k) {
                                if (this.cancellationFlag) {
                                    return false;
                                }
                                if (this.tool.isValid(this.invariants[k], succState)) continue;
                                modelChecker = this;
                                synchronized (modelChecker) {
                                    if (TLCGlobals.continuation) {
                                        MP.printError(2110, this.tool.getInvNames()[k]);
                                        this.trace.printTrace(curState, succState);
                                        break;
                                    }
                                    if (this.setErrState(curState, succState, false)) {
                                        MP.printError(2110, this.tool.getInvNames()[k]);
                                        this.trace.printTrace(curState, succState);
                                        this.theStateQueue.finishAll();
                                        this.notify();
                                    }
                                    return true;
                                }
                            }
                            if (k < len) {
                                if (!inModel || seen) continue;
                                this.theStateQueue.sEnqueue(succState);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            modelChecker = this;
                            synchronized (modelChecker) {
                                if (this.setErrState(curState, succState, true)) {
                                    MP.printError(2111, new String[]{this.tool.getInvNames()[k], e.getMessage() == null ? e.toString() : e.getMessage()});
                                    this.trace.printTrace(curState, succState);
                                    this.theStateQueue.finishAll();
                                    this.notify();
                                }
                                throw e;
                            }
                        }
                    }
                    try {
                        len = this.impliedActions.length;
                        for (k = 0; k < len; ++k) {
                            if (this.cancellationFlag) {
                                return false;
                            }
                            if (this.tool.isValid(this.impliedActions[k], curState, succState)) continue;
                            modelChecker = this;
                            synchronized (modelChecker) {
                                if (TLCGlobals.continuation) {
                                    MP.printError(2112, this.tool.getImpliedActNames()[k]);
                                    this.trace.printTrace(curState, succState);
                                    break;
                                }
                                if (this.setErrState(curState, succState, false)) {
                                    MP.printError(2112, this.tool.getImpliedActNames()[k]);
                                    this.trace.printTrace(curState, succState);
                                    this.theStateQueue.finishAll();
                                    this.notify();
                                }
                                return true;
                            }
                        }
                        if (k < len) {
                            if (!inModel || seen) continue;
                            this.theStateQueue.sEnqueue(succState);
                            continue;
                        }
                    }
                    catch (Exception e) {
                        modelChecker = this;
                        synchronized (modelChecker) {
                            if (this.setErrState(curState, succState, true)) {
                                MP.printError(2113, new String[]{this.tool.getImpliedActNames()[k], e.getMessage() == null ? e.toString() : e.getMessage()});
                                this.trace.printTrace(curState, succState);
                                this.theStateQueue.finishAll();
                                this.notify();
                            }
                            throw e;
                        }
                    }
                    if (!inModel || seen) continue;
                    this.theStateQueue.sEnqueue(succState);
                }
                succState = null;
            }
            if (deadLocked && this.checkDeadlock) {
                ModelChecker i = this;
                synchronized (i) {
                    if (this.setErrState(curState, null, false)) {
                        MP.printError(2114);
                        this.trace.printTrace(curState, null);
                        this.theStateQueue.finishAll();
                        this.notify();
                    }
                }
                return true;
            }
            if (this.checkLiveness) {
                long curStateFP = curState.fingerPrint();
                liveNextStates.put(curStateFP, curState);
                this.allStateWriter.writeState(curState, curState, true, IStateWriter.Visualization.STUTTERING);
                this.liveCheck.addNextState(curState, curStateFP, liveNextStates);
                int multiplier = (Integer)this.threadLocal.get();
                if (liveNextStates.capacity() > multiplier * 16) {
                    this.threadLocal.set(multiplier + 1);
                }
            }
            worker.setOutDegree(unseenSuccessorStates);
            return false;
        }
        catch (Throwable e) {
            boolean keep = e instanceof StackOverflowError || e instanceof OutOfMemoryError || e instanceof AssertionError;
            ModelChecker modelChecker = this;
            synchronized (modelChecker) {
                if (this.setErrState(curState, succState, !keep)) {
                    if (e instanceof StackOverflowError) {
                        MP.printError(1005, e);
                    } else if (e instanceof OutOfMemoryError) {
                        MP.printError(1001, e);
                    } else if (e instanceof AssertionError) {
                        MP.printError(2128, e);
                    } else if (e.getMessage() != null) {
                        MP.printError(1000, e);
                    }
                    this.trace.printTrace(curState, succState);
                    this.theStateQueue.finishAll();
                    this.notify();
                }
            }
            throw e;
        }
    }

    @Override
    public final boolean doPeriodicWork() throws Exception {
        boolean createCheckPoint = TLCGlobals.doCheckPoint();
        if (!(this.checkLiveness && !(this.runtimeRatio > TLCGlobals.livenessRatio) && this.liveCheck.doLiveCheck() || this.forceLiveCheck || createCheckPoint)) {
            this.updateRuntimeRatio(0L);
            return true;
        }
        if (this.theStateQueue.suspendAll()) {
            if (this.checkLiveness && (this.runtimeRatio < TLCGlobals.livenessRatio || this.forceLiveCheck)) {
                long preLivenessChecking = System.currentTimeMillis();
                if (!this.liveCheck.check(this.forceLiveCheck)) {
                    return false;
                }
                this.forceLiveCheck = false;
                this.updateRuntimeRatio(System.currentTimeMillis() - preLivenessChecking);
            } else if (this.runtimeRatio > TLCGlobals.livenessRatio) {
                this.updateRuntimeRatio(0L);
            }
            if (createCheckPoint) {
                MP.printMessage(2195, this.metadir);
                this.theStateQueue.beginChkpt();
                this.trace.beginChkpt();
                this.theFPSet.beginChkpt();
                this.theStateQueue.resumeAll();
                UniqueString.internTbl.beginChkpt(this.metadir);
                if (this.checkLiveness) {
                    this.liveCheck.beginChkpt();
                }
                this.theStateQueue.commitChkpt();
                this.trace.commitChkpt();
                this.theFPSet.commitChkpt();
                UniqueString.internTbl.commitChkpt(this.metadir);
                if (this.checkLiveness) {
                    this.liveCheck.commitChkpt();
                }
                MP.printMessage(2196);
            } else {
                this.theStateQueue.resumeAll();
            }
        }
        return true;
    }

    public void forceLiveCheck() {
        this.forceLiveCheck = true;
    }

    protected void updateRuntimeRatio(long delta) {
        assert (delta >= 0L);
        long totalRuntime = System.currentTimeMillis() - this.startTime;
        totalRuntime -= 60000L;
        double absLivenessRuntime = Math.max((double)(totalRuntime -= delta) * this.runtimeRatio, 0.0);
        this.runtimeRatio = ((double)delta + absLivenessRuntime) / (double)(totalRuntime + 60000L + delta);
    }

    public double getRuntimeRatio() {
        return this.runtimeRatio;
    }

    public final boolean recover() throws IOException {
        boolean recovered = false;
        if (this.fromChkpt != null) {
            MP.printMessage(2197, this.fromChkpt);
            this.trace.recover();
            this.theStateQueue.recover();
            this.theFPSet.recover();
            if (this.checkLiveness) {
                this.tool.getInitStates(new IStateFunctor(){

                    @Override
                    public Object addElement(TLCState state) {
                        ModelChecker.this.liveCheck.addInitState(state, state.fingerPrint());
                        return true;
                    }
                });
                this.liveCheck.recover();
            }
            MP.printMessage(2198, new String[]{String.valueOf(this.theFPSet.size()), String.valueOf(this.theStateQueue.size())});
            recovered = true;
            this.numberOfInitialStates = this.theFPSet.size();
        }
        return recovered;
    }

    private final void cleanup(boolean success) throws IOException {
        this.theFPSet.close();
        this.trace.close();
        if (this.checkLiveness) {
            this.liveCheck.close();
        }
        this.allStateWriter.close();
        if (!VETO_CLEANUP) {
            FileUtil.deleteDir(this.metadir, success);
        }
    }

    public final void printSummary(boolean success, long startTime) throws IOException {
        super.reportCoverage(this.workers);
        if (TLCGlobals.tool) {
            this.printProgresStats(startTime);
        }
        MP.printMessage(2199, new String[]{String.valueOf(this.getStatesGenerated()), String.valueOf(this.theFPSet.size()), String.valueOf(this.theStateQueue.size())});
        if (success) {
            MP.printMessage(2194, String.valueOf(this.trace.getLevelForFinalReporting()));
            BucketStatistics aggOutDegree = new BucketStatistics("State Graph OutDegree");
            for (IWorker worker : this.workers) {
                aggOutDegree.add(((Worker)worker).getOutDegree());
            }
            if (aggOutDegree.getObservations() > 0L) {
                MP.printMessage(2268, new String[]{Integer.toString(aggOutDegree.getMin()), Long.toString(Math.round(aggOutDegree.getMean())), Long.toString(Math.round(aggOutDegree.getPercentile(0.95))), Integer.toString(aggOutDegree.getMax())});
            }
        }
    }

    private final void printProgresStats(long startTime) throws IOException {
        double factor;
        long fpSetSize = this.theFPSet.size();
        if (startTime < 0L) {
            factor = 1.0;
        } else {
            this.oldNumOfGenStates = 0L;
            this.oldFPSetSize = 0L;
            factor = (double)(System.currentTimeMillis() - startTime) / 60000.0;
        }
        long l = this.getStatesGenerated();
        this.statesPerMinute = (long)((double)(l - this.oldNumOfGenStates) / factor);
        this.oldNumOfGenStates = l;
        this.distinctStatesPerMinute = (long)((double)(fpSetSize - this.oldFPSetSize) / factor);
        this.oldFPSetSize = fpSetSize;
        MP.printMessage(2200, new String[]{String.valueOf(this.trace.getLevelForReporting()), String.valueOf(l), String.valueOf(fpSetSize), String.valueOf(this.theStateQueue.size()), String.valueOf(this.statesPerMinute), String.valueOf(this.distinctStatesPerMinute)});
    }

    public static final void reportSuccess(FPSet anFpSet, long numOfGenStates) throws IOException {
        long fpSetSize = anFpSet.size();
        double actualProb = anFpSet.checkFPs();
        ModelChecker.reportSuccess(fpSetSize, actualProb, numOfGenStates);
    }

    @Override
    protected IWorker[] startWorkers(AbstractChecker checker, int checkIndex) {
        this.theFPSet.incWorkers(this.workers.length);
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].start();
        }
        return this.workers;
    }

    @Override
    protected void runTLCContinueDoing(int count, int depth) throws Exception {
        int level = this.trace.getLevel();
        this.printProgresStats(-1L);
        if (level > depth) {
            this.theStateQueue.finishAll();
            this.done = true;
        } else {
            if (count == 0) {
                super.reportCoverage(this.workers);
            }
            this.wait(60000L);
        }
    }

    private void report(Throwable e) {
        DebugPrinter.print(e);
    }

    public long getStatesGenerated() {
        long sum = this.numberOfInitialStates;
        for (IWorker worker : this.workers) {
            sum += ((Worker)worker).getStatesGenerated();
        }
        return sum;
    }

    private class DoInitFunctor
    implements IStateFunctor {
        private TLCState errState;
        private Throwable e;
        private boolean returnValue = true;

        private DoInitFunctor() {
        }

        @Override
        public Object addElement(TLCState curState) {
            ModelChecker.this.numberOfInitialStates++;
            if (this.errState != null) {
                this.returnValue = false;
                return this.returnValue;
            }
            try {
                long fp;
                if (!ModelChecker.this.tool.isGoodState(curState)) {
                    MP.printError(2102, new String[]{"current state is not a legal state", curState.toString()});
                    return this.returnValue;
                }
                boolean inModel = ModelChecker.this.tool.isInModel(curState);
                boolean seen = false;
                if (inModel && !(seen = ModelChecker.this.theFPSet.put(fp = curState.fingerPrint()))) {
                    ModelChecker.this.allStateWriter.writeState(curState);
                    curState.uid = ModelChecker.this.trace.writeState(fp);
                    ModelChecker.this.theStateQueue.enqueue(curState);
                    if (ModelChecker.this.checkLiveness) {
                        ModelChecker.this.liveCheck.addInitState(curState, fp);
                    }
                }
                if (!seen) {
                    int j;
                    for (j = 0; j < ModelChecker.this.invariants.length; ++j) {
                        if (ModelChecker.this.tool.isValid(ModelChecker.this.invariants[j], curState)) continue;
                        MP.printError(2107, new String[]{ModelChecker.this.tool.getInvNames()[j].toString(), curState.toString()});
                        if (TLCGlobals.continuation) continue;
                        this.returnValue = false;
                        return this.returnValue;
                    }
                    for (j = 0; j < ModelChecker.this.impliedInits.length; ++j) {
                        if (ModelChecker.this.tool.isValid(ModelChecker.this.impliedInits[j], curState)) continue;
                        MP.printError(2108, new String[]{ModelChecker.this.tool.getImpliedInitNames()[j], curState.toString()});
                        this.returnValue = false;
                        return this.returnValue;
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    MP.printError(1002);
                    this.returnValue = false;
                    return this.returnValue;
                }
                this.errState = curState;
                this.e = e;
            }
            return this.returnValue;
        }
    }
}

