/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.SemanticNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.Cancelable;
import tlc2.tool.EvalException;
import tlc2.tool.IWorker;
import tlc2.tool.TLCState;
import tlc2.tool.Tool;
import tlc2.tool.liveness.AddAndCheckLiveCheck;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.LiveCheck;
import tlc2.tool.liveness.Liveness;
import tlc2.tool.liveness.NoOpLiveCheck;
import tlc2.util.DotStateWriter;
import tlc2.util.IStateWriter;
import tlc2.util.NoopStateWriter;
import tlc2.util.ObjLongTable;
import tlc2.util.StateWriter;
import tlc2.util.statistics.ConcurrentBucketStatistics;
import tlc2.util.statistics.DummyBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.value.Value;
import util.DebugPrinter;
import util.FileUtil;
import util.FilenameToStream;

public abstract class AbstractChecker
implements Cancelable {
    public static boolean LIVENESS_TESTING_IMPLEMENTATION = Boolean.getBoolean(ILiveCheck.class.getName() + ".testing");
    protected static final boolean LIVENESS_STATS = Boolean.getBoolean(Liveness.class.getPackage().getName() + ".statistics");
    protected TLCState predErrState;
    protected TLCState errState;
    protected boolean done;
    protected boolean keepCallStack;
    protected boolean checkDeadlock;
    protected boolean checkLiveness;
    protected String fromChkpt;
    public String metadir;
    public Tool tool;
    public final SpecObj specObj;
    public Action[] invariants;
    public Action[] impliedActions;
    public Action[] impliedInits;
    public Action[] actions;
    protected final IStateWriter allStateWriter;
    protected boolean cancellationFlag = false;
    protected IWorker[] workers;
    protected final ILiveCheck liveCheck;
    protected final ThreadLocal<Integer> threadLocal = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    protected static final int INITIAL_CAPACITY = 16;

    public AbstractChecker(String specFile, String configFile, String dumpFile, boolean asDot, boolean deadlock, String fromChkpt, boolean preprocess, FilenameToStream resolver, SpecObj spec) throws EvalException, IOException {
        this.checkDeadlock = deadlock;
        int lastSep = specFile.lastIndexOf(FileUtil.separatorChar);
        String specDir = lastSep == -1 ? "" : specFile.substring(0, lastSep + 1);
        specFile = specFile.substring(lastSep + 1);
        this.tool = new Tool(specDir, specFile, configFile, resolver);
        this.specObj = this.tool.init(preprocess, spec);
        this.checkLiveness = !this.tool.livenessIsTrue();
        this.metadir = FileUtil.makeMetaDir(specDir, fromChkpt);
        this.errState = null;
        this.predErrState = null;
        this.done = false;
        this.keepCallStack = false;
        this.fromChkpt = fromChkpt;
        if (dumpFile != null) {
            if (dumpFile.startsWith("${metadir}")) {
                dumpFile = dumpFile.replace("${metadir}", this.metadir);
            }
            this.allStateWriter = asDot ? new DotStateWriter(dumpFile) : new StateWriter(dumpFile);
        } else {
            this.allStateWriter = new NoopStateWriter();
        }
        this.impliedInits = this.tool.getImpliedInits();
        this.invariants = this.tool.getInvariants();
        this.impliedActions = this.tool.getImpliedActions();
        this.actions = this.tool.getActions();
        if (this.checkLiveness) {
            if (this.tool.hasSymmetry()) {
                MP.printWarning(2279);
            }
            this.report("initializing liveness checking");
            IBucketStatistics stats = new DummyBucketStatistics();
            if (LIVENESS_STATS) {
                stats = new ConcurrentBucketStatistics("Histogram vertex out-degree", LiveCheck.class.getPackage().getName(), "DiskGraphsOutDegree");
            }
            this.liveCheck = LIVENESS_TESTING_IMPLEMENTATION ? new AddAndCheckLiveCheck(this.tool, this.actions, this.metadir, stats) : new LiveCheck(this.tool, this.actions, this.metadir, stats, dumpFile);
            this.report("liveness checking initialized");
        } else {
            this.liveCheck = new NoOpLiveCheck(this.tool, this.metadir);
        }
    }

    public final void setDone() {
        this.done = true;
    }

    public boolean setErrState(TLCState curState, TLCState succState, boolean keep) {
        assert (Thread.holdsLock(this)) : "Caller thread has to hold monitor!";
        if (!TLCGlobals.continuation && this.done) {
            return false;
        }
        this.predErrState = curState;
        this.errState = succState == null ? curState : succState;
        this.done = true;
        this.keepCallStack = keep;
        return true;
    }

    protected void reportCoverage(IWorker[] workers) {
        if (TLCGlobals.coverageInterval >= 0 && this.actions.length > 0) {
            MP.printMessage(2201);
            ObjLongTable counts = this.tool.getPrimedLocs();
            for (int i = 0; i < workers.length; ++i) {
                Object key;
                ObjLongTable counts1 = workers[i].getCounts();
                ObjLongTable.Enumerator keys = counts1.keys();
                while ((key = keys.nextElement()) != null) {
                    String loc = ((SemanticNode)key).getLocation().toString();
                    counts.add(loc, counts1.get(key));
                }
            }
            String[] skeys = counts.sortStringKeys();
            for (int i = 0; i < skeys.length; ++i) {
                long val = counts.get(skeys[i]);
                MP.printMessage(2221, new String[]{skeys[i].toString(), String.valueOf(val)});
            }
            MP.printMessage(2202);
        }
    }

    public static final void reportSuccess(long numOfDistinctStates, double actualProb, long numOfGenStates) throws IOException {
        double optimisticProb = (double)numOfDistinctStates * ((double)(numOfGenStates - numOfDistinctStates) / Math.pow(2.0, 64.0));
        String optimisticProbStr = "val = " + AbstractChecker.ProbabilityToString(optimisticProb, 2);
        String actualProbStr = "val = " + AbstractChecker.ProbabilityToString(actualProb, 2);
        MP.printMessage(2193, new String[]{optimisticProbStr, actualProbStr});
    }

    private static final String ProbabilityToString(double val, int significantDigits) {
        int next;
        if (val == 0.0) {
            return "0.0";
        }
        String valString = Double.toString(val);
        int valStringLen = valString.length();
        String result = "";
        int significantDigitsFound = 0;
        for (next = 0; next < valStringLen && valString.charAt(next) == '0'; ++next) {
        }
        while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
            result = result + valString.charAt(next);
            ++significantDigitsFound;
            ++next;
        }
        if (next == valStringLen) {
            return result;
        }
        if (valString.charAt(next) != '.') {
            return valString;
        }
        if (significantDigitsFound >= significantDigits) {
            ++next;
            while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
                ++next;
            }
        } else {
            ++next;
            result = result + ".";
            if (significantDigitsFound == 0) {
                while (next < valStringLen && valString.charAt(next) == '0') {
                    ++next;
                    result = result + "0";
                }
            }
            while (next < valStringLen && Character.isDigit(valString.charAt(next)) && significantDigitsFound < significantDigits) {
                result = result + valString.charAt(next);
                ++next;
                ++significantDigitsFound;
            }
            if (next < valStringLen && Character.isDigit(valString.charAt(next)) && Character.digit(valString.charAt(next), 10) >= 5) {
                int prev = result.length() - 1;
                boolean done = false;
                while (!done) {
                    if (prev < 0) {
                        result = "1" + result;
                        done = true;
                    } else {
                        char prevChar = result.charAt(prev);
                        String front = result.substring(0, prev);
                        String back = result.substring(prev + 1);
                        if (Character.isDigit(prevChar)) {
                            if (prevChar == '9') {
                                result = front + '0' + back;
                            } else {
                                result = front + Character.forDigit(Character.digit(prevChar, 10) + 1, 10) + back;
                                done = true;
                            }
                        }
                    }
                    --prev;
                }
            }
            while (next < valStringLen && Character.isDigit(valString.charAt(next))) {
                ++next;
            }
        }
        if (next >= valStringLen) {
            return result;
        }
        if (valString.charAt(next) == 'E') {
            ++next;
            result = result + "E";
            while (next < valStringLen) {
                result = result + valString.charAt(next);
                ++next;
            }
            return result;
        }
        return valString;
    }

    public abstract boolean doInit(boolean var1) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean runTLC(int depth) throws Exception {
        if (this.cancellationFlag) {
            return false;
        }
        if (depth < 2) {
            return true;
        }
        this.workers = this.startWorkers(this, depth);
        int count = TLCGlobals.coverageInterval / 60000;
        AbstractChecker abstractChecker = this;
        synchronized (abstractChecker) {
            if (!this.done) {
                this.wait(3000L);
            }
        }
        while (!this.cancellationFlag) {
            if (!this.doPeriodicWork()) {
                return false;
            }
            abstractChecker = this;
            synchronized (abstractChecker) {
                if (!this.done) {
                    this.runTLCContinueDoing(count, depth);
                    count = count == 0 ? TLCGlobals.coverageInterval / 60000 : --count;
                }
                if (this.done) {
                    break;
                }
            }
        }
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].join();
        }
        return true;
    }

    @Override
    public void setCancelFlag(boolean flag) {
        this.cancellationFlag = flag;
    }

    public final void setAllValues(int idx, Value val) {
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i].setLocalValue(idx, val);
        }
    }

    public final Value getValue(int i, int idx) {
        return this.workers[i].getLocalValue(idx);
    }

    protected void report(String message) {
        DebugPrinter.print(message);
    }

    protected abstract IWorker[] startWorkers(AbstractChecker var1, int var2);

    public abstract boolean doPeriodicWork() throws Exception;

    protected abstract void runTLCContinueDoing(int var1, int var2) throws Exception;

    public abstract void modelCheck() throws Exception;
}

