/*
 * Decompiled with CFR 0.152.
 */
package tlc2;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TimeZone;
import model.InJarFilenameToStream;
import model.ModelInJar;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.Cancelable;
import tlc2.tool.DFIDModelChecker;
import tlc2.tool.ModelChecker;
import tlc2.tool.Simulator;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.management.ModelCheckerMXWrapper;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.FP64;
import tlc2.util.RandomGenerator;
import tlc2.value.Value;
import util.DebugPrinter;
import util.FileUtil;
import util.FilenameToStream;
import util.MailSender;
import util.SimpleFilenameToStream;
import util.TLCRuntime;
import util.ToolIO;
import util.UniqueString;

public class TLC {
    private static boolean MODEL_PART_OF_JAR = false;
    private boolean isSimulate = false;
    private boolean cleanup = false;
    private boolean deadlock = true;
    private boolean noSeed = true;
    private long seed = 0L;
    private long aril = 0L;
    private String mainFile = null;
    private String configFile = null;
    private String dumpFile = null;
    private boolean asDot = false;
    private String fromChkpt = null;
    private int fpIndex = 0;
    public static long traceNum = Long.MAX_VALUE;
    private int traceDepth = 100;
    private FilenameToStream resolver = null;
    private SpecObj specObj;
    private boolean welcomePrinted = false;
    private Cancelable instance = null;
    private FPSetConfiguration fpSetConfiguration = new FPSetConfiguration();

    public static void main(String[] args) throws Exception {
        TLC tlc = new TLC();
        if (tlc.handleParameters(args)) {
            MailSender ms = new MailSender();
            if (MODEL_PART_OF_JAR) {
                tlc.setResolver(new InJarFilenameToStream("/model/"));
            } else {
                tlc.setResolver(new SimpleFilenameToStream());
            }
            ms.setModelName(tlc.getModelName());
            ms.setSpecName(tlc.getSpecName());
            tlc.process();
            boolean success = ms.send(tlc.getModuleFiles());
            if (!success) {
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public boolean handleParameters(String[] args) {
        int index = 0;
        while (index < args.length) {
            if (args[index].equals("-simulate")) {
                this.isSimulate = true;
                ++index;
                continue;
            }
            if (args[index].equals("-modelcheck")) {
                this.isSimulate = false;
                ++index;
                continue;
            }
            if (args[index].equals("-difftrace")) {
                ++index;
                TLCGlobals.printDiffsOnly = true;
                continue;
            }
            if (args[index].equals("-deadlock")) {
                ++index;
                this.deadlock = false;
                continue;
            }
            if (args[index].equals("-cleanup")) {
                ++index;
                this.cleanup = true;
                continue;
            }
            if (args[index].equals("-nowarning")) {
                ++index;
                TLCGlobals.warn = false;
                continue;
            }
            if (args[index].equals("-gzip")) {
                ++index;
                TLCGlobals.useGZIP = true;
                continue;
            }
            if (args[index].equals("-terse")) {
                ++index;
                Value.expand = false;
                continue;
            }
            if (args[index].equals("-continue")) {
                ++index;
                TLCGlobals.continuation = true;
                continue;
            }
            if (args[index].equals("-view")) {
                ++index;
                TLCGlobals.useView = true;
                continue;
            }
            if (args[index].equals("-debug")) {
                ++index;
                TLCGlobals.debug = true;
                continue;
            }
            if (args[index].equals("-tool")) {
                ++index;
                TLCGlobals.tool = true;
                continue;
            }
            if (args[index].equals("-help")) {
                this.printUsage();
                return false;
            }
            if (args[index].equals("-lncheck")) {
                if (++index < args.length) {
                    TLCGlobals.lnCheck = args[index].toLowerCase();
                    ++index;
                    continue;
                }
                this.printErrorMsg("Error: expect a strategy such as final for -lncheck option.");
                return false;
            }
            if (args[index].equals("-config")) {
                if (++index < args.length) {
                    this.configFile = args[index];
                    int len = this.configFile.length();
                    if (this.configFile.startsWith(".cfg", len - 4)) {
                        this.configFile = this.configFile.substring(0, len - 4);
                    }
                    ++index;
                    continue;
                }
                this.printErrorMsg("Error: expect a file name for -config option.");
                return false;
            }
            if (args[index].equals("-dump")) {
                String suffix = ".dump";
                if (++index < args.length && args[index].equals("dot")) {
                    this.asDot = true;
                    suffix = ".dot";
                    ++index;
                }
                if (index < args.length) {
                    this.dumpFile = args[index];
                    int len = this.dumpFile.length();
                    if (!this.dumpFile.startsWith(suffix, len - suffix.length())) {
                        this.dumpFile = this.dumpFile + suffix;
                    }
                    ++index;
                    continue;
                }
                this.printErrorMsg("Error: A file name for dumping states required.");
                return false;
            }
            if (args[index].equals("-coverage")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.coverageInterval = Integer.parseInt(args[index]) * 60 * 1000;
                        if (TLCGlobals.coverageInterval < 0) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -coverage option.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.printErrorMsg("Error: An integer for coverage report interval required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: coverage report interval required.");
                return false;
            }
            if (args[index].equals("-checkpoint")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.chkptDuration = Integer.parseInt(args[index]) * 1000 * 60;
                        if (TLCGlobals.chkptDuration < 0L) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -checkpoint option.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for checkpoint interval is required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: checkpoint interval required.");
                return false;
            }
            if (args[index].equals("-depth")) {
                if (++index < args.length) {
                    try {
                        this.traceDepth = Integer.parseInt(args[index]);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for trace length required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: trace length required.");
                return false;
            }
            if (args[index].equals("-seed")) {
                if (++index < args.length) {
                    try {
                        this.seed = Long.parseLong(args[index]);
                        ++index;
                        this.noSeed = false;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for seed required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: seed required.");
                return false;
            }
            if (args[index].equals("-aril")) {
                if (++index < args.length) {
                    try {
                        this.aril = Long.parseLong(args[index]);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for aril required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: aril required.");
                return false;
            }
            if (args[index].equals("-maxSetSize")) {
                if (++index < args.length) {
                    try {
                        int bound = Integer.parseInt(args[index]);
                        if (!TLCGlobals.isValidSetSize(bound)) {
                            int maxValue = Integer.MAX_VALUE;
                            this.printErrorMsg("Error: Value in interval [0, " + maxValue + "] for maxSetSize required. But encountered " + args[index]);
                            return false;
                        }
                        TLCGlobals.setBound = bound;
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for maxSetSize required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: maxSetSize required.");
                return false;
            }
            if (args[index].equals("-recover")) {
                if (++index < args.length) {
                    this.fromChkpt = args[index++] + FileUtil.separator;
                    continue;
                }
                this.printErrorMsg("Error: need to specify the metadata directory for recovery.");
                return false;
            }
            if (args[index].equals("-metadir")) {
                if (++index < args.length) {
                    TLCGlobals.metaDir = args[index++] + FileUtil.separator;
                    continue;
                }
                this.printErrorMsg("Error: need to specify the metadata directory.");
                return false;
            }
            if (args[index].equals("-userFile")) {
                if (++index < args.length) {
                    try {
                        tlc2.module.TLC.OUTPUT = new BufferedWriter(new FileWriter(new File(args[index++])));
                        continue;
                    }
                    catch (IOException e) {
                        this.printErrorMsg("Error: Failed to create user output log file.");
                        return false;
                    }
                }
                this.printErrorMsg("Error: need to specify the full qualified file.");
                return false;
            }
            if (args[index].equals("-workers")) {
                if (++index < args.length) {
                    try {
                        int num = Integer.parseInt(args[index]);
                        if (num < 1) {
                            this.printErrorMsg("Error: at least one worker required.");
                            return false;
                        }
                        TLCGlobals.setNumWorkers(num);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: worker number required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect an integer for -workers option.");
                return false;
            }
            if (args[index].equals("-dfid")) {
                if (++index < args.length) {
                    try {
                        TLCGlobals.DFIDMax = Integer.parseInt(args[index]);
                        if (TLCGlobals.DFIDMax < 0) {
                            this.printErrorMsg("Error: expect a nonnegative integer for -dfid option.");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Errorexpect a nonnegative integer for -dfid option. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect a nonnegative integer for -dfid option.");
                return false;
            }
            if (args[index].equals("-fp")) {
                if (++index < args.length) {
                    try {
                        this.fpIndex = Integer.parseInt(args[index]);
                        if (this.fpIndex < 0 || this.fpIndex >= FP64.Polys.length) {
                            this.printErrorMsg("Error: The number for -fp must be between 0 and " + (FP64.Polys.length - 1) + " (inclusive).");
                            return false;
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: A number for -fp is required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: expect an integer for -workers option.");
                return false;
            }
            if (args[index].equals("-fpmem")) {
                if (++index < args.length) {
                    try {
                        double fpMemSize = Double.parseDouble(args[index]);
                        if (fpMemSize < 0.0) {
                            this.printErrorMsg("Error: An positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index]);
                            return false;
                        }
                        if (fpMemSize > 1.0) {
                            ToolIO.out.println("Using -fpmem with an abolute memory value has been deprecated. Please allocate memory for the TLC process via the JVM mechanisms and use -fpmem to set the fraction to be used for fingerprint storage.");
                            this.fpSetConfiguration.setMemory((long)fpMemSize);
                            this.fpSetConfiguration.setRatio(1.0);
                        } else {
                            this.fpSetConfiguration.setRatio(fpMemSize);
                        }
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An positive integer or a fraction for fpset memory size/percentage required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: fpset memory size required.");
                return false;
            }
            if (args[index].equals("-fpbits")) {
                if (++index < args.length) {
                    try {
                        int fpBits = Integer.parseInt(args[index]);
                        if (!FPSet.isValid(fpBits)) {
                            this.printErrorMsg("Error: Value in interval [0, 30] for fpbits required. But encountered " + args[index]);
                            return false;
                        }
                        this.fpSetConfiguration.setFpBits(fpBits);
                        ++index;
                        continue;
                    }
                    catch (Exception e) {
                        this.printErrorMsg("Error: An integer for fpbits required. But encountered " + args[index]);
                        return false;
                    }
                }
                this.printErrorMsg("Error: fpbits required.");
                return false;
            }
            if (args[index].charAt(0) == '-') {
                this.printErrorMsg("Error: unrecognized option: " + args[index]);
                return false;
            }
            if (this.mainFile != null) {
                this.printErrorMsg("Error: more than one input files: " + this.mainFile + " and " + args[index]);
                return false;
            }
            this.mainFile = args[index++];
            int len = this.mainFile.length();
            if (!this.mainFile.startsWith(".tla", len - 4)) continue;
            this.mainFile = this.mainFile.substring(0, len - 4);
        }
        if (this.mainFile == null) {
            if (ModelInJar.hasModel()) {
                MODEL_PART_OF_JAR = true;
                ModelInJar.loadProperties();
                TLCGlobals.tool = true;
                TLCGlobals.chkptDuration = 0L;
                this.mainFile = "MC";
            } else {
                this.printErrorMsg("Error: Missing input TLA+ module.");
                return false;
            }
        }
        if (this.configFile == null) {
            this.configFile = this.mainFile;
        }
        if (TLCGlobals.debug) {
            StringBuffer buffer = new StringBuffer("TLC arguments:");
            for (int i = 0; i < args.length; ++i) {
                buffer.append(args[i]);
                if (i >= args.length - 1) continue;
                buffer.append(" ");
            }
            buffer.append("\n");
            DebugPrinter.print(buffer.toString());
        }
        this.printWelcome();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void process() {
        block27: {
            TLCStandardMBean modelCheckerMXWrapper;
            long startTime;
            block25: {
                startTime = System.currentTimeMillis();
                ToolIO.cleanToolObjects(TLCGlobals.ToolId);
                modelCheckerMXWrapper = TLCStandardMBean.getNullTLCStandardMBean();
                if (this.fromChkpt != null) {
                    UniqueString.internTbl.recover(this.fromChkpt);
                }
                if (this.cleanup && this.fromChkpt == null) {
                    FileUtil.deleteDir("states", true);
                }
                FP64.Init(this.fpIndex);
                TLCRuntime tlcRuntime2333333332 = TLCRuntime.getInstance();
                long offHeapMemory = tlcRuntime2333333332.getNonHeapPhysicalMemory() / 1024L / 1024L;
                String arch = tlcRuntime2333333332.getArchitecture().name();
                Runtime runtime = Runtime.getRuntime();
                long heapMemory = runtime.maxMemory() / 1024L / 1024L;
                String cores = Integer.toString(runtime.availableProcessors());
                String vendor = System.getProperty("java.vendor");
                String version = System.getProperty("java.version");
                String osName = System.getProperty("os.name");
                String osVersion = System.getProperty("os.version");
                String osArch = System.getProperty("os.arch");
                if (this.isSimulate) {
                    Simulator simulator;
                    RandomGenerator rng = new RandomGenerator();
                    if (this.noSeed) {
                        this.seed = rng.nextLong();
                        rng.setSeed(this.seed);
                    } else {
                        rng.setSeed(this.seed, this.aril);
                    }
                    MP.printMessage(2188, new String[]{String.valueOf(this.seed), String.valueOf(TLCGlobals.getNumWorkers()), TLCGlobals.getNumWorkers() == 1 ? "" : "s", cores, osName, osVersion, osArch, vendor, version, arch, Long.toString(heapMemory), Long.toString(offHeapMemory)});
                    TLCGlobals.simulator = simulator = new Simulator(this.mainFile, this.configFile, null, this.deadlock, this.traceDepth, traceNum, rng, this.seed, true, this.resolver, this.specObj);
                    this.instance = simulator;
                    simulator.simulate();
                } else {
                    String[] parameters = new String[]{String.valueOf(TLCGlobals.getNumWorkers()), TLCGlobals.getNumWorkers() == 1 ? "" : "s", cores, osName, osVersion, osArch, vendor, version, arch, Long.toString(heapMemory), Long.toString(offHeapMemory)};
                    AbstractChecker mc = null;
                    if (TLCGlobals.DFIDMax == -1) {
                        MP.printMessage(2187, parameters);
                        mc = new ModelChecker(this.mainFile, this.configFile, this.dumpFile, this.asDot, this.deadlock, this.fromChkpt, this.resolver, this.specObj, this.fpSetConfiguration);
                        modelCheckerMXWrapper = new ModelCheckerMXWrapper((ModelChecker)mc, this);
                    } else {
                        MP.printMessage(2271, parameters);
                        mc = new DFIDModelChecker(this.mainFile, this.configFile, this.dumpFile, this.asDot, this.deadlock, this.fromChkpt, true, this.resolver, this.specObj);
                    }
                    TLCGlobals.mainChecker = mc;
                    this.instance = mc;
                    mc.modelCheck();
                }
                if (tlc2.module.TLC.OUTPUT == null) break block25;
                try {
                    tlc2.module.TLC.OUTPUT.flush();
                    tlc2.module.TLC.OUTPUT.close();
                }
                catch (IOException tlcRuntime2333333332) {
                    // empty catch block
                }
            }
            modelCheckerMXWrapper.unregister();
            long runtime = System.currentTimeMillis() - startTime;
            MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime) + "ms" : TLC.convertRuntimeToHumanReadable(runtime));
            MP.flush();
            break block27;
            catch (Throwable e222222222) {
                block26: {
                    try {
                        if (e222222222 instanceof StackOverflowError) {
                            System.gc();
                            MP.printError(1005, e222222222);
                        } else if (e222222222 instanceof OutOfMemoryError) {
                            System.gc();
                            MP.printError(1001, e222222222);
                        } else if (e222222222 instanceof RuntimeException) {
                            MP.printError(1000, e222222222);
                        } else {
                            MP.printError(1000, e222222222);
                        }
                        if (tlc2.module.TLC.OUTPUT == null) break block26;
                    }
                    catch (Throwable throwable) {
                        if (tlc2.module.TLC.OUTPUT != null) {
                            try {
                                tlc2.module.TLC.OUTPUT.flush();
                                tlc2.module.TLC.OUTPUT.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        modelCheckerMXWrapper.unregister();
                        long runtime2 = System.currentTimeMillis() - startTime;
                        MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime2) + "ms" : TLC.convertRuntimeToHumanReadable(runtime2));
                        MP.flush();
                        throw throwable;
                    }
                    try {
                        tlc2.module.TLC.OUTPUT.flush();
                        tlc2.module.TLC.OUTPUT.close();
                    }
                    catch (IOException e222222222) {
                        // empty catch block
                    }
                }
                modelCheckerMXWrapper.unregister();
                runtime = System.currentTimeMillis() - startTime;
                MP.printMessage(2186, TLCGlobals.tool ? Long.toString(runtime) + "ms" : TLC.convertRuntimeToHumanReadable(runtime));
                MP.flush();
            }
        }
    }

    public static String convertRuntimeToHumanReadable(long runtime) {
        SimpleDateFormat df = null;
        if (runtime > 86400000L) {
            df = new SimpleDateFormat("D'd' HH'h'");
            runtime -= 86400000L;
        } else if (runtime > 86400000L) {
            df = new SimpleDateFormat("D'd' HH'h'");
            runtime -= 86400000L;
        } else {
            df = runtime > 3600000L ? new SimpleDateFormat("HH'h' mm'min'") : (runtime > 60000L ? new SimpleDateFormat("mm'min' ss's'") : new SimpleDateFormat("ss's'"));
        }
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(runtime);
    }

    public List<File> getModuleFiles() {
        ArrayList<File> result = new ArrayList<File>();
        if (this.instance instanceof ModelChecker) {
            ModelChecker mc = (ModelChecker)this.instance;
            Enumeration<ParseUnit> parseUnitContext = mc.specObj.parseUnitContext.elements();
            while (parseUnitContext.hasMoreElements()) {
                ParseUnit pu = parseUnitContext.nextElement();
                File resolve = this.resolver.resolve(pu.getFileName(), false);
                result.add(resolve);
            }
        }
        return result;
    }

    public void setResolver(FilenameToStream resolver) {
        this.resolver = resolver;
        ToolIO.setDefaultResolver(resolver);
    }

    public void setSpecObject(SpecObj specObj) {
        this.specObj = specObj;
    }

    public void setCanceledFlag(boolean flag) {
        if (this.instance != null) {
            this.instance.setCancelFlag(flag);
            DebugPrinter.print("Cancel flag set to " + flag);
        }
    }

    private void printErrorMsg(String msg) {
        this.printWelcome();
        MP.printError(1102, msg);
    }

    private void printWelcome() {
        if (!this.welcomePrinted) {
            this.welcomePrinted = true;
            if (TLCGlobals.getRevision() == null) {
                MP.printMessage(2262, TLCGlobals.versionOfTLC);
            } else {
                MP.printMessage(2262, TLCGlobals.versionOfTLC + " (rev: " + TLCGlobals.getRevision() + ")");
            }
        }
    }

    private void printUsage() {
        this.printWelcome();
        MP.printMessage(2263);
    }

    FPSetConfiguration getFPSetConfiguration() {
        return this.fpSetConfiguration;
    }

    public String getModelName() {
        return System.getProperty("modelName", this.mainFile);
    }

    public String getSpecName() {
        return System.getProperty("specName", this.mainFile);
    }
}

