/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.parser;

import tla2sany.parser.Token;
import tla2sany.semantic.ASTConstants;
import tla2sany.st.Location;
import tla2sany.st.SyntaxTreeConstants;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import util.UniqueString;

public class SyntaxTreeNode
implements TreeNode,
SyntaxTreeConstants,
ASTConstants {
    private static SyntaxTreeNode[] nullArray = new SyntaxTreeNode[0];
    protected SyntaxTreeNode[] zero;
    protected SyntaxTreeNode[] one;
    int kind = 0;
    public UniqueString image = null;
    public UniqueString originalImage = null;
    int[] location = new int[4];
    private UniqueString fileName = null;
    private static final String[] ns = new String[0];
    private String[] preComment = ns;
    public static SyntaxTreeNode nullSTN = new SyntaxTreeNode(UniqueString.uniqueStringOf("***I do not exist***"));
    private static Token nullToken = new Token();

    public SyntaxTreeNode() {
        this.zero = nullArray;
        this.one = nullArray;
    }

    public SyntaxTreeNode(UniqueString fn) {
        this.kind = 0;
        this.image = fn;
        this.zero = nullArray;
        this.one = nullArray;
        this.location[0] = 0;
        this.location[1] = 0;
        this.location[2] = 0;
        this.location[3] = 0;
        this.fileName = UniqueString.uniqueStringOf("--TLA+ BUILTINS--");
    }

    public SyntaxTreeNode(UniqueString fn, Token t) {
        this.kind = t.kind;
        this.image = UniqueString.uniqueStringOf(t.image);
        this.zero = nullArray;
        this.one = nullArray;
        this.location[0] = t.beginLine;
        this.location[1] = t.beginColumn;
        this.location[2] = t.endLine;
        this.location[3] = t.endColumn;
        this.fileName = fn;
        this.preComment = this.comments(t);
    }

    public SyntaxTreeNode(UniqueString fn, int kind, Token t) {
        this.kind = kind;
        this.image = UniqueString.uniqueStringOf(t.image);
        this.zero = nullArray;
        this.one = nullArray;
        this.location[0] = t.beginLine;
        this.location[1] = t.beginColumn;
        this.location[2] = t.endLine;
        this.location[3] = t.endColumn;
        this.fileName = fn;
        this.preComment = this.comments(t);
    }

    public SyntaxTreeNode(UniqueString fn, int kind, SyntaxTreeNode[] a) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.zero = a;
        this.fileName = fn;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode[] a) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.zero = a;
        this.fileName = a[0].fileName;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode[] a, boolean ignored) {
        this.kind = kind;
        this.zero = a;
    }

    public SyntaxTreeNode(UniqueString fn, int kind, SyntaxTreeNode a, SyntaxTreeNode[] b) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        if (a != null) {
            this.zero = new SyntaxTreeNode[1];
            this.zero[0] = a;
        }
        this.one = b;
        this.fileName = fn;
        this.updateLocation();
    }

    public SyntaxTreeNode(UniqueString fn, int kind, SyntaxTreeNode[] a, SyntaxTreeNode[] b) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.zero = a;
        this.one = b;
        this.fileName = fn;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode a, SyntaxTreeNode b) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.fileName = a.fileName;
        this.zero = new SyntaxTreeNode[2];
        this.zero[0] = a;
        this.zero[1] = b;
        this.updateLocation();
    }

    public SyntaxTreeNode(int kind, SyntaxTreeNode a, SyntaxTreeNode b, SyntaxTreeNode c) {
        this.kind = kind;
        this.image = SyntaxNodeImage[kind];
        this.fileName = a.fileName;
        this.zero = new SyntaxTreeNode[3];
        this.zero[0] = a;
        this.zero[1] = b;
        this.zero[2] = c;
        this.updateLocation();
    }

    @Override
    public final int getKind() {
        return this.kind;
    }

    final void setKind(int k) {
        this.kind = k;
    }

    @Override
    public final boolean isKind(int k) {
        return this.kind == k;
    }

    @Override
    public final String[] getPreComments() {
        return this.preComment;
    }

    public final String[] getAttachedComments() {
        if (this.kind < 327) {
            return this.preComment;
        }
        if (this.heirs().length == 0) {
            String[] res = new String[]{};
            return res;
        }
        return ((SyntaxTreeNode)this.heirs()[0]).getAttachedComments();
    }

    public boolean isGenOp() {
        return this.kind == 362 || this.kind == 360 || this.kind == 359 || this.kind == 361;
    }

    private final String[] comments(Token t) {
        Token nextPre = nullToken;
        int cPre = 0;
        if (t.specialToken == null) {
            return ns;
        }
        Token tmp_t = t.specialToken;
        while (tmp_t != null) {
            ++cPre;
            tmp_t.next = nextPre;
            nextPre = tmp_t;
            tmp_t = tmp_t.specialToken;
        }
        String[] aPre = new String[cPre];
        tmp_t = nextPre;
        cPre = 0;
        while (tmp_t != nullToken) {
            aPre[cPre] = tmp_t.image;
            ++cPre;
            tmp_t = tmp_t.next;
        }
        return aPre;
    }

    public final SyntaxTreeNode[] getHeirs() {
        SyntaxTreeNode[] result;
        if (this.zero == null && this.one == null) {
            return nullArray;
        }
        if (this.zero != null) {
            if (this.one != null) {
                result = new SyntaxTreeNode[this.zero.length + this.one.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
                System.arraycopy(this.one, 0, result, this.zero.length, this.one.length);
            } else {
                result = new SyntaxTreeNode[this.zero.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
            }
        } else {
            result = new SyntaxTreeNode[this.one.length];
            System.arraycopy(this.one, 0, result, 0, this.one.length);
        }
        return result;
    }

    @Override
    public final TreeNode[] heirs() {
        TreeNode[] result;
        if (this.zero == null && this.one == null) {
            return nullArray;
        }
        if (this.zero != null) {
            if (this.one != null) {
                result = new SyntaxTreeNode[this.zero.length + this.one.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
                System.arraycopy(this.one, 0, result, this.zero.length, this.one.length);
            } else {
                result = new SyntaxTreeNode[this.zero.length];
                System.arraycopy(this.zero, 0, result, 0, this.zero.length);
            }
        } else {
            result = new SyntaxTreeNode[this.one.length];
            System.arraycopy(this.one, 0, result, 0, this.one.length);
        }
        return result;
    }

    @Override
    public final String getFilename() {
        return this.fileName.toString();
    }

    public final UniqueString getFN() {
        return this.fileName;
    }

    @Override
    public final Location getLocation() {
        return new Location(this.fileName, this.location[0], this.location[1], this.location[2], this.location[3]);
    }

    @Override
    public final String getImage() {
        return this.image.toString();
    }

    @Override
    public final UniqueString getUS() {
        return this.image;
    }

    public final SyntaxTreeNode first() {
        if (this.zero != null) {
            return this.zero[0];
        }
        return this.one[0];
    }

    public String getHumanReadableImage() {
        if (this.zero != null && this.zero.length > 0) {
            StringBuffer buf = new StringBuffer(this.zero.length);
            for (SyntaxTreeNode z : this.zero) {
                buf.append(z.getHumanReadableImage());
            }
            if (this.one != null && this.one.length > 0) {
                for (SyntaxTreeNode o : this.one) {
                    buf.append(o.getHumanReadableImage());
                }
            }
            return buf.toString();
        }
        String string = this.image.toString();
        if (string.startsWith("N_")) {
            return "";
        }
        if (string.startsWith("Not a node")) {
            return "";
        }
        if (string.startsWith("Token")) {
            return "";
        }
        return string;
    }

    private void updateLocation() {
        int lvi = 0;
        this.location[0] = Integer.MAX_VALUE;
        this.location[1] = Integer.MAX_VALUE;
        this.location[2] = Integer.MIN_VALUE;
        this.location[3] = Integer.MIN_VALUE;
        if (this.zero != null) {
            for (lvi = 0; lvi < this.zero.length; ++lvi) {
                if (this.zero[lvi].location[0] < this.location[0] || this.zero[lvi].location[0] == this.location[0] && this.zero[lvi].location[1] < this.location[1]) {
                    this.location[0] = this.zero[lvi].location[0];
                    this.location[1] = this.zero[lvi].location[1];
                }
                if (this.zero[lvi].location[2] <= this.location[2] && (this.zero[lvi].location[2] != this.location[2] || this.zero[lvi].location[3] <= this.location[3])) continue;
                this.location[2] = this.zero[lvi].location[2];
                this.location[3] = this.zero[lvi].location[3];
            }
        }
        if (this.one != null) {
            for (lvi = 0; lvi < this.one.length; ++lvi) {
                if (this.one[lvi].location[0] < this.location[0] || this.one[lvi].location[0] == this.location[0] && this.one[lvi].location[1] < this.location[1]) {
                    this.location[0] = this.one[lvi].location[0];
                    this.location[1] = this.one[lvi].location[1];
                }
                if (this.one[lvi].location[2] <= this.location[2] && (this.one[lvi].location[2] != this.location[2] || this.one[lvi].location[3] <= this.location[3])) continue;
                this.location[2] = this.one[lvi].location[2];
                this.location[3] = this.one[lvi].location[3];
            }
        }
    }

    @Override
    public final TreeNode[] one() {
        return this.one;
    }

    @Override
    public final TreeNode[] zero() {
        return this.zero;
    }

    @Override
    public final boolean local() {
        return this.zero != null;
    }

    @Override
    public void printST(int indentLevel) {
        int i;
        String operator = "";
        TreeNode[] heirs = this.heirs();
        if (this.image != null && this.image.toString().equals("N_OperatorDefinition")) {
            if (((SyntaxTreeNode)this.heirs()[0]).image.toString().equals("N_IdentLHS")) {
                operator = "*" + ((SyntaxTreeNode)((SyntaxTreeNode)this.heirs()[0]).heirs()[0]).image.toString();
            }
            if (((SyntaxTreeNode)this.heirs()[1]).image.toString().equals("N_IdentLHS")) {
                operator = ((SyntaxTreeNode)((SyntaxTreeNode)this.heirs()[1]).heirs()[0]).image.toString();
            }
            if (((SyntaxTreeNode)this.heirs()[0]).image.toString().equals("N_InfixLHS")) {
                operator = ((SyntaxTreeNode)((SyntaxTreeNode)this.heirs()[0]).heirs()[1]).image.toString();
            }
        }
        for (i = 0; i < indentLevel; ++i) {
            System.out.print(Strings.blanks[2]);
        }
        System.out.print((this.image == null ? "(" + SyntaxNodeImage[this.kind].toString() + ")" : this.image.toString()) + "\t" + (!operator.equals("") ? operator + "\t" : "") + "  #heirs: " + heirs.length + "\t  kind:   " + this.kind + SyntaxTreeNode.PreCommentToString(this.preComment) + "\n");
        for (i = 0; i < heirs.length; ++i) {
            if (heirs[i] != null) {
                ((SyntaxTreeNode)heirs[i]).printST(indentLevel + 1);
                continue;
            }
            for (int j = 0; j <= indentLevel; ++j) {
                System.out.print(Strings.blanks[2]);
            }
            System.out.println("<null>");
        }
    }

    public static String PreCommentToString(String[] pcarray) {
        if (pcarray == null || pcarray.length == 0) {
            return "";
        }
        String res = "\n preComment: ";
        for (int i = 0; i < pcarray.length; ++i) {
            res = res + (i == 0 ? "" : "\n             ") + i + " " + pcarray[i];
        }
        return res;
    }
}

