/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.AST;
import pcal.PcalDebug;
import pcal.PcalSymTab;
import pcal.TLAExpr;
import pcal.TLAToken;
import pcal.exception.PcalFixIDException;
import pcal.exception.TLAExprException;

public class PcalFixIDs {
    private static PcalSymTab st = null;

    public static void Fix(AST ast, PcalSymTab stab) throws PcalFixIDException {
        st = stab;
        PcalFixIDs.FixSym(ast, "");
        if (PcalFixIDs.st.iPC != null) {
            PcalFixIDs.st.iPC = st.UseThis(1, PcalFixIDs.st.iPC, "");
        }
    }

    private static void FixSym(AST ast, String context) throws PcalFixIDException {
        if (ast.getClass().equals(AST.UniprocessObj.getClass())) {
            PcalFixIDs.FixUniprocess((AST.Uniprocess)ast, context);
        } else if (ast.getClass().equals(AST.MultiprocessObj.getClass())) {
            PcalFixIDs.FixMultiprocess((AST.Multiprocess)ast, context);
        } else if (ast.getClass().equals(AST.ProcedureObj.getClass())) {
            PcalFixIDs.FixProcedure((AST.Procedure)ast, context);
        } else if (ast.getClass().equals(AST.ProcessObj.getClass())) {
            PcalFixIDs.FixProcess((AST.Process)ast, context);
        } else if (ast.getClass().equals(AST.LabeledStmtObj.getClass())) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast, context);
        } else if (ast.getClass().equals(AST.WhileObj.getClass())) {
            PcalFixIDs.FixWhile((AST.While)ast, context);
        } else if (ast.getClass().equals(AST.AssignObj.getClass())) {
            PcalFixIDs.FixAssign((AST.Assign)ast, context);
        } else if (ast.getClass().equals(AST.SingleAssignObj.getClass())) {
            PcalFixIDs.FixSingleAssign((AST.SingleAssign)ast, context);
        } else if (ast.getClass().equals(AST.LhsObj.getClass())) {
            PcalFixIDs.FixLhs((AST.Lhs)ast, context);
        } else if (ast.getClass().equals(AST.IfObj.getClass())) {
            PcalFixIDs.FixIf((AST.If)ast, context);
        } else if (ast.getClass().equals(AST.WithObj.getClass())) {
            PcalFixIDs.FixWith((AST.With)ast, context);
        } else if (ast.getClass().equals(AST.WhenObj.getClass())) {
            PcalFixIDs.FixWhen((AST.When)ast, context);
        } else if (ast.getClass().equals(AST.PrintSObj.getClass())) {
            PcalFixIDs.FixPrintS((AST.PrintS)ast, context);
        } else if (ast.getClass().equals(AST.AssertObj.getClass())) {
            PcalFixIDs.FixAssert((AST.Assert)ast, context);
        } else if (ast.getClass().equals(AST.SkipObj.getClass())) {
            PcalFixIDs.FixSkip((AST.Skip)ast, context);
        } else if (ast.getClass().equals(AST.LabelIfObj.getClass())) {
            PcalFixIDs.FixLabelIf((AST.LabelIf)ast, context);
        } else if (ast.getClass().equals(AST.CallObj.getClass())) {
            PcalFixIDs.FixCall((AST.Call)ast, context);
        } else if (ast.getClass().equals(AST.ReturnObj.getClass())) {
            PcalFixIDs.FixReturn((AST.Return)ast, context);
        } else if (ast.getClass().equals(AST.CallReturnObj.getClass())) {
            PcalFixIDs.FixCallReturn((AST.CallReturn)ast, context);
        } else if (ast.getClass().equals(AST.GotoObj.getClass())) {
            PcalFixIDs.FixGoto((AST.Goto)ast, context);
        } else if (ast.getClass().equals(AST.EitherObj.getClass())) {
            PcalFixIDs.FixEither((AST.Either)ast, context);
        } else if (ast.getClass().equals(AST.LabelEitherObj.getClass())) {
            PcalFixIDs.FixLabelEither((AST.LabelEither)ast, context);
        } else {
            PcalDebug.ReportBug("Unexpected AST type" + ast.toString());
        }
    }

    private static void FixUniprocess(AST.Uniprocess ast, String context) throws PcalFixIDException {
        int i;
        for (i = 0; i < ast.decls.size(); ++i) {
            PcalFixIDs.FixVarDecl((AST.VarDecl)ast.decls.elementAt(i), "");
        }
        for (i = 0; i < ast.prcds.size(); ++i) {
            PcalFixIDs.FixProcedure((AST.Procedure)ast.prcds.elementAt(i), "");
        }
        for (i = 0; i < ast.body.size(); ++i) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i), "");
        }
    }

    private static void FixMultiprocess(AST.Multiprocess ast, String context) throws PcalFixIDException {
        int j;
        int i;
        for (int i2 = 0; i2 < ast.decls.size(); ++i2) {
            PcalFixIDs.FixVarDecl((AST.VarDecl)ast.decls.elementAt(i2), "");
        }
        Vector<String> procedureNames = new Vector<String>();
        Vector<Vector> proceduresCalled = new Vector<Vector>();
        for (int i3 = 0; i3 < ast.prcds.size(); ++i3) {
            AST.Procedure prcd = (AST.Procedure)ast.prcds.elementAt(i3);
            PcalFixIDs.FixProcedure(prcd, "");
            procedureNames.addElement(prcd.name);
            proceduresCalled.addElement(prcd.proceduresCalled);
        }
        int n = procedureNames.size();
        boolean[][] path = new boolean[n][];
        for (i = 0; i < n; ++i) {
            path[i] = new boolean[n];
            for (int j2 = 0; j2 < n; ++j2) {
                String nm = (String)procedureNames.elementAt(j2);
                path[i][j2] = -1 != PcalFixIDs.nameToNum(nm, (Vector)proceduresCalled.elementAt(i));
            }
        }
        for (int k = 0; k < n; ++k) {
            for (int i4 = 0; i4 < n; ++i4) {
                for (int j3 = 0; j3 < n; ++j3) {
                    path[i4][j3] = path[i4][j3] || path[i4][k] && path[k][j3];
                }
            }
        }
        for (i = 0; i < ast.prcds.size(); ++i) {
            AST.Procedure prcd = (AST.Procedure)ast.prcds.elementAt(i);
            Vector pCalled = new Vector();
            for (j = 0; j < n; ++j) {
                if (!path[i][j]) continue;
                pCalled.addElement(procedureNames.elementAt(j));
            }
            prcd.proceduresCalled = pCalled;
        }
        for (i = 0; i < ast.procs.size(); ++i) {
            AST.Process proc = (AST.Process)ast.procs.elementAt(i);
            PcalFixIDs.FixProcess(proc, "");
            Vector pCalled = proc.proceduresCalled;
            for (j = 0; j < pCalled.size(); ++j) {
                String pName = (String)pCalled.elementAt(j);
                int pNum = PcalFixIDs.nameToNum(pName, procedureNames);
                if (pNum == -1) {
                    PcalDebug.reportError("Could not find procedure name `" + pName + "'");
                    return;
                }
                for (int k = 0; k < n; ++k) {
                    String callee;
                    if (!path[pNum][k] || PcalFixIDs.InVector(callee = (String)procedureNames.elementAt(k), proc.proceduresCalled)) continue;
                    proc.proceduresCalled.addElement(callee);
                }
            }
        }
    }

    private static int nameToNum(String nm, Vector names) {
        for (int i = 0; i < names.size(); ++i) {
            if (!names.elementAt(i).equals(nm)) continue;
            return i;
        }
        return -1;
    }

    private static void FixProcedure(AST.Procedure ast, String context) throws PcalFixIDException {
        String newLbl;
        String lbl;
        int i;
        int i2;
        for (i2 = 0; i2 < ast.decls.size(); ++i2) {
            PcalFixIDs.FixPVarDecl((AST.PVarDecl)ast.decls.elementAt(i2), ast.name);
        }
        for (i2 = 0; i2 < ast.params.size(); ++i2) {
            PcalFixIDs.FixPVarDecl((AST.PVarDecl)ast.params.elementAt(i2), ast.name);
        }
        for (i2 = 0; i2 < ast.body.size(); ++i2) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i2), ast.name);
        }
        PcalSymTab.ProcedureEntry p = (PcalSymTab.ProcedureEntry)PcalFixIDs.st.procs.elementAt(st.FindProc(ast.name));
        for (i = 0; i < ast.plusLabels.size(); ++i) {
            lbl = (String)ast.plusLabels.elementAt(i);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.plusLabels.setElementAt(newLbl, i);
        }
        for (i = 0; i < ast.minusLabels.size(); ++i) {
            lbl = (String)ast.minusLabels.elementAt(i);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.minusLabels.setElementAt(newLbl, i);
        }
        p.iPC = st.UseThis(1, p.iPC, ast.name);
        p.name = ast.name = st.UseThis(2, ast.name, "");
    }

    private static void FixProcess(AST.Process ast, String context) throws PcalFixIDException {
        String newLbl;
        String lbl;
        int i;
        int i2;
        for (i2 = 0; i2 < ast.decls.size(); ++i2) {
            PcalFixIDs.FixVarDecl((AST.VarDecl)ast.decls.elementAt(i2), ast.name);
        }
        for (i2 = 0; i2 < ast.body.size(); ++i2) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.body.elementAt(i2), ast.name);
        }
        PcalSymTab.ProcessEntry p = (PcalSymTab.ProcessEntry)PcalFixIDs.st.processes.elementAt(st.FindProcess(ast.name));
        for (i = 0; i < ast.plusLabels.size(); ++i) {
            lbl = (String)ast.plusLabels.elementAt(i);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.plusLabels.setElementAt(newLbl, i);
        }
        for (i = 0; i < ast.minusLabels.size(); ++i) {
            lbl = (String)ast.minusLabels.elementAt(i);
            newLbl = st.UseThis(1, lbl, ast.name);
            ast.minusLabels.setElementAt(newLbl, i);
        }
        p.iPC = st.UseThis(1, p.iPC, ast.name);
        p.name = ast.name = st.UseThis(3, ast.name, "");
    }

    private static void FixVarDecl(AST.VarDecl ast, String context) throws PcalFixIDException {
        ast.var = st.UseThisVar(ast.var, context);
        PcalFixIDs.FixExpr(ast.val, context);
    }

    private static void FixPVarDecl(AST.PVarDecl ast, String context) throws PcalFixIDException {
        ast.var = st.UseThisVar(ast.var, context);
        PcalFixIDs.FixExpr(ast.val, context);
    }

    private static void FixLabeledStmt(AST.LabeledStmt ast, String context) throws PcalFixIDException {
        ast.label = st.UseThis(1, ast.label, context);
        for (int i = 0; i < ast.stmts.size(); ++i) {
            PcalFixIDs.FixSym((AST)ast.stmts.elementAt(i), context);
        }
    }

    private static void FixWhile(AST.While ast, String context) throws PcalFixIDException {
        int i;
        for (i = 0; i < ast.unlabDo.size(); ++i) {
            PcalFixIDs.FixSym((AST)ast.unlabDo.elementAt(i), context);
        }
        for (i = 0; i < ast.labDo.size(); ++i) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.labDo.elementAt(i), context);
        }
        PcalFixIDs.FixExpr(ast.test, context);
    }

    private static void FixAssign(AST.Assign ast, String context) throws PcalFixIDException {
        for (int i = 0; i < ast.ass.size(); ++i) {
            PcalFixIDs.FixSingleAssign((AST.SingleAssign)ast.ass.elementAt(i), context);
        }
    }

    private static void FixSingleAssign(AST.SingleAssign ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixLhs(ast.lhs, context);
        PcalFixIDs.FixExpr(ast.rhs, context);
    }

    private static void FixLhs(AST.Lhs ast, String context) throws PcalFixIDException {
        ast.var = st.UseThisVar(ast.var, context);
        PcalFixIDs.FixExpr(ast.sub, context);
    }

    private static void FixIf(AST.If ast, String context) throws PcalFixIDException {
        int i;
        for (i = 0; i < ast.Then.size(); ++i) {
            PcalFixIDs.FixSym((AST)ast.Then.elementAt(i), context);
        }
        for (i = 0; i < ast.Else.size(); ++i) {
            PcalFixIDs.FixSym((AST)ast.Else.elementAt(i), context);
        }
        PcalFixIDs.FixExpr(ast.test, context);
    }

    private static void FixWith(AST.With ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
        for (int i = 0; i < ast.Do.size(); ++i) {
            PcalFixIDs.FixSym((AST)ast.Do.elementAt(i), context);
        }
    }

    private static void FixWhen(AST.When ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
    }

    private static void FixPrintS(AST.PrintS ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
    }

    private static void FixAssert(AST.Assert ast, String context) throws PcalFixIDException {
        PcalFixIDs.FixExpr(ast.exp, context);
    }

    private static void FixSkip(AST.Skip ast, String context) {
    }

    private static void FixLabelIf(AST.LabelIf ast, String context) throws PcalFixIDException {
        int i;
        PcalFixIDs.FixExpr(ast.test, context);
        for (i = 0; i < ast.unlabThen.size(); ++i) {
            PcalFixIDs.FixSym((AST)ast.unlabThen.elementAt(i), context);
        }
        for (i = 0; i < ast.labThen.size(); ++i) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.labThen.elementAt(i), context);
        }
        for (i = 0; i < ast.unlabElse.size(); ++i) {
            PcalFixIDs.FixSym((AST)ast.unlabElse.elementAt(i), context);
        }
        for (i = 0; i < ast.labElse.size(); ++i) {
            PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)ast.labElse.elementAt(i), context);
        }
    }

    private static void FixCall(AST.Call ast, String context) throws PcalFixIDException {
        ast.returnTo = st.UseThis(2, ast.returnTo, context);
        ast.to = st.UseThis(2, ast.to, context);
        for (int i = 0; i < ast.args.size(); ++i) {
            PcalFixIDs.FixExpr((TLAExpr)ast.args.elementAt(i), context);
        }
    }

    private static void FixReturn(AST.Return ast, String context) {
        ast.from = st.UseThis(2, ast.from, context);
    }

    private static void FixCallReturn(AST.CallReturn ast, String context) throws PcalFixIDException {
        ast.from = st.UseThis(2, ast.from, context);
        ast.to = st.UseThis(2, ast.to, context);
        for (int i = 0; i < ast.args.size(); ++i) {
            PcalFixIDs.FixExpr((TLAExpr)ast.args.elementAt(i), context);
        }
    }

    private static void FixGoto(AST.Goto ast, String context) throws PcalFixIDException {
        if (st.FindSym(1, ast.to, context) == PcalFixIDs.st.symtab.size() && !ast.to.equals("Done")) {
            throw new PcalFixIDException("goto to non-existent label `" + ast.to + "' at line " + ast.line + ", column " + ast.col);
        }
        ast.to = st.UseThis(1, ast.to, context);
    }

    private static void FixEither(AST.Either ast, String context) throws PcalFixIDException {
        for (int i = 0; i < ast.ors.size(); ++i) {
            Vector orClause = (Vector)ast.ors.elementAt(i);
            for (int j = 0; j < orClause.size(); ++j) {
                PcalFixIDs.FixSym((AST)orClause.elementAt(j), context);
            }
        }
    }

    private static void FixLabelEither(AST.LabelEither ast, String context) throws PcalFixIDException {
        for (int i = 0; i < ast.clauses.size(); ++i) {
            int j;
            AST.Clause orClause = (AST.Clause)ast.clauses.elementAt(i);
            for (j = 0; j < orClause.unlabOr.size(); ++j) {
                PcalFixIDs.FixSym((AST)orClause.unlabOr.elementAt(j), context);
            }
            for (j = 0; j < orClause.labOr.size(); ++j) {
                PcalFixIDs.FixLabeledStmt((AST.LabeledStmt)orClause.labOr.elementAt(j), context);
            }
        }
    }

    private static void FixExpr(TLAExpr expr, String context) throws PcalFixIDException {
        Vector<TLAExpr> exprVec = new Vector<TLAExpr>();
        Vector<String> stringVec = new Vector<String>();
        Vector tokenVec = new Vector();
        for (int i = 0; i < expr.tokens.size(); ++i) {
            Vector tv = (Vector)expr.tokens.elementAt(i);
            String useMe = null;
            for (int j = 0; j < tv.size(); ++j) {
                int shift = 0;
                TLAToken tok = (TLAToken)tv.elementAt(j);
                tok.column += shift;
                if (tok.type != 4) continue;
                useMe = st.UseThisVar(tok.string, context);
                if (PcalFixIDs.InVector(tok.string, stringVec) || useMe.equals(tok.string)) continue;
                stringVec.addElement(tok.string);
                TLAExpr exp = new TLAExpr();
                exp.addLine();
                exp.addToken(new TLAToken(useMe, 0, 4));
                exp.normalize();
                exprVec.addElement(exp);
            }
        }
        if (exprVec.size() > 0) {
            try {
                expr.substituteForAll(exprVec, stringVec, false);
            }
            catch (TLAExprException e) {
                throw new PcalFixIDException(e.getMessage());
            }
        }
    }

    private static boolean InVector(String var, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            if (!var.equals((String)v.elementAt(i))) continue;
            return true;
        }
        return false;
    }
}

