/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchi.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import plug.core.IAtomicPropositionsProvider;
import plug.core.IBuchiConfiguration;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.language.buchi.runtime.BuchiConfiguration;
import plug.statespace.transitions.FiredTransition;
import properties.BuchiAutomata.BuchiAutomataModel.Automaton;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;

public class BuchiRuntime
implements ITransitionRelation<IBuchiConfiguration, GuardedTransition>,
IAtomicPropositionsProvider {
    private final BuchiDeclaration buchiAutomaton;

    public BuchiRuntime(BuchiDeclaration buchiAutomaton) {
        this.buchiAutomaton = buchiAutomaton;
    }

    Automaton getAutomaton() {
        return (Automaton)this.buchiAutomaton.getAutomaton();
    }

    public Set<IBuchiConfiguration> initialConfigurations() {
        return Collections.singleton(new BuchiConfiguration(this.getAutomaton().getInitial()));
    }

    public Collection<GuardedTransition> fireableTransitionsFrom(IBuchiConfiguration source) {
        return this.getAutomaton().getTransitions().stream().filter(t -> t.getFrom() == ((BuchiConfiguration)source).buchiState).collect(Collectors.toList());
    }

    public IFiredTransition<IBuchiConfiguration, ?> fireOneTransition(IBuchiConfiguration source, GuardedTransition transition) {
        return new FiredTransition((Object)source, (Object)new BuchiConfiguration(transition.getTo()), (Object)transition);
    }

    public Collection<String> getAtomicPropositions() {
        ArrayList<String> atoms = new ArrayList<String>();
        for (ExpressionDeclaration decl : this.buchiAutomaton.getDeclarations()) {
            String code = ((Atom)decl.getExpression()).getCode();
            atoms.add(code);
        }
        return atoms;
    }
}

