/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchikripke.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.buchikripke.runtime.KripkeBuchiConfiguration;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;

public class KripkeBuchiRuntimeView
implements IRuntimeView<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> {
    protected final KripkeBuchiProductSemantics runtime;
    protected final IRuntimeView childRuntimeView;

    public KripkeBuchiRuntimeView(KripkeBuchiProductSemantics runtime) {
        this.runtime = runtime;
        this.childRuntimeView = runtime.getKripke().getModule().getRuntimeView(runtime.getKripkeRuntime());
    }

    public KripkeBuchiProductSemantics getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(KripkeBuchiConfiguration value) {
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        ConfigurationItem buchiState = new ConfigurationItem("state", value.buchiState.toString(), null, null);
        ConfigurationItem buchiProcess = new ConfigurationItem("process", "bucchi", null, Collections.singletonList(buchiState));
        buchiProcess.setExpanded(true);
        children.add(buchiProcess);
        if (value.kripke != null) {
            String description = this.childRuntimeView.getConfigurationDescription((Object)value.kripke);
            List kripkeChildren = this.childRuntimeView.getConfigurationItems((Object)value.kripke);
            ConfigurationItem kripkeProcess = new ConfigurationItem("process", description, null, kripkeChildren);
            kripkeProcess.setExpanded(true);
            children.add(kripkeProcess);
        } else {
            children.add(new ConfigurationItem("process", "<not present>", null, null));
        }
        return children;
    }

    public String getFireableTransitionDescription(Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition> transition) {
        Object action = ((IFiredTransition)transition.a).getAction();
        if (action instanceof KripkeBuchiProductSemantics.StutteringTransition) {
            return "Buchi stuttering";
        }
        if (action == null) {
            return "Buchi initial transition";
        }
        return this.childRuntimeView.getActionDescription(action);
    }

    public String getActionDescription(Object action) {
        if (action instanceof Pair) {
            Pair transition = (Pair)action;
            Object childAction = ((IFiredTransition)transition.a).getAction();
            if (childAction instanceof KripkeBuchiProductSemantics.StutteringTransition) {
                return "Buchi stuttering";
            }
            if (childAction == null) {
                return "Buchi initial transition";
            }
            return this.childRuntimeView.getActionDescription(childAction);
        }
        return Objects.toString(action);
    }
}

