/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchikripke.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import plug.core.IAtomicPropositionsEvaluator;
import plug.core.IBuchiConfiguration;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.core.RuntimeDescription;
import plug.language.buchi.runtime.BuchiRuntime;
import plug.language.buchikripke.runtime.KripkeBuchiAtomicPropositionsEvaluator;
import plug.language.buchikripke.runtime.KripkeBuchiConfiguration;
import plug.statespace.transitions.FiredTransition;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.PropositionalLogic.interpreter.Evaluator;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.interpreter.atom.AtomArrayValuationEvaluator;

public class KripkeBuchiProductSemantics
implements ITransitionRelation<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> {
    protected final RuntimeDescription kripke;
    protected final RuntimeDescription buchi;
    protected ITransitionRelation kripkeRuntime;
    protected BuchiRuntime buchiRuntime;
    protected KripkeBuchiAtomicPropositionsEvaluator atomicPropositionsEvaluator = null;
    protected final Evaluator evaluator = new Evaluator();
    protected final AtomArrayValuationEvaluator apValuationEvaluator;

    public KripkeBuchiProductSemantics(RuntimeDescription kripke, RuntimeDescription buchi) throws Exception {
        this.kripke = kripke;
        this.buchi = buchi;
        ITransitionRelation runtime = buchi.getRuntime();
        this.buchiRuntime = runtime instanceof BuchiRuntime ? (BuchiRuntime)runtime : null;
        this.kripkeRuntime = kripke.getRuntime();
        ArrayList<String> atoms = new ArrayList<String>();
        HashMap<String, Integer> atomMap = new HashMap<String, Integer>();
        int idx = 0;
        for (String atom : this.getBuchiRuntime().getAtomicPropositions()) {
            atoms.add(atom);
            atomMap.put(atom, idx++);
        }
        IAtomicPropositionsEvaluator kripkeEvaluator = this.getKripkeRuntime().getAtomicPropositionEvaluator();
        kripkeEvaluator.registerAtomicPropositions(atoms.toArray(new String[0]));
        this.apValuationEvaluator = new AtomArrayValuationEvaluator(atomMap);
        this.evaluator.setDefaultEvaluator((IAtomEvaluator)this.apValuationEvaluator);
    }

    public KripkeBuchiProductSemantics(RuntimeDescription kripke, BuchiRuntime buchiRuntime) throws Exception {
        this(kripke, new RuntimeDescription(null, () -> buchiRuntime));
    }

    public RuntimeDescription getKripke() {
        return this.kripke;
    }

    protected ITransitionRelation getKripkeRuntime() {
        return this.kripkeRuntime;
    }

    protected BuchiRuntime getBuchiRuntime() {
        return this.buchiRuntime;
    }

    public Set<KripkeBuchiConfiguration> initialConfigurations() {
        Set buchiInitialSet = this.getBuchiRuntime().initialConfigurations();
        HashSet<KripkeBuchiConfiguration> result = new HashSet<KripkeBuchiConfiguration>();
        for (IBuchiConfiguration b : buchiInitialSet) {
            KripkeBuchiConfiguration kbc = new KripkeBuchiConfiguration();
            kbc.kripke = null;
            kbc.buchiState = b;
            result.add(kbc);
        }
        return result;
    }

    public Collection<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> fireableTransitionsFrom(KripkeBuchiConfiguration source) {
        ArrayList<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> fireables = new ArrayList<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>>();
        if (source.kripke == null) {
            this.getKripkeBuchiSynchronousTransitions(source, this.getKripkeRuntime().initialConfigurations(), null, fireables);
            return fireables;
        }
        Collection fireableTransitions = this.getKripkeRuntime().fireableTransitionsFrom((Object)source.kripke);
        int numberOfFireableTransitions = fireableTransitions.size();
        for (Object kripkeFireable : fireableTransitions) {
            IFiredTransition kripkeTransition = this.getKripkeRuntime().fireOneTransition((Object)source.kripke, kripkeFireable);
            if (kripkeTransition == null && this.getKripkeRuntime().hasBlockingTransitions()) {
                --numberOfFireableTransitions;
                continue;
            }
            this.getKripkeBuchiSynchronousTransitions(source, kripkeTransition.getTargets(), kripkeTransition.getAction(), fireables);
        }
        if (numberOfFireableTransitions == 0) {
            this.getKripkeBuchiSynchronousTransitions(source, Collections.singleton(source.kripke), StutteringTransition.instance, fireables);
        }
        return fireables;
    }

    public IAtomicPropositionsEvaluator<KripkeBuchiConfiguration, Object> getAtomicPropositionEvaluator() {
        if (this.atomicPropositionsEvaluator == null) {
            this.atomicPropositionsEvaluator = new KripkeBuchiAtomicPropositionsEvaluator(this.getKripkeRuntime().getAtomicPropositionEvaluator());
        }
        return this.atomicPropositionsEvaluator;
    }

    public IFiredTransition<KripkeBuchiConfiguration, ?> fireOneTransition(KripkeBuchiConfiguration source, Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition> transition) {
        KripkeBuchiConfiguration myNewState = source.createCopy();
        myNewState.kripke = (IConfiguration)((IFiredTransition)transition.a).getTargets().iterator().next();
        IFiredTransition buchiTransition = this.getBuchiRuntime().fireOneTransition(source.buchiState, (GuardedTransition)transition.b);
        myNewState.buchiState = (IBuchiConfiguration)buchiTransition.getTarget(0);
        return new FiredTransition((Object)source, (Object)myNewState, transition);
    }

    public void close() {
        this.getKripkeRuntime().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getKripkeBuchiSynchronousTransitions(KripkeBuchiConfiguration source, Collection<IConfiguration> kripkeTargets, Object kripkeFireable, Collection<Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> outFireables) {
        IAtomicPropositionsEvaluator kripkeEvaluator = this.getKripkeRuntime().getAtomicPropositionEvaluator();
        for (IConfiguration target : kripkeTargets) {
            AtomArrayValuationEvaluator atomArrayValuationEvaluator = this.apValuationEvaluator;
            synchronized (atomArrayValuationEvaluator) {
                this.apValuationEvaluator.setValuation(kripkeEvaluator.getAtomicPropositionValuations(target));
                Collection buchiTransitions = this.getBuchiRuntime().fireableTransitionsFrom(source.buchiState);
                for (GuardedTransition transition : buchiTransitions) {
                    if (!this.evaluator.evaluate(transition.getGuard())) continue;
                    outFireables.add((Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>)new Pair((Object)new FiredTransition((Object)source.kripke, (Object)target, kripkeFireable), (Object)transition));
                }
            }
        }
    }

    public static class StutteringTransition {
        static StutteringTransition instance = new StutteringTransition();
    }
}

