/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.cdl.diagram;

import java.util.List;
import obp.cdl.EventReference;
import obp.ui.cdl.diagram.ActivityElement;
import obp.ui.cdl.diagram.CDLDiagram;
import obp.util.EventUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;
import org.xid.basics.ui.diagram.interaction.InteractionObject;

public class EventReferenceElement
extends ActivityElement {
    public static final RGB backgroundRgb = new RGB(140, 210, 250);
    private final EventReference model;
    private final int occurences;

    public EventReferenceElement(EventReference model, int occurences, float[] northPoint) {
        super(true, northPoint);
        this.model = model;
        this.occurences = occurences;
        this.size[0] = Math.max(8.0f * (float)this.getEventDescription().length(), 10.0f * (float)model.getName().length());
        this.size[1] = "*anonymous*".equals(model.getName()) ? 60.0f : 80.0f;
    }

    @Override
    public void buildChildren(CDLDiagram diagram) {
    }

    @Override
    public void display(GC gc, DiagramContext context) {
        float[] rectangle = this.getRectangle();
        float[] shadowRetangle = Geometry.copyPoints((float[])rectangle);
        gc.setForeground(context.getResources().getSystemColor(15));
        gc.setBackground(context.getResources().getSystemColor(15));
        Geometry.translatePointsBy((float[])shadowRetangle, (float)3.0f, (float)3.0f);
        GcUtils.drawRoundRectangle((GC)gc, (float[])shadowRetangle, (float)20.0f, (float)20.0f, (boolean)true);
        gc.setForeground(context.getResources().getSystemColor(2));
        gc.setBackground(context.getResources().getColor(backgroundRgb));
        GcUtils.drawRoundRectangle((GC)gc, (float[])rectangle, (float)20.0f, (float)20.0f, (boolean)true);
        FontData dataLarge = context.getResources().getSystemFont().getFontData()[0];
        dataLarge.height = 18.0f;
        gc.setFont(context.getResources().getFont(dataLarge));
        float[] center = Geometry.getRectanglePoint((float[])rectangle, (int)-1);
        if ("*anonymous*".equals(this.model.getName())) {
            GcUtils.drawStringAligned((GC)gc, (String)this.getEventDescription(), (float)center[0], (float)center[1], (int)-1);
        } else {
            GcUtils.drawStringAligned((GC)gc, (String)this.model.getName(), (float)center[0], (float)center[1], (int)-1);
            FontData dataSmall = context.getResources().getSystemFont().getFontData()[0];
            dataSmall.height = 12.0f;
            gc.setFont(context.getResources().getFont(dataSmall));
            float[] south = Geometry.getRectanglePoint((float[])rectangle, (int)2);
            GcUtils.drawStringAligned((GC)gc, (String)this.getEventDescription(), (float)south[0], (float)(south[1] - 5.0f), (int)2);
        }
        if (this.occurences > 1) {
            this.displayFrame(gc, context, null, this.occurences);
        }
        super.display(gc, context);
    }

    public void computeInteractionObjects(List<InteractionObject> result, int type, DiagramContext context) {
    }

    public boolean toolTipRequest(float[] point, DiagramContext context) {
        context.showBalloon(null, this.getEventDescription());
        return true;
    }

    @Override
    public EventReference getModel() {
        return this.model;
    }

    private String getEventDescription() {
        return EventUtil.printEvent(this.model.getReference().getIs());
    }
}

