/*
 * Decompiled with CFR 0.152.
 */
package obp.ui;

import java.io.File;
import java.util.ArrayList;
import obp.OBPModel;
import obp.ui.ExportCDLAction;
import obp.ui.OBP;
import obp.ui.OBPConfigurationController;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.xid.basics.Basics;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.controller.Controller;
import org.xid.basics.ui.dialog.FieldDialog;
import org.xid.basics.ui.field.ListField;
import org.xid.basics.ui.field.TextField;

public class Actions {
    private final OBP ui;
    private final OBPModel model;
    private Action separatorAction;
    private Action menuAction;
    private Action fileAction;
    private Action openCdlAction;
    private Action openCCSLAction;
    private Action openProgramFileAction;
    private Action exportAction;
    private Action exportScrambledProgramAction;
    private Action exportCdlAction;
    private Action clearCdlAction;
    private Action clearProgramListAction;
    private Action preferencesAction;
    private Action quitAction;
    private Action programAction;
    private Action verifyAction;
    private Action simulateAction;
    private Action stopAction;
    private Action viewAction;
    private Action showProgramSourceAction;
    private Action useDescriptionCommentAction;
    private Action clearConsoleAction;

    public Actions(OBP ui) {
        this.ui = ui;
        this.model = ui.getModel();
    }

    public Action getSeparatorAction() {
        if (this.separatorAction == null) {
            this.separatorAction = new Action.Stub(27);
        }
        return this.separatorAction;
    }

    public Action getMenuAction() {
        if (this.menuAction == null) {
            this.menuAction = new Action.Container("Menu", new Action[]{this.getFileAction(), this.getProgramAction(), this.getViewAction()});
        }
        return this.menuAction;
    }

    public Action getFileAction() {
        if (this.fileAction == null) {
            ArrayList<Action> actions2 = new ArrayList<Action>();
            actions2.add(this.getOpenCdlFileAction());
            actions2.add(this.getOpenProgramAction());
            actions2.add(this.getOpenCCSLFileAction());
            actions2.add(this.getSeparatorAction());
            actions2.add(this.getExportAction());
            actions2.add(this.getSeparatorAction());
            actions2.add(this.getClearCdlAction());
            actions2.add(this.getClearProgramListAction());
            if (!Basics.isMac()) {
                actions2.add(this.getSeparatorAction());
                actions2.add(this.getPreferencesAction());
                actions2.add(this.getSeparatorAction());
                actions2.add(this.getQuitAction());
            }
            this.fileAction = new Action.Container("File", actions2.toArray(new Action[actions2.size()]));
        }
        return this.fileAction;
    }

    public Action getOpenCdlFileAction() {
        if (this.openCdlAction == null) {
            this.openCdlAction = new Action.Stub("Open CDL File\u2026", this.getImage("eclipse/open_edit.gif")){

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                    dialog.setFilterNames(new String[]{"CDL File"});
                    dialog.setFilterExtensions(new String[]{"*.cdl"});
                    String filename = dialog.open();
                    if (filename == null) {
                        return 2;
                    }
                    File file = new File(filename);
                    if (!file.exists() || !file.canRead()) {
                        return 3;
                    }
                    Actions.this.model.setCdlFile(file);
                    Actions.this.ui.log("CDL file '" + file.getPath() + "' loaded.\n");
                    return 1;
                }
            };
        }
        return this.openCdlAction;
    }

    public Action getOpenCdlFileAction(TextField field) {
        return new Action.Stub("\u2026"){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                dialog.setFilterNames(new String[]{"CDL File"});
                dialog.setFilterExtensions(new String[]{"*.cdl"});
                String filename = dialog.open();
                if (filename == null) {
                    return 2;
                }
                File file = new File(filename);
                if (!file.exists() || !file.canRead()) {
                    return 3;
                }
                Actions.this.model.setCdlFile(file);
                Actions.this.ui.log("CDL file '" + file.getPath() + "' loaded.\n");
                return 1;
            }
        };
    }

    public Action getOpenCCSLFileAction() {
        if (this.openCCSLAction == null) {
            this.openCCSLAction = new Action.Stub("Open MoCCML LTS File\u2026", this.getImage("eclipse/open_edit.gif")){

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4096);
                    dialog.setFilterNames(new String[]{"LTS File"});
                    dialog.setFilterExtensions(new String[]{"*.lts"});
                    String filename = dialog.open();
                    if (filename == null) {
                        return 2;
                    }
                    File file = new File(filename);
                    if (!file.exists() || !file.canRead()) {
                        return 3;
                    }
                    Actions.this.model.setCCSLFile(file);
                    Actions.this.ui.log("CCSL result file '" + file.getPath() + "' loaded.\n");
                    return 1;
                }
            };
        }
        return this.openCCSLAction;
    }

    public Action getOpenProgramAction() {
        if (this.openProgramFileAction == null) {
            this.openProgramFileAction = new Action.Stub("Open Program File\u2026", this.getImage("eclipse/open_edit.gif")){

                public int run(ActionMonitor monitor) {
                    FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4098);
                    String[][] fileFilters = Actions.this.getFileFilters();
                    dialog.setFilterNames(fileFilters[0]);
                    dialog.setFilterExtensions(fileFilters[1]);
                    dialog.open();
                    if (dialog.getFileNames().length == 0) {
                        return 2;
                    }
                    Actions.this.model.clearsProgramFileList();
                    for (String oneFilename : dialog.getFileNames()) {
                        File file = new File(dialog.getFilterPath(), oneFilename);
                        if (!file.exists() || !file.canRead()) {
                            Actions.this.ui.error("Can't read file '" + file.getPath() + "'.\n");
                            continue;
                        }
                        Actions.this.model.addProgramFile(file);
                        Actions.this.ui.log("Program file '" + file.getPath() + "' added.\n");
                    }
                    return 1;
                }
            };
        }
        return this.openProgramFileAction;
    }

    String[][] getFileFilters() {
        ArrayList<String> filterNames = new ArrayList<String>();
        ArrayList<String> filterExtensions = new ArrayList<String>();
        filterNames.add("Fiacre Program");
        filterExtensions.add("*.fcr");
        if (this.ui.forABCD) {
            filterNames.add("ABCD Program");
            filterExtensions.add("*.abcd");
        }
        return new String[][]{filterNames.toArray(new String[filterNames.size()]), filterExtensions.toArray(new String[filterExtensions.size()])};
    }

    public Action getAddProgramAction(ListField<File> field) {
        return new Action.Stub("+"){

            public int run(ActionMonitor monitor) {
                FileDialog dialog = new FileDialog(Actions.this.ui.getShell(), 4098);
                String[][] fileFilters = Actions.this.getFileFilters();
                dialog.setFilterNames(fileFilters[0]);
                dialog.setFilterExtensions(fileFilters[1]);
                dialog.open();
                if (dialog.getFileNames().length == 0) {
                    return 2;
                }
                for (String oneFilename : dialog.getFileNames()) {
                    File file = new File(dialog.getFilterPath(), oneFilename);
                    if (!file.exists() || !file.canRead()) {
                        Actions.this.ui.error("Can't read file '" + file.getPath() + "'.\n");
                        continue;
                    }
                    Actions.this.model.addProgramFile(file);
                    Actions.this.ui.log("Program file '" + file.getPath() + "' added.\n");
                }
                return 1;
            }
        };
    }

    public Action getRemoveProgramAction(final ListField<File> field) {
        return new Action.Stub("-"){

            public int getVisibility() {
                return field.getSingleSelection() != null ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                File file = (File)field.getSingleSelection();
                Actions.this.model.removeProgramFile(file);
                Actions.this.ui.log("Program file '" + file.getPath() + "' removed.\n");
                return 1;
            }
        };
    }

    public Action getUpProgramAction(final ListField<File> field) {
        return new Action.Stub("^"){

            public int getVisibility() {
                File file = (File)field.getSingleSelection();
                return Actions.this.model.canUpProgramFile(file) ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                File file = (File)field.getSingleSelection();
                Actions.this.model.upProgramFile(file);
                return 1;
            }
        };
    }

    public Action getDownProgramAction(final ListField<File> field) {
        return new Action.Stub("v"){

            public int getVisibility() {
                File file = (File)field.getSingleSelection();
                return Actions.this.model.canDownProgramFile(file) ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                File file = (File)field.getSingleSelection();
                Actions.this.model.downProgramFile(file);
                return 1;
            }
        };
    }

    public Action getExportAction() {
        if (this.exportAction == null) {
            this.exportAction = new Action.Container("Export", this.ui.getResources().getImage("eclipse/export_wiz.gif"), 26, new Action[]{this.getExportScrambledProgramAction(), this.getSeparatorAction(), this.getExportCdlAction()});
        }
        return this.exportAction;
    }

    public Action getExportScrambledProgramAction() {
        if (this.exportScrambledProgramAction == null) {
            this.exportScrambledProgramAction = new Action.Stub("Scrambled Program"){

                public int getVisibility() {
                    return Actions.this.model.getProgramFileList().isEmpty() ? 2 : 1;
                }

                public int run(ActionMonitor monitor) {
                    try {
                        Actions.this.model.exportScrambledProgram();
                    }
                    catch (Exception e) {
                        Actions.this.ui.error(DiagnosticUtil.createMessage((Throwable)e));
                        return 3;
                    }
                    return 1;
                }
            };
        }
        return this.exportScrambledProgramAction;
    }

    public Action getExportCdlAction() {
        if (this.exportCdlAction == null) {
            this.exportCdlAction = new ExportCDLAction(this.ui, this.model);
        }
        return this.exportCdlAction;
    }

    public Action getClearCdlAction() {
        if (this.clearCdlAction == null) {
            this.clearCdlAction = new Action.Stub("Clear CDL file", this.getImage("eclipse/clear.gif")){

                public int getVisibility() {
                    return Actions.this.model.getCdlFile() != null ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.model.setCdlFile(null);
                    return 1;
                }
            };
        }
        return this.clearCdlAction;
    }

    public Action getClearProgramListAction() {
        if (this.clearProgramListAction == null) {
            this.clearProgramListAction = new Action.Stub("Clear Program list", this.getImage("eclipse/clear.gif")){

                public int getVisibility() {
                    return Actions.this.model.getProgramFileList().size() > 0 ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.model.clearsProgramFileList();
                    return 1;
                }
            };
        }
        return this.clearProgramListAction;
    }

    public Action getClearProgramListAction(ListField<File> field) {
        return new Action.Stub("", this.getImage("eclipse/clear.gif")){

            public int getVisibility() {
                return Actions.this.model.getProgramFileList().size() > 0 ? 1 : 2;
            }

            public int run(ActionMonitor monitor) {
                Actions.this.model.clearsProgramFileList();
                return 1;
            }
        };
    }

    public Action getPreferencesAction() {
        if (this.preferencesAction == null) {
            this.preferencesAction = new Action.Stub("Preferences"){

                public int run(ActionMonitor monitor) {
                    OBPConfigurationController configurationController = new OBPConfigurationController(Actions.this.ui.getShell());
                    configurationController.setSubject(Actions.this.ui.getConfiguration());
                    FieldDialog dialog = new FieldDialog(Actions.this.ui.getShell(), "OBP", "Configuration", 6, (Controller)configurationController);
                    dialog.setButtonLabel(new String[]{"Ok"});
                    dialog.open();
                    return 1;
                }
            };
        }
        return this.preferencesAction;
    }

    public Action getQuitAction() {
        if (this.quitAction == null) {
            this.quitAction = new Action.Stub("Quit OBP"){

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.getShell().dispose();
                    System.exit(0);
                    return 1;
                }
            };
        }
        return this.quitAction;
    }

    public Action getProgramAction() {
        if (this.programAction == null) {
            this.programAction = new Action.Container("Program", new Action[]{this.getVerifyAction(), this.getSeparatorAction(), this.getStopAction()});
        }
        return this.programAction;
    }

    public Action getVerifyAction() {
        if (this.verifyAction == null) {
            this.verifyAction = new Action.Stub("Verify"){

                public int getVisibility() {
                    return Actions.this.ui.canVerify() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.verify();
                    return 1;
                }
            };
        }
        return this.verifyAction;
    }

    public Action getSimulateAction() {
        if (this.simulateAction == null) {
            this.simulateAction = new Action.Stub("Simulation"){

                public int getVisibility() {
                    return Actions.this.ui.canVerify() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.runSimulation();
                    return 1;
                }
            };
        }
        return this.simulateAction;
    }

    public Action getStopAction() {
        if (this.stopAction == null) {
            this.stopAction = new Action.Stub("Stop"){

                public int getVisibility() {
                    return Actions.this.ui.isWorking() ? 1 : 2;
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.stopCurrentAction();
                    return 1;
                }
            };
        }
        return this.stopAction;
    }

    public Action getViewAction() {
        if (this.viewAction == null) {
            this.viewAction = new Action.Container("View", new Action[]{this.getShowProgramSourceAction(), this.getUseDescriptionCommentAction(), this.getSeparatorAction(), this.getClearConsoleAction()});
        }
        return this.viewAction;
    }

    public Action getShowProgramSourceAction() {
        if (this.showProgramSourceAction == null) {
            this.showProgramSourceAction = new Action.Stub("Show Program Source", 282){

                public boolean getState() {
                    return Actions.this.ui.isShowPogramSource();
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.showProgramSource(!Actions.this.ui.isShowPogramSource());
                    return 1;
                }
            };
        }
        return this.showProgramSourceAction;
    }

    public Action getUseDescriptionCommentAction() {
        if (this.useDescriptionCommentAction == null) {
            this.useDescriptionCommentAction = new Action.Stub("Use description comments in graphs", 282){

                public boolean getState() {
                    return Actions.this.ui.isUseDescription();
                }

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.setUseDescription(!Actions.this.ui.isUseDescription());
                    return 1;
                }
            };
        }
        return this.useDescriptionCommentAction;
    }

    public Action getClearConsoleAction() {
        if (this.clearConsoleAction == null) {
            this.clearConsoleAction = new Action.Stub("Clear console", 10){

                public int run(ActionMonitor monitor) {
                    Actions.this.ui.clearConsole();
                    return 1;
                }
            };
        }
        return this.clearConsoleAction;
    }

    public Image getImage(String filename) {
        return this.ui.getResources().getImage(filename);
    }
}

