/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.transfo;

import java.util.Stack;
import obp.fiacre.model.BinExp;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Literal;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.UnExp;

public class FiacreStaticEvaluator
extends ModelVisitor.Stub {
    private static FiacreStaticEvaluator instance = new FiacreStaticEvaluator();
    private Stack<Exp> objectStack = new Stack();
    static final BoolLiteral trueLit = FiacreStaticEvaluator.trueLit();
    static final BoolLiteral falseLit = FiacreStaticEvaluator.falseLit();

    public static Literal evaluate(Exp exp) {
        return instance.eval(exp);
    }

    public Literal eval(Exp exp) {
        exp.accept(this);
        if (this.objectStack.isEmpty()) {
            return null;
        }
        return this.pop(Literal.class);
    }

    public <T> T peekObject(Class<T> type) {
        Exp node = this.objectStack.peek();
        return type.cast(node);
    }

    public <T> T pop(Class<T> type) {
        Exp node = this.objectStack.pop();
        return type.cast(node);
    }

    public Exp push(Exp node) {
        this.objectStack.push(node);
        return node;
    }

    @Override
    public void visitUnExp(UnExp exp) {
        exp.getExp().accept(this);
        Literal lit = this.pop(Literal.class);
        Literal result = null;
        switch (exp.getUnop()) {
            case UMINUS: {
                if (lit instanceof NatLiteral) {
                    result = new NatLiteral();
                    ((NatLiteral)result).setValue(-((NatLiteral)lit).getValue());
                    break;
                }
                System.err.println("Incorrect usage of unary minus on non integer expression");
                break;
            }
            case UNOT: {
                if (lit instanceof BoolLiteral) {
                    result = new BoolLiteral();
                    ((BoolLiteral)result).setValue(!((BoolLiteral)lit).isValue());
                    break;
                }
                System.err.println("Incorrect negation of non boolean expression");
                break;
            }
        }
        this.push(result);
    }

    static BoolLiteral trueLit() {
        BoolLiteral lit = new BoolLiteral();
        lit.setValue(true);
        return lit;
    }

    static BoolLiteral falseLit() {
        BoolLiteral lit = new BoolLiteral();
        lit.setValue(false);
        return lit;
    }

    @Override
    public void visitBinExp(BinExp exp) {
        boolean areInts;
        exp.getLeft().accept(this);
        Literal lhsl = this.pop(Literal.class);
        exp.getRight().accept(this);
        Literal rhsl = this.pop(Literal.class);
        Literal result = null;
        boolean areBoolean = lhsl instanceof BoolLiteral && rhsl instanceof BoolLiteral;
        boolean bl = areInts = lhsl instanceof NatLiteral && rhsl instanceof NatLiteral;
        if (areInts) {
            int lhs = ((NatLiteral)lhsl).getValue();
            int rhs = ((NatLiteral)rhsl).getValue();
            switch (exp.getBinOp()) {
                case BADD: {
                    result = new NatLiteral();
                    result.setValue(lhs + rhs);
                    break;
                }
                case BDIV: {
                    result = new NatLiteral();
                    result.setValue(lhs / rhs);
                    break;
                }
                case BEQ: {
                    result = lhs == rhs ? trueLit : falseLit;
                    break;
                }
                case BGE: {
                    result = lhs >= rhs ? trueLit : falseLit;
                    break;
                }
                case BGT: {
                    result = lhs > rhs ? trueLit : falseLit;
                    break;
                }
                case BLE: {
                    result = lhs <= rhs ? trueLit : falseLit;
                    break;
                }
                case BLT: {
                    result = lhs < rhs ? trueLit : falseLit;
                    break;
                }
                case BMINUS: {
                    result = new NatLiteral();
                    result.setValue(lhs - rhs);
                    break;
                }
                case BMOD: {
                    result = new NatLiteral();
                    result.setValue(lhs % rhs);
                    break;
                }
                case BMUL: {
                    result = new NatLiteral();
                    result.setValue(lhs * rhs);
                    break;
                }
                case BNE: {
                    result = lhs != rhs ? trueLit : falseLit;
                    break;
                }
            }
        } else if (areBoolean) {
            boolean lhs = ((BoolLiteral)lhsl).isValue();
            boolean rhs = ((BoolLiteral)lhsl).isValue();
            switch (exp.getBinOp()) {
                case BAND: {
                    result = lhs && rhs ? trueLit : falseLit;
                    break;
                }
                case BEQ: {
                    result = lhs == rhs ? trueLit : falseLit;
                    break;
                }
                case BNE: {
                    result = lhs != rhs ? trueLit : falseLit;
                    break;
                }
                case BOR: {
                    result = lhs || rhs ? trueLit : falseLit;
                    break;
                }
            }
        } else {
            System.err.println("Incorrect binary expression");
        }
        this.push(result);
    }

    @Override
    public void visitConstantDecl(ConstantDecl d) {
        d.getValue().accept(this);
    }

    @Override
    public void visitNatLiteral(NatLiteral l) {
        this.push(l);
    }

    @Override
    public void visitBoolLiteral(BoolLiteral l) {
        this.push(l);
    }

    @Override
    public void visitConstantRef(ConstantRef l) {
        l.getDecl().accept(this);
    }
}

