/*
 * Decompiled with CFR 0.152.
 */
package plug.statespace.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.statespace.ITransitionStorage;

public class ParentTransitionStorage<C extends IConfiguration, A>
implements ITransitionStorage<C, A> {
    Map<C, IFiredTransition<C, A>> parent = new HashMap<C, IFiredTransition<C, A>>();

    @Override
    public IFiredTransition put(IFiredTransition<C, A> transition) {
        IFiredTransition<C, A> v = null;
        for (IConfiguration target : transition.getTargets()) {
            v = this.parent.putIfAbsent(target, transition);
        }
        return v;
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public C getParent(C configuration) {
        return (C)((IConfiguration)this.parent.get(configuration).getSource());
    }

    @Override
    public Collection<IFiredTransition<C, A>> getFiredFrom(C configuration) {
        for (Map.Entry<C, IFiredTransition<C, A>> entry : this.parent.entrySet()) {
            if (entry.getValue().getSource() != configuration) continue;
            return Collections.singletonList(entry.getValue());
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IFiredTransition<C, A>> getFiredTo(C configuration) {
        IFiredTransition<C, A> transition = this.parent.get(configuration);
        return transition != null ? Collections.singleton(transition) : Collections.emptyList();
    }

    @Override
    public int getEdgeCount() {
        return this.size();
    }
}

