/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer.buchi.nested_dfs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import plug.core.IBuchiConfiguration;
import plug.core.IConfiguration;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.events.ExecutionEndedEvent;
import plug.events.PropertyEvent;
import plug.explorer.buchi.DefaultExecutionController;
import plug.explorer.buchi.nested_dfs.Color;

public class BA_GaiserSchwoon_Iterative<C extends IBuchiConfiguration & IConfiguration, A>
extends DefaultExecutionController<C, A> {
    protected boolean propertyFailed = false;
    protected final Stack<StackEntry<C>> redStack = new Stack();
    protected final Stack<StackEntry<C>> blueStack = new Stack();

    public BA_GaiserSchwoon_Iterative(ITransitionRelation<C, A> runtime, IStateSpaceManager stateSpaceManager) {
        super(runtime, stateSpaceManager);
    }

    @Override
    public Supplier getMetadataSupplier() {
        return () -> Color.WHITE;
    }

    @Override
    public void execute() {
        try {
            for (IBuchiConfiguration c : this.getProductAutomaton().initialConfigurationsIterable()) {
                this.dfs_blue(c);
            }
        }
        finally {
            if (!this.propertyFailed) {
                this.announcer.announce(new PropertyEvent(this, true, "property", null));
            }
            this.announcer.announce(new ExecutionEndedEvent((IExecutionController)this));
        }
    }

    protected void dfs_blue(C source) {
        this.blueStack.push(new StackEntry<C>(source));
        while (!this.monitor.atEnd() && !this.blueStack.isEmpty()) {
            StackEntry entry = this.blueStack.peek();
            Iterator<C> postIterator = entry.getPostIterator();
            if (postIterator == null) {
                entry.allRed = true;
                this.setColor((IBuchiConfiguration)entry.config, Color.CYAN);
                postIterator = this.getProductAutomaton().getPostIterable(entry.config).iterator();
                entry.setPostIterator(postIterator);
            }
            IBuchiConfiguration target = null;
            if (postIterator.hasNext()) {
                target = (IBuchiConfiguration)postIterator.next();
                if (this.getColor(target) == Color.WHITE) {
                    this.blueStack.push(new StackEntry<IBuchiConfiguration>(target));
                    continue;
                }
                if (this.getColor(target) == Color.CYAN && (source.isAccepting() || target.isAccepting())) {
                    this.propertyFailed = true;
                    this.announcer.announce(new PropertyEvent(this, false, "property", this.counterExample(target)));
                    break;
                }
                if (this.getColor(target) == Color.RED) continue;
                this.blueStack.peek().allRed = false;
                continue;
            }
            StackEntry<C> child = this.blueStack.pop();
            if (this.getColor((IBuchiConfiguration)child.config) != Color.RED && !this.blueStack.isEmpty()) {
                this.blueStack.peek().allRed = false;
            }
            if (entry.allRed) {
                this.setColor((IBuchiConfiguration)entry.config, Color.RED);
                continue;
            }
            if (((IBuchiConfiguration)entry.config).isAccepting()) {
                this.dfs_red((IBuchiConfiguration)entry.config);
                this.setColor((IBuchiConfiguration)entry.config, Color.RED);
                continue;
            }
            this.setColor((IBuchiConfiguration)entry.config, Color.BLUE);
        }
    }

    protected void dfs_red(C source) {
        this.redStack.push(new StackEntry<C>(source));
        while (!this.monitor.atEnd() && !this.redStack.isEmpty()) {
            StackEntry entry = this.redStack.peek();
            Iterator<C> postIterator = entry.getPostIterator();
            if (postIterator == null) {
                postIterator = this.getProductAutomaton().getPostIterable(entry.config).iterator();
                entry.setPostIterator(postIterator);
            }
            IBuchiConfiguration target = null;
            if (postIterator.hasNext()) {
                target = (IBuchiConfiguration)postIterator.next();
                if (this.getColor(target) == Color.CYAN) {
                    this.announcer.announce(new PropertyEvent(this, false, "property", this.counterExample(target)));
                    this.propertyFailed = true;
                    continue;
                }
                if (this.getColor(target) != Color.BLUE) continue;
                this.setColor(target, Color.RED);
                this.redStack.push(new StackEntry<IBuchiConfiguration>(target));
                continue;
            }
            this.redStack.pop();
        }
    }

    protected Color getColor(C configuration) {
        return (Color)((Object)((IConfiguration)configuration).getMetadata());
    }

    protected void setColor(C configuration, Color color) {
        ((IConfiguration)configuration).setMetadata((Object)color);
    }

    protected List<IConfiguration> counterExample(C target) {
        ArrayList<IConfiguration> result = new ArrayList<IConfiguration>();
        result.addAll(this.redStack.stream().map(e -> (IBuchiConfiguration)e.config).collect(Collectors.toList()));
        result.addAll(this.blueStack.stream().map(e -> (IBuchiConfiguration)e.config).collect(Collectors.toList()));
        result.add((IConfiguration)target);
        return result;
    }

    protected static class StackEntry<C> {
        protected final C config;
        boolean allRed = true;
        private Iterator<C> postIterator;

        public StackEntry(C configuration) {
            this.config = configuration;
        }

        public void setPostIterator(Iterator<C> postIterator) {
            this.postIterator = postIterator;
        }

        public Iterator<C> getPostIterator() {
            return this.postIterator;
        }
    }
}

