/*
 * Decompiled with CFR 0.152.
 */
package plug.core.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ConfigurationItem
implements Iterable<ConfigurationItem> {
    protected final String name;
    protected final String type;
    protected final String icon;
    protected final List<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
    protected boolean different = false;
    protected boolean expanded = false;

    public ConfigurationItem(String type, String name, String icon, List<ConfigurationItem> children) {
        this.name = name;
        this.type = type;
        this.icon = icon;
        if (children != null) {
            this.children.addAll(children);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isDifferent() {
        return this.different;
    }

    public void setDifferent(boolean different) {
        this.different = different;
    }

    @Override
    public Iterator<ConfigurationItem> iterator() {
        return this.children.iterator();
    }

    public List<ConfigurationItem> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isDifferentFrom(ConfigurationItem other) {
        return !Objects.equals(this.name, other.name) || !Objects.equals(this.type, other.type);
    }

    public boolean updateDifferentStatus(ConfigurationItem other) {
        if (other == null) {
            this.different = false;
        } else {
            List<ConfigurationItem> otherChildren = other.getChildren();
            this.different = this.isDifferentFrom(other);
            this.different |= this.children.size() != otherChildren.size();
            for (int i = 0; i < this.children.size(); ++i) {
                ConfigurationItem otherChild;
                ConfigurationItem confChild = this.children.get(i);
                ConfigurationItem configurationItem = otherChild = i < otherChildren.size() ? otherChildren.get(i) : null;
                if (otherChild != null) {
                    this.different |= confChild.updateDifferentStatus(otherChild);
                    continue;
                }
                confChild.setDifferent(true);
                this.different = true;
            }
        }
        return this.different;
    }

    public String toString() {
        return this.name;
    }
}

